/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.bytecodemetadata;

import com.android.tools.r8.graph.bytecodemetadata.BytecodeInstructionMetadata;
import com.android.tools.r8.graph.bytecodemetadata.BytecodeMetadataProvider;
import com.android.tools.r8.ir.code.Instruction;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;

public class BytecodeMetadata<I> {
    private static final BytecodeMetadata<?> EMPTY = new BytecodeMetadata(Collections.emptyMap());
    private final Map<I, BytecodeInstructionMetadata> backing;

    BytecodeMetadata(Map<I, BytecodeInstructionMetadata> backing) {
        assert (backing.values().stream().noneMatch(Objects::isNull));
        this.backing = backing;
    }

    public static <I> Builder<I> builder(BytecodeMetadataProvider bytecodeMetadataProvider) {
        return new Builder(bytecodeMetadataProvider);
    }

    public static <I> BytecodeMetadata<I> empty() {
        return EMPTY;
    }

    public BytecodeInstructionMetadata getMetadata(I bytecodeInstruction) {
        return this.backing.get(bytecodeInstruction);
    }

    public static class Builder<I> {
        private final BytecodeMetadataProvider bytecodeMetadataProvider;
        private final Map<I, BytecodeInstructionMetadata> backing = new IdentityHashMap<I, BytecodeInstructionMetadata>();

        Builder(BytecodeMetadataProvider bytecodeMetadataProvider) {
            this.bytecodeMetadataProvider = bytecodeMetadataProvider;
        }

        public Builder<I> setMetadata(Instruction irInstruction, I bytecodeInstruction) {
            BytecodeInstructionMetadata instructionMetadata = this.bytecodeMetadataProvider.getMetadata(irInstruction);
            if (instructionMetadata != null) {
                this.backing.put(bytecodeInstruction, instructionMetadata);
            }
            return this;
        }

        public BytecodeMetadata<I> build() {
            return this.backing.isEmpty() ? BytecodeMetadata.empty() : new BytecodeMetadata<I>(this.backing);
        }

        public boolean verifyNoMetadata(Instruction irInstruction) {
            assert (this.bytecodeMetadataProvider.getMetadata(irInstruction) == null);
            return true;
        }
    }
}

