/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.proto;

import com.android.tools.r8.graph.proto.ArgumentPermutationMap;
import com.android.tools.r8.graph.proto.DefaultArgumentPermutation;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.AbstractInt2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;

public abstract class ArgumentPermutation {
    public static Builder builder(int size) {
        return new Builder(size);
    }

    public static DefaultArgumentPermutation getDefault() {
        return DefaultArgumentPermutation.get();
    }

    public abstract int getNewArgumentIndex(int var1);

    public boolean isDefault() {
        return false;
    }

    public static class Builder {
        private final Int2IntMap newArgumentIndices;

        private Builder(int size) {
            AbstractInt2IntMap newArgumentIndices = size <= 30 ? new Int2IntArrayMap() : new Int2IntOpenHashMap();
            newArgumentIndices.defaultReturnValue(-1);
            this.newArgumentIndices = newArgumentIndices;
        }

        public boolean isDefault() {
            return this.newArgumentIndices.isEmpty();
        }

        public Builder setNewArgumentIndex(int argumentIndex, int newArgumentIndex) {
            if (argumentIndex != newArgumentIndex) {
                this.newArgumentIndices.put(argumentIndex, newArgumentIndex);
            } else {
                this.newArgumentIndices.remove(argumentIndex);
            }
            return this;
        }

        public ArgumentPermutation build() {
            if (this.isDefault()) {
                return ArgumentPermutation.getDefault();
            }
            return new ArgumentPermutationMap(this.newArgumentIndices);
        }
    }
}

