/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.proto;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.proto.ArgumentInfo;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Objects;

public class RemovedArgumentInfo
extends ArgumentInfo {
    private final SingleValue singleValue;
    private final DexType type;

    RemovedArgumentInfo(SingleValue singleValue, DexType type) {
        assert (type != null);
        this.singleValue = singleValue;
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasSingleValue() {
        return this.singleValue != null;
    }

    public SingleValue getSingleValue() {
        return this.singleValue;
    }

    public DexType getType() {
        return this.type;
    }

    @Override
    public boolean isRemovedArgumentInfo() {
        return true;
    }

    @Override
    public RemovedArgumentInfo asRemovedArgumentInfo() {
        return this;
    }

    @Override
    public ArgumentInfo combine(ArgumentInfo info) {
        assert (false) : "Once the argument is removed one cannot modify it any further.";
        return this;
    }

    @Override
    public RemovedArgumentInfo rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens graphLens, GraphLens codeLens) {
        AbstractValue rewrittenSingleValue = this.hasSingleValue() ? this.singleValue.rewrittenWithLens((AppView)appView, graphLens, codeLens) : null;
        DexType rewrittenType = graphLens.lookupType(this.type, codeLens);
        if (rewrittenSingleValue != this.singleValue || rewrittenType != this.type) {
            return new RemovedArgumentInfo((SingleValue)rewrittenSingleValue, rewrittenType);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RemovedArgumentInfo other = (RemovedArgumentInfo)obj;
        return this.type == other.type && Objects.equals(this.singleValue, other.singleValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.singleValue, this.type);
    }

    public static class Builder
    extends BuilderBase<Builder> {
        public RemovedArgumentInfo build() {
            return new RemovedArgumentInfo(this.singleValue, this.type);
        }

        @Override
        Builder self() {
            return this;
        }
    }

    static abstract class BuilderBase<B extends BuilderBase<B>> {
        SingleValue singleValue;
        DexType type;

        BuilderBase() {
        }

        public B setSingleValue(SingleValue singleValue) {
            this.singleValue = singleValue;
            return this.self();
        }

        public B setType(DexType type) {
            this.type = type;
            return this.self();
        }

        abstract B self();
    }
}

