/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.proto;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.proto.ArgumentInfo;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Objects;
import java.util.function.Consumer;

public class RewrittenTypeInfo
extends ArgumentInfo {
    private final DexType castType;
    private final DexType oldType;
    private final DexType newType;
    private final SingleValue singleValue;

    public static Builder builder() {
        return new Builder();
    }

    private RewrittenTypeInfo(DexType oldType, DexType newType, DexType castType, SingleValue singleValue) {
        this.castType = castType;
        this.oldType = oldType;
        this.newType = newType;
        this.singleValue = singleValue;
    }

    public RewrittenTypeInfo combine(RewrittenPrototypeDescription other) {
        return other.hasRewrittenReturnInfo() ? this.combine(other.getRewrittenReturnInfo()) : this;
    }

    public DexType getCastType() {
        return this.castType;
    }

    public DexType getNewType() {
        return this.newType;
    }

    public DexType getOldType() {
        return this.oldType;
    }

    public SingleValue getSingleValue() {
        return this.singleValue;
    }

    boolean hasBeenChangedToReturnVoid() {
        return this.newType.isVoidType();
    }

    public boolean hasCastType() {
        return this.castType != null;
    }

    public boolean hasSingleValue() {
        return this.singleValue != null;
    }

    @Override
    public boolean isRewrittenTypeInfo() {
        return true;
    }

    @Override
    public RewrittenTypeInfo asRewrittenTypeInfo() {
        return this;
    }

    @Override
    public ArgumentInfo combine(ArgumentInfo info) {
        if (info.isRemovedArgumentInfo()) {
            return info;
        }
        assert (info.isRewrittenTypeInfo());
        return this.combine(info.asRewrittenTypeInfo());
    }

    public RewrittenTypeInfo combine(RewrittenTypeInfo other) {
        assert (!this.getNewType().isVoidType());
        assert (this.getNewType() == other.getOldType());
        return new RewrittenTypeInfo(this.getOldType(), other.getNewType(), this.getCastType(), other.getSingleValue());
    }

    @Override
    public RewrittenTypeInfo rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens graphLens, GraphLens codeLens) {
        AbstractValue rewrittenSingleValue;
        DexType rewrittenCastType = this.castType != null ? graphLens.lookupType(this.castType, codeLens) : null;
        DexType rewrittenNewType = graphLens.lookupType(this.newType, codeLens);
        AbstractValue abstractValue = rewrittenSingleValue = this.hasSingleValue() ? this.getSingleValue().rewrittenWithLens((AppView)appView, graphLens, codeLens) : null;
        if (rewrittenCastType != this.castType || rewrittenNewType != this.newType || rewrittenSingleValue != this.singleValue) {
            return new RewrittenTypeInfo(this.oldType, rewrittenNewType, rewrittenCastType, (SingleValue)rewrittenSingleValue);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RewrittenTypeInfo other = (RewrittenTypeInfo)obj;
        return this.oldType == other.oldType && this.newType == other.newType && Objects.equals(this.singleValue, other.singleValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.oldType, this.newType, this.singleValue);
    }

    public static class Builder {
        private DexType castType;
        private DexType oldType;
        private DexType newType;
        private SingleValue singleValue;

        public Builder applyIf(boolean condition, Consumer<Builder> consumer) {
            if (condition) {
                consumer.accept(this);
            }
            return this;
        }

        public Builder setCastType(DexType castType) {
            this.castType = castType;
            return this;
        }

        public Builder setOldType(DexType oldType) {
            this.oldType = oldType;
            return this;
        }

        public Builder setNewType(DexType newType) {
            this.newType = newType;
            return this;
        }

        public Builder setSingleValue(SingleValue singleValue) {
            this.singleValue = singleValue;
            return this;
        }

        public RewrittenTypeInfo build() {
            return new RewrittenTypeInfo(this.oldType, this.newType, this.castType, this.singleValue);
        }
    }
}

