/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMergerGraphLens;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClassStaticFieldsMerger {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final MergeGroup group;
    private final HorizontalClassMergerGraphLens.Builder lensBuilder;
    private final Map<DexField, DexEncodedField> targetFields = new LinkedHashMap<DexField, DexEncodedField>();

    public ClassStaticFieldsMerger(AppView<?> appView, HorizontalClassMergerGraphLens.Builder lensBuilder, MergeGroup group) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.group = group;
        this.lensBuilder = lensBuilder;
    }

    private boolean isFresh(DexField fieldReference) {
        if (this.group.getTarget().lookupField(fieldReference) != null) {
            return false;
        }
        return !this.targetFields.containsKey(fieldReference);
    }

    private void addField(DexEncodedField field) {
        DexField oldFieldReference = (DexField)field.getReference();
        DexField newFieldReference = this.dexItemFactory.createFreshFieldNameWithoutHolder(this.group.getTarget().getType(), field.getType(), field.getName().toString(), this::isFresh);
        field = field.toTypeSubstitutedField(this.appView, newFieldReference);
        this.targetFields.put(newFieldReference, field);
        this.lensBuilder.recordNewFieldSignature(oldFieldReference, newFieldReference);
    }

    public void addFields(DexProgramClass toMerge) {
        toMerge.forEachStaticField(this::addField);
    }

    public void merge() {
        this.group.getTarget().appendStaticFields(this.targetFields.values());
    }
}

