/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.synthetic.SyntheticSourceCode;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.utils.IntBox;
import java.util.ArrayList;

public class ConstructorEntryPoint
extends SyntheticSourceCode {
    private final DexField classIdField;
    private final Int2ReferenceSortedMap<DexMethod> typeConstructors;

    public ConstructorEntryPoint(Int2ReferenceSortedMap<DexMethod> typeConstructors, DexMethod newConstructor, DexField classIdField, Position callerPosition, DexMethod originalMethod) {
        super(newConstructor.holder, newConstructor, callerPosition, originalMethod);
        this.typeConstructors = typeConstructors;
        this.classIdField = classIdField;
    }

    private boolean hasClassIdField() {
        return this.classIdField != null;
    }

    void addConstructorInvoke(DexMethod typeConstructor) {
        this.add(builder -> {
            ArrayList<Value> arguments = new ArrayList<Value>(typeConstructor.getArity() + 1);
            arguments.add(builder.getReceiverValue());
            for (int i = 0; i < typeConstructor.getArity(); ++i) {
                arguments.add(builder.getArgumentValues().get(i));
            }
            builder.addInvoke(Invoke.Type.DIRECT, typeConstructor, typeConstructor.proto, arguments, false);
        });
    }

    void addRegisterClassIdAssignment(int idRegister) {
        assert (this.hasClassIdField());
        this.add(builder -> builder.addInstancePut(idRegister, this.getReceiverRegister(), this.classIdField));
    }

    void addConstantRegisterClassIdAssignment(int classId) {
        assert (this.hasClassIdField());
        int idRegister = this.nextRegister(ValueType.INT);
        this.add(builder -> builder.addIntConst(idRegister, classId));
        this.addRegisterClassIdAssignment(idRegister);
    }

    protected void prepareMultiConstructorInstructions() {
        int typeConstructorCount = this.typeConstructors.size();
        DexMethod exampleTargetConstructor = (DexMethod)this.typeConstructors.values().iterator().next();
        int idRegister = this.getParamRegister(exampleTargetConstructor.getArity());
        if (this.hasClassIdField()) {
            this.addRegisterClassIdAssignment(idRegister);
        }
        int[] keys2 = new int[typeConstructorCount - 1];
        int[] offsets = new int[typeConstructorCount - 1];
        IntBox fallthrough = new IntBox();
        int switchIndex = this.lastInstructionIndex();
        this.add(builder -> builder.addSwitch(idRegister, keys2, fallthrough.get(), offsets), builder -> this.endsSwitch((IRBuilder)builder, switchIndex, fallthrough.get(), offsets));
        int index = 0;
        for (Int2ReferenceMap.Entry entry : this.typeConstructors.int2ReferenceEntrySet()) {
            int classId = entry.getIntKey();
            DexMethod typeConstructor = (DexMethod)entry.getValue();
            if (index == 0) {
                fallthrough.set(this.nextInstructionIndex());
            } else {
                keys2[index - 1] = classId;
                offsets[index - 1] = this.nextInstructionIndex();
            }
            this.addConstructorInvoke(typeConstructor);
            this.add(IRBuilder::addReturn, endsBlock);
            ++index;
        }
    }

    protected void prepareSingleConstructorInstructions() {
        Int2ReferenceMap.Entry entry = (Int2ReferenceMap.Entry)this.typeConstructors.int2ReferenceEntrySet().first();
        if (this.hasClassIdField()) {
            this.addConstantRegisterClassIdAssignment(entry.getIntKey());
        }
        this.addConstructorInvoke((DexMethod)entry.getValue());
        this.add(IRBuilder::addReturn, endsBlock);
    }

    @Override
    protected void prepareInstructions() {
        if (this.typeConstructors.size() > 1) {
            this.prepareMultiConstructorInstructions();
        } else {
            this.prepareSingleConstructorInstructions();
        }
    }
}

