/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.horizontalclassmerging.ClassMerger;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMergerGraphLens;
import com.android.tools.r8.horizontalclassmerging.HorizontallyMergedClasses;
import com.android.tools.r8.horizontalclassmerging.IRCodeProvider;
import com.android.tools.r8.horizontalclassmerging.IncompleteHorizontalClassMergerCode;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.Policy;
import com.android.tools.r8.horizontalclassmerging.PolicyExecutor;
import com.android.tools.r8.horizontalclassmerging.PolicyScheduler;
import com.android.tools.r8.horizontalclassmerging.SyntheticArgumentClass;
import com.android.tools.r8.horizontalclassmerging.TreeFixer;
import com.android.tools.r8.horizontalclassmerging.VirtuallyMergedMethodsKeepInfo;
import com.android.tools.r8.horizontalclassmerging.code.SyntheticInitializerConverter;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.FieldAccessInfoCollectionModifier;
import com.android.tools.r8.shaking.RuntimeTypeCheckInfo;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class HorizontalClassMerger {
    private final AppView<?> appView;
    private final Mode mode;
    private final InternalOptions.HorizontalClassMergerOptions options;

    private HorizontalClassMerger(AppView<?> appView, Mode mode) {
        this.appView = appView;
        this.mode = mode;
        this.options = appView.options().horizontalClassMergerOptions();
    }

    public static HorizontalClassMerger createForInitialClassMerging(AppView<AppInfoWithLiveness> appView) {
        return new HorizontalClassMerger(appView, Mode.INITIAL);
    }

    public static HorizontalClassMerger createForFinalClassMerging(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return new HorizontalClassMerger(appView, Mode.FINAL);
    }

    public static HorizontalClassMerger createForD8ClassMerging(AppView<?> appView) {
        assert (appView.options().horizontalClassMergerOptions().isRestrictedToSynthetics());
        return new HorizontalClassMerger(appView, Mode.FINAL);
    }

    private void run(RuntimeTypeCheckInfo runtimeTypeCheckInfo, IRCodeProvider codeProvider, ExecutorService executorService, Timing timing) throws ExecutionException {
        List<Policy> policies = PolicyScheduler.getPolicies(this.appView, codeProvider, this.mode, runtimeTypeCheckInfo);
        Collection<MergeGroup> groups2 = new PolicyExecutor().run(this.getInitialGroups(), policies, executorService, timing);
        if (groups2.isEmpty()) {
            this.appView.setHorizontallyMergedClasses(HorizontallyMergedClasses.empty(), this.mode);
            return;
        }
        HorizontalClassMergerGraphLens.Builder lensBuilder = new HorizontalClassMergerGraphLens.Builder();
        List<ClassMerger> classMergers = this.initializeClassMergers(codeProvider, lensBuilder, groups2);
        SyntheticArgumentClass syntheticArgumentClass = this.mode.isInitial() ? new SyntheticArgumentClass.Builder(this.appView.withLiveness()).build(groups2) : null;
        SyntheticInitializerConverter.Builder syntheticInitializerConverterBuilder = SyntheticInitializerConverter.builder(this.appView, codeProvider);
        ArrayList<VirtuallyMergedMethodsKeepInfo> virtuallyMergedMethodsKeepInfos = new ArrayList<VirtuallyMergedMethodsKeepInfo>();
        PrunedItems prunedItems = this.applyClassMergers(classMergers, syntheticArgumentClass, syntheticInitializerConverterBuilder, virtuallyMergedMethodsKeepInfos::add);
        SyntheticInitializerConverter syntheticInitializerConverter = syntheticInitializerConverterBuilder.build();
        assert (syntheticInitializerConverter.isEmpty() || this.appView.enableWholeProgramOptimizations());
        syntheticInitializerConverter.convertClassInitializers(executorService);
        HorizontallyMergedClasses mergedClasses = HorizontallyMergedClasses.builder().addMergeGroups(groups2).build();
        this.appView.setHorizontallyMergedClasses(mergedClasses, this.mode);
        HorizontalClassMergerGraphLens horizontalClassMergerGraphLens = this.createLens(mergedClasses, lensBuilder, this.mode, syntheticArgumentClass);
        assert (HorizontalClassMerger.verifyNoCyclesInInterfaceHierarchies(this.appView, groups2));
        DexApplication newApplication = this.getNewApplication(mergedClasses);
        if (this.appView.hasClassHierarchy()) {
            this.appView.rewriteWithLensAndApplication(horizontalClassMergerGraphLens, newApplication.toDirect());
        } else {
            assert (this.mode.isFinal());
            assert (!this.appView.enableWholeProgramOptimizations());
            SyntheticItems syntheticItems = ((AppInfo)this.appView.appInfo()).getSyntheticItems();
            assert (!syntheticItems.hasPendingSyntheticClasses());
            this.appView.withoutClassHierarchy().setAppInfo(new AppInfo(syntheticItems.commitRewrittenWithLens(newApplication, horizontalClassMergerGraphLens), ((AppInfo)this.appView.appInfo()).getMainDexInfo().rewrittenWithLens(syntheticItems, horizontalClassMergerGraphLens)));
            this.appView.setGraphLens(horizontalClassMergerGraphLens);
        }
        codeProvider.setGraphLens(horizontalClassMergerGraphLens);
        if (this.mode.isInitial()) {
            this.createFieldAccessInfoCollectionModifier(groups2).modify(this.appView.withLiveness());
        } else assert (groups2.stream().noneMatch(MergeGroup::hasClassIdField));
        this.transformIncompleteCode(groups2, horizontalClassMergerGraphLens, executorService);
        syntheticInitializerConverter.convertInstanceInitializers(executorService);
        this.appView.pruneItems(prunedItems.toBuilder().setPrunedApp(this.appView.app()).build(), executorService);
        this.amendKeepInfo(horizontalClassMergerGraphLens, virtuallyMergedMethodsKeepInfos);
    }

    private void amendKeepInfo(HorizontalClassMergerGraphLens horizontalClassMergerGraphLens, List<VirtuallyMergedMethodsKeepInfo> virtuallyMergedMethodsKeepInfos) {
        if (!this.appView.enableWholeProgramOptimizations()) {
            assert (virtuallyMergedMethodsKeepInfos.isEmpty());
            return;
        }
        this.appView.getKeepInfo().mutate(keepInfo -> {
            for (VirtuallyMergedMethodsKeepInfo virtuallyMergedMethodsKeepInfo : virtuallyMergedMethodsKeepInfos) {
                DexMethod representative = virtuallyMergedMethodsKeepInfo.getRepresentative();
                GraphLens.MethodLookupResult lookupResult = horizontalClassMergerGraphLens.lookupMethod(representative, null, Invoke.Type.VIRTUAL, horizontalClassMergerGraphLens.getPrevious());
                ProgramMethod mergedMethod = DexClassAndMethod.asProgramMethodOrNull(this.appView.definitionFor((DexMethod)lookupResult.getReference()));
                if (mergedMethod != null) {
                    keepInfo.joinMethod(mergedMethod, info -> info.merge(virtuallyMergedMethodsKeepInfo.getKeepInfo()));
                    continue;
                }
                assert (false);
            }
        });
    }

    private FieldAccessInfoCollectionModifier createFieldAccessInfoCollectionModifier(Collection<MergeGroup> groups2) {
        assert (this.mode.isInitial());
        FieldAccessInfoCollectionModifier.Builder builder = new FieldAccessInfoCollectionModifier.Builder();
        for (MergeGroup group : groups2) {
            if (!group.hasClassIdField()) continue;
            DexProgramClass target = group.getTarget();
            target.forEachProgramInstanceInitializerMatching(definition -> definition.getCode().isHorizontalClassMergerCode(), method -> builder.recordFieldWrittenInContext(group.getClassIdField(), (ProgramMethod)method));
            target.forEachProgramVirtualMethodMatching(definition -> definition.hasCode() && definition.getCode().isHorizontalClassMergerCode(), method -> builder.recordFieldReadInContext(group.getClassIdField(), (ProgramMethod)method));
        }
        return builder.build();
    }

    private void transformIncompleteCode(Collection<MergeGroup> groups2, HorizontalClassMergerGraphLens horizontalClassMergerGraphLens, ExecutorService executorService) throws ExecutionException {
        if (!this.appView.hasClassHierarchy()) {
            assert (this.verifyNoIncompleteCode(groups2, executorService));
            return;
        }
        ThreadUtils.processItems(groups2, group -> {
            DexProgramClass target = group.getTarget();
            target.forEachProgramMethodMatching(definition -> definition.hasCode() && definition.getCode().isIncompleteHorizontalClassMergerCode(), method -> {
                IncompleteHorizontalClassMergerCode code = (IncompleteHorizontalClassMergerCode)((DexEncodedMethod)method.getDefinition()).getCode();
                method.setCode(code.toCfCode((AppView<? extends AppInfoWithClassHierarchy>)this.appView.withClassHierarchy(), (ProgramMethod)method, horizontalClassMergerGraphLens), this.appView);
            });
        }, executorService);
    }

    private boolean verifyNoIncompleteCode(Collection<MergeGroup> groups2, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(groups2, group -> {
            assert (!group.getTarget().methods(method -> method.hasCode() && method.getCode().isIncompleteHorizontalClassMergerCode()).iterator().hasNext()) : "Expected no incomplete code";
        }, executorService);
        return true;
    }

    private DexApplication getNewApplication(HorizontallyMergedClasses mergedClasses) {
        if (this.mode.isInitial()) {
            return this.appView.app();
        }
        return ((DexApplication.Builder)this.appView.app().builder().removeProgramClasses(clazz -> mergedClasses.hasBeenMergedIntoDifferentType(clazz.getType()))).build();
    }

    private List<MergeGroup> getInitialGroups() {
        MergeGroup initialClassGroup = new MergeGroup();
        MergeGroup initialInterfaceGroup = new MergeGroup();
        for (DexProgramClass clazz : ((AppInfo)this.appView.appInfo()).classesWithDeterministicOrder()) {
            if (clazz.isInterface()) {
                initialInterfaceGroup.add(clazz);
                continue;
            }
            initialClassGroup.add(clazz);
        }
        LinkedList<MergeGroup> initialGroups = new LinkedList<MergeGroup>();
        initialGroups.add(initialClassGroup);
        initialGroups.add(initialInterfaceGroup);
        initialGroups.removeIf(MergeGroup::isTrivial);
        return initialGroups;
    }

    private List<ClassMerger> initializeClassMergers(IRCodeProvider codeProvider, HorizontalClassMergerGraphLens.Builder lensBuilder, Collection<MergeGroup> groups2) {
        ArrayList<ClassMerger> classMergers = new ArrayList<ClassMerger>(groups2.size());
        for (MergeGroup group : groups2) {
            assert (group.isNonTrivial());
            assert (group.hasInstanceFieldMap());
            assert (group.hasTarget());
            classMergers.add(new ClassMerger.Builder(this.appView, codeProvider, group, this.mode).build(lensBuilder));
        }
        this.appView.dexItemFactory().clearTypeElementsCache();
        return classMergers;
    }

    private PrunedItems applyClassMergers(Collection<ClassMerger> classMergers, SyntheticArgumentClass syntheticArgumentClass, SyntheticInitializerConverter.Builder syntheticInitializerConverterBuilder, Consumer<VirtuallyMergedMethodsKeepInfo> virtuallyMergedMethodsKeepInfoConsumer) {
        PrunedItems.Builder prunedItemsBuilder = PrunedItems.builder().setPrunedApp(this.appView.app());
        for (ClassMerger merger : classMergers) {
            merger.mergeGroup(prunedItemsBuilder, syntheticArgumentClass, syntheticInitializerConverterBuilder, virtuallyMergedMethodsKeepInfoConsumer);
        }
        return prunedItemsBuilder.build();
    }

    private HorizontalClassMergerGraphLens createLens(HorizontallyMergedClasses mergedClasses, HorizontalClassMergerGraphLens.Builder lensBuilder, Mode mode, SyntheticArgumentClass syntheticArgumentClass) {
        return new TreeFixer(this.appView, mergedClasses, lensBuilder, mode, syntheticArgumentClass).fixupTypeReferences();
    }

    private static boolean verifyNoCyclesInInterfaceHierarchies(AppView<?> appView, Collection<MergeGroup> groups2) {
        for (MergeGroup group : groups2) {
            if (group.isClassGroup()) continue;
            assert (appView.hasClassHierarchy());
            DexProgramClass interfaceClass = group.getTarget();
            appView.withClassHierarchy().appInfo().traverseSuperTypes(interfaceClass, (superType, subclass, isInterface) -> {
                assert (superType != interfaceClass.getType()) : "Interface " + interfaceClass.getTypeName() + " inherits from itself";
                return TraversalContinuation.doContinue();
            });
        }
        return true;
    }

    public void runIfNecessary(ExecutorService executorService, Timing timing) throws ExecutionException {
        this.runIfNecessary(executorService, timing, null);
    }

    public void runIfNecessary(ExecutorService executorService, Timing timing, RuntimeTypeCheckInfo runtimeTypeCheckInfo) throws ExecutionException {
        if (this.options.isEnabled(this.mode)) {
            timing.begin("HorizontalClassMerger (" + this.mode.toString() + ")");
            IRCodeProvider codeProvider = this.appView.hasClassHierarchy() ? IRCodeProvider.create(this.appView.withClassHierarchy()) : IRCodeProvider.createThrowing();
            this.run(runtimeTypeCheckInfo, codeProvider, executorService, timing);
            this.appView.dexItemFactory().clearTypeElementsCache();
            timing.end();
        } else {
            this.appView.setHorizontallyMergedClasses(HorizontallyMergedClasses.empty(), this.mode);
        }
    }

    public static enum Mode {
        INITIAL,
        FINAL;


        public boolean isInitial() {
            return this == INITIAL;
        }

        public boolean isFinal() {
            return this == FINAL;
        }
    }
}

