/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.NestedGraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.HorizontallyMergedClasses;
import com.android.tools.r8.ir.conversion.ExtraParameter;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneHashMap;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeHashMap;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalManyToOneMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalManyToOneRepresentativeMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HorizontalClassMergerGraphLens
extends NestedGraphLens {
    private final Map<DexMethod, List<ExtraParameter>> methodExtraParameters;
    private final HorizontallyMergedClasses mergedClasses;

    private HorizontalClassMergerGraphLens(AppView<?> appView, HorizontallyMergedClasses mergedClasses, Map<DexMethod, List<ExtraParameter>> methodExtraParameters, BidirectionalManyToOneRepresentativeMap<DexField, DexField> fieldMap, Map<DexMethod, DexMethod> methodMap, BidirectionalManyToOneRepresentativeMap<DexMethod, DexMethod> newMethodSignatures) {
        super(appView, fieldMap, methodMap, mergedClasses.getForwardMap(), newMethodSignatures);
        this.methodExtraParameters = methodExtraParameters;
        this.mergedClasses = mergedClasses;
    }

    @Override
    public boolean isHorizontalClassMergerGraphLens() {
        return true;
    }

    @Override
    protected Iterable<DexType> internalGetOriginalTypes(DexType previous) {
        return IterableUtils.prependSingleton(previous, this.mergedClasses.getSourcesFor(previous));
    }

    @Override
    public GraphLens.MethodLookupResult internalDescribeLookupMethod(GraphLens.MethodLookupResult previous, DexMethod context) {
        List<ExtraParameter> extraParameters = this.methodExtraParameters.get(previous.getReference());
        GraphLens.MethodLookupResult lookup = super.internalDescribeLookupMethod(previous, context);
        if (extraParameters == null) {
            return lookup;
        }
        return ((GraphLens.MethodLookupResult.Builder)GraphLens.MethodLookupResult.builder(this).setReference((DexMethod)lookup.getReference())).setPrototypeChanges(lookup.getPrototypeChanges().withExtraParameters(extraParameters)).setType(lookup.getType()).build();
    }

    @Override
    protected GraphLens.FieldLookupResult internalDescribeLookupField(GraphLens.FieldLookupResult previous) {
        GraphLens.FieldLookupResult lookup = super.internalDescribeLookupField(previous);
        if (lookup.getReference() == previous.getReference()) {
            return lookup;
        }
        return ((GraphLens.FieldLookupResult.Builder)((GraphLens.FieldLookupResult.Builder)GraphLens.FieldLookupResult.builder(this).setReference((DexField)lookup.getReference())).setReboundReference((DexField)lookup.getReboundReference())).setReadCastType(((DexField)lookup.getReference()).getType() != ((DexField)previous.getReference()).getType() ? this.lookupType(((DexField)previous.getReference()).getType()) : null).setWriteCastType(previous.getRewrittenWriteCastType(this::internalDescribeLookupClassType)).build();
    }

    public static class Builder {
        private final MutableBidirectionalManyToOneRepresentativeMap<DexField, DexField> newFieldSignatures = BidirectionalManyToOneRepresentativeHashMap.newIdentityHashMap();
        private final MutableBidirectionalManyToOneMap<DexMethod, DexMethod> methodMap = BidirectionalManyToOneHashMap.newIdentityHashMap();
        private final MutableBidirectionalManyToOneRepresentativeMap<DexMethod, DexMethod> newMethodSignatures = BidirectionalManyToOneRepresentativeHashMap.newIdentityHashMap();
        private final Map<DexMethod, List<ExtraParameter>> methodExtraParameters = new IdentityHashMap<DexMethod, List<ExtraParameter>>();
        private final MutableBidirectionalManyToOneMap<DexMethod, DexMethod> pendingMethodMapUpdates = BidirectionalManyToOneHashMap.newIdentityHashMap();
        private final MutableBidirectionalManyToOneRepresentativeMap<DexField, DexField> pendingNewFieldSignatureUpdates = BidirectionalManyToOneRepresentativeHashMap.newIdentityHashMap();
        private final MutableBidirectionalManyToOneRepresentativeMap<DexMethod, DexMethod> pendingNewMethodSignatureUpdates = BidirectionalManyToOneRepresentativeHashMap.newIdentityHashMap();

        Builder() {
        }

        private void fixupMethodMap(DexMethod oldMethodSignature, DexMethod newMethodSignature) {
            Set originalMethodSignatures = this.methodMap.getKeys(oldMethodSignature);
            if (originalMethodSignatures.isEmpty()) {
                this.pendingMethodMapUpdates.put(oldMethodSignature, newMethodSignature);
            } else {
                for (DexMethod originalMethodSignature : originalMethodSignatures) {
                    this.pendingMethodMapUpdates.put(originalMethodSignature, newMethodSignature);
                }
            }
        }

        private <D extends DexEncodedMember<D, R>, R extends DexMember<D, R>> void fixupOriginalMemberSignatures(R oldMemberSignature, R newMemberSignature, MutableBidirectionalManyToOneRepresentativeMap<R, R> newMemberSignatures, MutableBidirectionalManyToOneRepresentativeMap<R, R> pendingNewMemberSignatureUpdates) {
            Set oldMemberSignatures = newMemberSignatures.getKeys(oldMemberSignature);
            if (oldMemberSignatures.isEmpty()) {
                pendingNewMemberSignatureUpdates.put(oldMemberSignature, newMemberSignature);
            } else {
                for (DexMember originalMethodSignature : oldMemberSignatures) {
                    pendingNewMemberSignatureUpdates.put(originalMethodSignature, newMemberSignature);
                }
                DexMember representative = (DexMember)newMemberSignatures.getRepresentativeKey(oldMemberSignature);
                if (representative != null) {
                    pendingNewMemberSignatureUpdates.setRepresentative(newMemberSignature, representative);
                }
            }
        }

        private <D extends DexEncodedMember<D, R>, R extends DexMember<D, R>> void commitPendingNewMemberSignatureUpdates(MutableBidirectionalManyToOneRepresentativeMap<R, R> newMemberSignatures, MutableBidirectionalManyToOneRepresentativeMap<R, R> pendingNewMemberSignatureUpdates) {
            newMemberSignatures.removeAll(pendingNewMemberSignatureUpdates.keySet());
            newMemberSignatures.putAll(pendingNewMemberSignatureUpdates);
            pendingNewMemberSignatureUpdates.clear();
        }

        HorizontalClassMergerGraphLens build(AppView<?> appView, HorizontallyMergedClasses mergedClasses) {
            assert (this.pendingMethodMapUpdates.isEmpty());
            assert (this.pendingNewFieldSignatureUpdates.isEmpty());
            assert (this.pendingNewMethodSignatureUpdates.isEmpty());
            assert (this.newMethodSignatures.values().stream().allMatch(value -> {
                assert (this.newMethodSignatures.getKeys((DexMethod)value).size() == 1 || this.newMethodSignatures.hasExplicitRepresentativeKey((DexMethod)value));
                return true;
            }));
            return new HorizontalClassMergerGraphLens(appView, mergedClasses, this.methodExtraParameters, this.newFieldSignatures, this.methodMap.getForwardMap(), this.newMethodSignatures);
        }

        DexMethod getRenamedMethodSignature(DexMethod method) {
            assert (this.newMethodSignatures.containsKey(method));
            return (DexMethod)this.newMethodSignatures.get(method);
        }

        void recordNewFieldSignature(DexField oldFieldSignature, DexField newFieldSignature) {
            this.newFieldSignatures.put(oldFieldSignature, newFieldSignature);
        }

        void recordNewFieldSignature(Iterable<DexField> oldFieldSignatures, DexField newFieldSignature, DexField representative) {
            assert (Streams.stream(oldFieldSignatures).anyMatch(oldFieldSignature -> oldFieldSignature != newFieldSignature));
            assert (Streams.stream(oldFieldSignatures).noneMatch(this.newFieldSignatures::containsValue));
            assert (Iterables.contains(oldFieldSignatures, representative));
            for (DexField oldFieldSignature2 : oldFieldSignatures) {
                this.recordNewFieldSignature(oldFieldSignature2, newFieldSignature);
            }
            this.newFieldSignatures.setRepresentative(newFieldSignature, representative);
        }

        void fixupField(DexField oldFieldSignature, DexField newFieldSignature) {
            this.fixupOriginalMemberSignatures(oldFieldSignature, newFieldSignature, this.newFieldSignatures, this.pendingNewFieldSignatureUpdates);
        }

        void mapMethod(DexMethod oldMethodSignature, DexMethod newMethodSignature) {
            this.methodMap.put(oldMethodSignature, newMethodSignature);
        }

        void moveMethod(DexMethod from, DexMethod to) {
            this.moveMethod(from, to, false);
        }

        void moveMethod(DexMethod from, DexMethod to, boolean isRepresentative) {
            this.mapMethod(from, to);
            this.recordNewMethodSignature(from, to, isRepresentative);
        }

        void moveMethods(Iterable<ProgramMethod> methods, DexMethod to) {
            this.moveMethods(methods, to, null);
        }

        void moveMethods(Iterable<ProgramMethod> methods, DexMethod to, ProgramMethod representative) {
            for (ProgramMethod from : methods) {
                boolean isRepresentative = representative != null && from == representative;
                this.moveMethod((DexMethod)from.getReference(), to, isRepresentative);
            }
        }

        void recordNewMethodSignature(DexMethod oldMethodSignature, DexMethod newMethodSignature) {
            this.recordNewMethodSignature(oldMethodSignature, newMethodSignature, false);
        }

        void recordNewMethodSignature(DexMethod oldMethodSignature, DexMethod newMethodSignature, boolean isRepresentative) {
            this.newMethodSignatures.put(oldMethodSignature, newMethodSignature);
            if (isRepresentative) {
                this.newMethodSignatures.setRepresentative(newMethodSignature, oldMethodSignature);
            }
        }

        void fixupMethod(DexMethod oldMethodSignature, DexMethod newMethodSignature) {
            this.fixupMethodMap(oldMethodSignature, newMethodSignature);
            this.fixupOriginalMemberSignatures(oldMethodSignature, newMethodSignature, this.newMethodSignatures, this.pendingNewMethodSignatureUpdates);
        }

        void commitPendingUpdates() {
            this.methodMap.removeAll(this.pendingMethodMapUpdates.keySet());
            this.pendingMethodMapUpdates.forEachManyToOneMapping(this.methodMap::put);
            this.pendingMethodMapUpdates.clear();
            this.commitPendingNewMemberSignatureUpdates(this.newFieldSignatures, this.pendingNewFieldSignatureUpdates);
            this.commitPendingNewMemberSignatureUpdates(this.newMethodSignatures, this.pendingNewMethodSignatureUpdates);
        }

        void mapMergedConstructor(DexMethod from, DexMethod to, List<ExtraParameter> extraParameters) {
            this.mapMethod(from, to);
            if (extraParameters.size() > 0) {
                this.methodExtraParameters.put(from, extraParameters);
            }
        }

        void addExtraParameters(DexMethod methodSignature, List<? extends ExtraParameter> extraParameters) {
            Set originalMethodSignatures = this.methodMap.getKeys(methodSignature);
            if (originalMethodSignatures.isEmpty()) {
                this.methodExtraParameters.computeIfAbsent(methodSignature, ignore -> new ArrayList(extraParameters.size())).addAll(extraParameters);
            } else {
                for (DexMethod originalMethodSignature : originalMethodSignatures) {
                    this.methodExtraParameters.computeIfAbsent(originalMethodSignature, ignore -> new ArrayList(extraParameters.size())).addAll(extraParameters);
                }
            }
        }
    }
}

