/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMergerGraphLens;
import com.android.tools.r8.horizontalclassmerging.IRCodeProvider;
import com.android.tools.r8.horizontalclassmerging.InstanceInitializerAnalysis;
import com.android.tools.r8.horizontalclassmerging.InstanceInitializerDescription;
import com.android.tools.r8.horizontalclassmerging.InstanceInitializerMerger;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class InstanceInitializerMergerCollection {
    private final List<InstanceInitializerMerger> instanceInitializerMergers;
    private final Map<InstanceInitializerDescription, InstanceInitializerMerger> equivalentInstanceInitializerMergers;

    private InstanceInitializerMergerCollection(List<InstanceInitializerMerger> instanceInitializerMergers, Map<InstanceInitializerDescription, InstanceInitializerMerger> equivalentInstanceInitializerMergers) {
        this.instanceInitializerMergers = instanceInitializerMergers;
        this.equivalentInstanceInitializerMergers = equivalentInstanceInitializerMergers;
    }

    public static InstanceInitializerMergerCollection create(AppView<?> appView, Reference2IntMap<DexType> classIdentifiers, IRCodeProvider codeProvider, MergeGroup group, HorizontalClassMergerGraphLens.Builder lensBuilder, HorizontalClassMerger.Mode mode) {
        if (!appView.hasClassHierarchy()) {
            assert (appView.options().horizontalClassMergerOptions().isRestrictedToSynthetics());
            assert (InstanceInitializerMergerCollection.verifyNoInstanceInitializers(group));
            return new InstanceInitializerMergerCollection(Collections.emptyList(), Collections.emptyMap());
        }
        AppView<AppInfoWithClassHierarchy> appViewWithClassHierarchy = appView.withClassHierarchy();
        LinkedHashMap<InstanceInitializerDescription, InstanceInitializerMerger.Builder> buildersByDescription = new LinkedHashMap<InstanceInitializerDescription, InstanceInitializerMerger.Builder>();
        ProgramMethodSet buildersWithoutDescription = ProgramMethodSet.createLinked();
        group.forEach((? super T clazz) -> clazz.forEachProgramDirectMethodMatching(DexEncodedMethod::isInstanceInitializer, instanceInitializer -> {
            InstanceInitializerDescription description = InstanceInitializerAnalysis.analyze(appViewWithClassHierarchy, codeProvider, group, instanceInitializer);
            if (description != null) {
                buildersByDescription.computeIfAbsent(description, MapUtils.ignoreKey(() -> new InstanceInitializerMerger.Builder(appViewWithClassHierarchy, classIdentifiers, lensBuilder, mode))).addEquivalent((ProgramMethod)instanceInitializer);
            } else {
                buildersWithoutDescription.add(instanceInitializer);
            }
        }));
        LinkedHashMap<InstanceInitializerDescription, InstanceInitializerMerger> equivalentInstanceInitializerMergers = new LinkedHashMap<InstanceInitializerDescription, InstanceInitializerMerger>();
        buildersByDescription.forEach((? super K description, ? super V builder) -> {
            InstanceInitializerMerger instanceInitializerMerger = builder.buildSingle(group, (InstanceInitializerDescription)description);
            if (instanceInitializerMerger.size() == 1) {
                buildersWithoutDescription.addAll(instanceInitializerMerger.getInstanceInitializers());
            } else {
                equivalentInstanceInitializerMergers.put((InstanceInitializerDescription)description, instanceInitializerMerger);
            }
        });
        ArrayList<InstanceInitializerMerger> instanceInitializerMergers = new ArrayList<InstanceInitializerMerger>();
        if (appView.options().horizontalClassMergerOptions().isConstructorMergingEnabled()) {
            LinkedHashMap buildersByProto = new LinkedHashMap();
            buildersWithoutDescription.forEach((? super T instanceInitializer) -> buildersByProto.computeIfAbsent(((DexEncodedMethod)instanceInitializer.getDefinition()).getProto(), ignore -> new InstanceInitializerMerger.Builder(appViewWithClassHierarchy, classIdentifiers, lensBuilder, mode)).add((ProgramMethod)instanceInitializer));
            for (InstanceInitializerMerger.Builder builder2 : buildersByProto.values()) {
                instanceInitializerMergers.addAll(builder2.build(group));
            }
        } else {
            buildersWithoutDescription.forEach((? super T instanceInitializer) -> instanceInitializerMergers.addAll(new InstanceInitializerMerger.Builder(appViewWithClassHierarchy, classIdentifiers, lensBuilder, mode).add((ProgramMethod)instanceInitializer).build(group)));
        }
        instanceInitializerMergers.sort(Comparator.comparing(InstanceInitializerMerger::getArity).reversed());
        return new InstanceInitializerMergerCollection(instanceInitializerMergers, equivalentInstanceInitializerMergers);
    }

    private static boolean verifyNoInstanceInitializers(MergeGroup group) {
        group.forEach((? super T clazz) -> {
            assert (!clazz.programInstanceInitializers().iterator().hasNext());
        });
        return true;
    }

    public void forEach(Consumer<InstanceInitializerMerger> consumer) {
        this.instanceInitializerMergers.forEach(consumer);
        this.equivalentInstanceInitializerMergers.values().forEach(consumer);
    }
}

