/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.horizontalclassmerging.ClassInstanceFieldsMerger;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.IteratorUtils;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneHashMap;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class MergeGroup
implements Collection<DexProgramClass> {
    private final LinkedList<DexProgramClass> classes = new LinkedList();
    private DexField classIdField;
    private DexProgramClass target = null;
    private Metadata metadata = null;
    private BidirectionalManyToOneMap<DexEncodedField, DexEncodedField> instanceFieldMap;

    public MergeGroup() {
    }

    public MergeGroup(DexProgramClass clazz) {
        this();
        this.add(clazz);
    }

    public MergeGroup(Iterable<DexProgramClass> classes) {
        this();
        Iterables.addAll(this.classes, classes);
    }

    private void setTarget(DexProgramClass target) {
        assert (!this.hasTarget());
        this.target = target;
    }

    public void applyMetadataFrom(MergeGroup group) {
        if (this.metadata == null) {
            this.metadata = group.metadata;
        }
    }

    @Override
    public boolean add(DexProgramClass clazz) {
        return this.classes.add(clazz);
    }

    @Override
    public boolean add(MergeGroup group) {
        return this.classes.addAll(group.getClasses());
    }

    @Override
    public boolean addAll(Collection<? extends DexProgramClass> classes) {
        return this.classes.addAll(classes);
    }

    @Override
    public void clear() {
        this.classes.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.classes.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.classes.containsAll(collection);
    }

    public void forEachSource(Consumer<DexProgramClass> consumer) {
        assert (this.hasTarget());
        for (DexProgramClass clazz : this.classes) {
            if (clazz == this.target) continue;
            consumer.accept(clazz);
        }
    }

    public LinkedList<DexProgramClass> getClasses() {
        return this.classes;
    }

    public boolean hasClassIdField() {
        return this.classIdField != null;
    }

    public DexField getClassIdField() {
        assert (this.hasClassIdField());
        return this.classIdField;
    }

    public void setClassIdField(DexField classIdField) {
        this.classIdField = classIdField;
    }

    public boolean hasInstanceFieldMap() {
        return this.instanceFieldMap != null;
    }

    public BidirectionalManyToOneMap<DexEncodedField, DexEncodedField> getInstanceFieldMap() {
        assert (this.hasInstanceFieldMap());
        return this.instanceFieldMap;
    }

    public void selectInstanceFieldMap(AppView<? extends AppInfoWithClassHierarchy> appView) {
        assert (this.hasTarget());
        BidirectionalManyToOneHashMap<DexEncodedField, DexEncodedField> instanceFieldMap = BidirectionalManyToOneHashMap.newLinkedHashMap();
        this.forEachSource(source -> ClassInstanceFieldsMerger.mapFields(appView, source, this.target, instanceFieldMap::put));
        this.setInstanceFieldMap(instanceFieldMap);
    }

    public void setInstanceFieldMap(BidirectionalManyToOneMap<DexEncodedField, DexEncodedField> instanceFieldMap) {
        assert (!this.hasInstanceFieldMap());
        this.instanceFieldMap = instanceFieldMap;
    }

    public Iterable<DexProgramClass> getSources() {
        assert (this.hasTarget());
        return Iterables.filter(this.classes, clazz -> clazz != this.target);
    }

    public DexType getSuperType() {
        assert (IterableUtils.allIdentical(this.classes, DexClass::getSuperType));
        return this.getClasses().getFirst().getSuperType();
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public DexProgramClass getTarget() {
        return this.target;
    }

    public ProgramField getTargetInstanceField(ProgramField field) {
        assert (this.hasTarget());
        assert (this.hasInstanceFieldMap());
        if (field.getHolder() == this.getTarget()) {
            return field;
        }
        DexEncodedField targetField = this.getInstanceFieldMap().get(field.getDefinition());
        return new ProgramField(this.getTarget(), targetField);
    }

    public void selectTarget(AppView<?> appView) {
        Iterable<DexProgramClass> candidates = Iterables.filter(this.getClasses(), DexClass::isPublic);
        if (IterableUtils.isEmpty(candidates)) {
            candidates = this.getClasses();
        }
        Iterator<DexProgramClass> candidateIterator = candidates.iterator();
        DexProgramClass target = IterableUtils.first(candidates);
        KeepInfoCollection keepInfo = appView.getKeepInfo();
        while (candidateIterator.hasNext()) {
            DexProgramClass current = candidateIterator.next();
            if (keepInfo != null && keepInfo.getClassInfo(current).isMinificationAllowed(appView.options())) {
                target = current;
                break;
            }
            if (current.getType().getDescriptor().size() >= target.getType().getDescriptor().size) continue;
            target = current;
        }
        this.setTarget(appView.testing().horizontalClassMergingTarget.apply(appView, candidates, target));
    }

    public boolean isTrivial() {
        return this.size() < 2;
    }

    public boolean isNonTrivial() {
        return !this.isTrivial();
    }

    @Override
    public boolean isEmpty() {
        return this.classes.isEmpty();
    }

    public boolean isClassGroup() {
        return !this.isInterfaceGroup();
    }

    public boolean isInterfaceGroup() {
        assert (!this.isEmpty());
        assert (IterableUtils.allIdentical(this.getClasses(), DexClass::isInterface));
        return this.getClasses().getFirst().isInterface();
    }

    @Override
    public Iterator<DexProgramClass> iterator() {
        return this.classes.iterator();
    }

    @Override
    public int size() {
        return this.classes.size();
    }

    @Override
    public boolean remove(Object o) {
        return this.classes.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.classes.removeAll(collection);
    }

    public DexProgramClass removeFirst(Predicate<DexProgramClass> predicate) {
        return IteratorUtils.removeFirst(this.iterator(), predicate);
    }

    @Override
    public boolean removeIf(Predicate<? super DexProgramClass> predicate) {
        return this.classes.removeIf(predicate);
    }

    public DexProgramClass removeLast() {
        return this.classes.removeLast();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return collection.retainAll(collection);
    }

    @Override
    public Object[] toArray() {
        return this.classes.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.classes.toArray(ts);
    }

    public static class Metadata {
    }
}

