/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicyWithPreprocessing;
import com.android.tools.r8.horizontalclassmerging.Policy;
import com.android.tools.r8.horizontalclassmerging.SingleClassPolicy;
import com.android.tools.r8.utils.Timing;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;

public class PolicyExecutor {
    private void applySingleClassPolicy(SingleClassPolicy policy, LinkedList<MergeGroup> groups2) {
        Iterator i = groups2.iterator();
        while (i.hasNext()) {
            MergeGroup group = (MergeGroup)i.next();
            boolean isInterfaceGroup = group.isInterfaceGroup();
            int previousGroupSize = group.size();
            group.removeIf((Predicate<? super DexProgramClass>)((Predicate<DexProgramClass>)clazz -> !policy.canMerge((DexProgramClass)clazz)));
            assert (policy.recordRemovedClassesForDebugging(isInterfaceGroup, previousGroupSize, ImmutableList.of(group)));
            if (!group.isTrivial()) continue;
            i.remove();
        }
    }

    private LinkedList<MergeGroup> applyMultiClassPolicy(MultiClassPolicy policy, LinkedList<MergeGroup> groups2) {
        LinkedList<MergeGroup> newGroups = new LinkedList<MergeGroup>();
        groups2.forEach(group -> {
            boolean isInterfaceGroup = group.isInterfaceGroup();
            int previousGroupSize = group.size();
            Collection<MergeGroup> policyGroups = policy.apply((MergeGroup)group);
            policyGroups.forEach(newGroup -> newGroup.applyMetadataFrom((MergeGroup)group));
            assert (policy.recordRemovedClassesForDebugging(isInterfaceGroup, previousGroupSize, policyGroups));
            newGroups.addAll(policyGroups);
        });
        return newGroups;
    }

    private <T> LinkedList<MergeGroup> applyMultiClassPolicyWithPreprocessing(MultiClassPolicyWithPreprocessing<T> policy, LinkedList<MergeGroup> groups2, ExecutorService executorService) throws ExecutionException {
        Object data2 = policy.preprocess(groups2, executorService);
        LinkedList<MergeGroup> newGroups = new LinkedList<MergeGroup>();
        groups2.forEach(group -> {
            boolean isInterfaceGroup = group.isInterfaceGroup();
            int previousGroupSize = group.size();
            Collection<MergeGroup> policyGroups = policy.apply((MergeGroup)group, data2);
            policyGroups.forEach(newGroup -> newGroup.applyMetadataFrom((MergeGroup)group));
            assert (policy.recordRemovedClassesForDebugging(isInterfaceGroup, previousGroupSize, policyGroups));
            newGroups.addAll(policyGroups);
        });
        return newGroups;
    }

    public Collection<MergeGroup> run(Collection<MergeGroup> inputGroups, Collection<Policy> policies, ExecutorService executorService, Timing timing) throws ExecutionException {
        LinkedList<MergeGroup> linkedGroups = inputGroups instanceof LinkedList ? (LinkedList<MergeGroup>)inputGroups : new LinkedList<MergeGroup>(inputGroups);
        for (Policy policy : policies) {
            if (policy.shouldSkipPolicy()) continue;
            timing.begin(policy.getName());
            if (policy.isSingleClassPolicy()) {
                this.applySingleClassPolicy(policy.asSingleClassPolicy(), linkedGroups);
            } else if (policy.isMultiClassPolicy()) {
                linkedGroups = this.applyMultiClassPolicy(policy.asMultiClassPolicy(), linkedGroups);
            } else {
                assert (policy.isMultiClassPolicyWithPreprocessing());
                linkedGroups = this.applyMultiClassPolicyWithPreprocessing(policy.asMultiClassPolicyWithPreprocessing(), linkedGroups, executorService);
            }
            timing.end();
            policy.clear();
            if (linkedGroups.isEmpty()) break;
            assert (linkedGroups.stream().allMatch(group -> group.size() >= 2));
        }
        return linkedGroups;
    }
}

