/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class SubtypingForrestForClasses {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final Collection<DexProgramClass> roots = new ArrayList<DexProgramClass>();
    private final Map<DexProgramClass, List<DexProgramClass>> subtypeMap = new IdentityHashMap<DexProgramClass, List<DexProgramClass>>();

    public SubtypingForrestForClasses(AppView<? extends AppInfoWithClassHierarchy> appView) {
        this.appView = appView;
        this.calculateSubtyping(appView.appInfo().classes());
    }

    private DexProgramClass superClass(DexProgramClass clazz) {
        return this.appView.programDefinitionFor(clazz.superType, clazz);
    }

    private void calculateSubtyping(Iterable<DexProgramClass> classes) {
        classes.forEach(this::calculateSubtyping);
    }

    private void calculateSubtyping(DexProgramClass clazz) {
        if (clazz.isInterface()) {
            return;
        }
        DexProgramClass superClass = this.superClass(clazz);
        if (superClass == null) {
            this.roots.add(clazz);
        } else {
            this.subtypeMap.computeIfAbsent(superClass, ignore -> new ArrayList()).add(clazz);
        }
    }

    public Collection<DexProgramClass> getProgramRoots() {
        return this.roots;
    }

    public Collection<DexProgramClass> getSubtypesFor(DexProgramClass clazz) {
        return this.subtypeMap.getOrDefault(clazz, Collections.emptyList());
    }

    public <T> T traverseNodeDepthFirst(DexProgramClass clazz, T state, BiFunction<DexProgramClass, T, T> consumer) {
        Object newState = consumer.apply(clazz, (DexProgramClass)state);
        this.getSubtypesFor(clazz).forEach(subClazz -> this.traverseNodeDepthFirst((DexProgramClass)subClazz, newState, (BiFunction)consumer));
        return newState;
    }
}

