/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DefaultInstanceInitializerCode;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.TreeFixerBase;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMergerGraphLens;
import com.android.tools.r8.horizontalclassmerging.HorizontallyMergedClasses;
import com.android.tools.r8.horizontalclassmerging.SubtypingForrestForClasses;
import com.android.tools.r8.horizontalclassmerging.SyntheticArgumentClass;
import com.android.tools.r8.ir.conversion.ExtraUnusedNullParameter;
import com.android.tools.r8.shaking.AnnotationFixer;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.OptionalBool;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class TreeFixer
extends TreeFixerBase {
    private final AppView<?> appView;
    private final HorizontallyMergedClasses mergedClasses;
    private final HorizontalClassMerger.Mode mode;
    private final HorizontalClassMergerGraphLens.Builder lensBuilder;
    private final DexItemFactory dexItemFactory;
    private final SyntheticArgumentClass syntheticArgumentClass;
    private final Map<DexProgramClass, DexType> originalSuperTypes = new IdentityHashMap<DexProgramClass, DexType>();
    private final BiMap<DexMethodSignature, DexMethodSignature> reservedInterfaceSignatures = HashBiMap.create();

    public TreeFixer(AppView<?> appView, HorizontallyMergedClasses mergedClasses, HorizontalClassMergerGraphLens.Builder lensBuilder, HorizontalClassMerger.Mode mode, SyntheticArgumentClass syntheticArgumentClass) {
        super(appView);
        this.appView = appView;
        this.mergedClasses = mergedClasses;
        this.mode = mode;
        this.lensBuilder = lensBuilder;
        this.syntheticArgumentClass = syntheticArgumentClass;
        this.dexItemFactory = appView.dexItemFactory();
    }

    private void fixupAttributes(DexProgramClass clazz) {
        if (clazz.hasEnclosingMethodAttribute()) {
            EnclosingMethodAttribute enclosingMethodAttribute = clazz.getEnclosingMethodAttribute();
            if (this.mergedClasses.hasBeenMergedIntoDifferentType(enclosingMethodAttribute.getEnclosingType())) {
                clazz.clearEnclosingMethodAttribute();
            } else {
                clazz.setEnclosingMethodAttribute(this.fixupEnclosingMethodAttribute(enclosingMethodAttribute));
            }
        }
        clazz.setInnerClasses(this.fixupInnerClassAttributes(clazz.getInnerClasses()));
        clazz.setNestHostAttribute(this.fixupNestHost(clazz.getNestHostClassAttribute()));
        clazz.setNestMemberAttributes(this.fixupNestMemberAttributes(clazz.getNestMembersClassAttributes()));
    }

    private void fixupProgramClassSuperTypes(DexProgramClass clazz) {
        DexType rewrittenSuperType = this.fixupType(clazz.getSuperType());
        if (rewrittenSuperType != clazz.getSuperType()) {
            this.originalSuperTypes.put(clazz, clazz.getSuperType());
            clazz.superType = rewrittenSuperType;
        }
        clazz.setInterfaces(this.fixupInterfaces(clazz, clazz.getInterfaces()));
    }

    private BiMap<DexMethodSignature, DexMethodSignature> fixupProgramClass(DexProgramClass clazz, BiMap<DexMethodSignature, DexMethodSignature> remappedVirtualMethods) {
        assert (!clazz.isInterface());
        HashBiMap<DexMethodSignature, DexMethodSignature> remappedClassVirtualMethods = HashBiMap.create(remappedVirtualMethods);
        HashSet newMethodReferences = Sets.newHashSet();
        clazz.getMethodCollection().replaceAllVirtualMethods(method -> this.fixupVirtualMethod((BiMap<DexMethodSignature, DexMethodSignature>)remappedClassVirtualMethods, newMethodReferences, (DexEncodedMethod)method));
        clazz.getMethodCollection().replaceAllDirectMethods(method -> this.fixupDirectMethod(newMethodReferences, clazz, (DexEncodedMethod)method));
        Set<DexField> newFieldReferences = Sets.newIdentityHashSet();
        DexEncodedField[] instanceFields = clazz.clearInstanceFields();
        DexEncodedField[] staticFields = clazz.clearStaticFields();
        clazz.setInstanceFields(this.fixupFields(instanceFields, newFieldReferences));
        clazz.setStaticFields(this.fixupFields(staticFields, newFieldReferences));
        this.lensBuilder.commitPendingUpdates();
        return remappedClassVirtualMethods;
    }

    private DexEncodedMethod fixupVirtualInterfaceMethod(DexEncodedMethod method) {
        DexMethod originalMethodReference = (DexMethod)method.getReference();
        boolean referencesMergeClass = Iterables.any(originalMethodReference.getProto().getBaseTypes(this.dexItemFactory), this.mergedClasses::hasBeenMergedOrIsMergeTarget);
        if (!referencesMergeClass) {
            return method;
        }
        DexMethodSignature originalMethodSignature = originalMethodReference.getSignature();
        DexMethodSignature newMethodSignature = (DexMethodSignature)this.reservedInterfaceSignatures.get(originalMethodSignature);
        if (newMethodSignature == null) {
            newMethodSignature = this.fixupMethodReference(originalMethodReference).getSignature();
            if (this.reservedInterfaceSignatures.containsValue(newMethodSignature)) {
                DexString name = this.dexItemFactory.createGloballyFreshMemberString(originalMethodReference.getName().toSourceString());
                newMethodSignature = newMethodSignature.withName(name);
            }
            assert (!this.reservedInterfaceSignatures.containsValue(newMethodSignature));
            this.reservedInterfaceSignatures.put(originalMethodSignature, newMethodSignature);
        }
        DexMethod newMethodReference = newMethodSignature.withHolder(originalMethodReference, this.dexItemFactory);
        this.lensBuilder.fixupMethod(originalMethodReference, newMethodReference);
        return method.toTypeSubstitutedMethod(newMethodReference);
    }

    private void fixupInterfaceClass(DexProgramClass iface) {
        LinkedHashSet newDirectMethods = new LinkedHashSet();
        iface.getMethodCollection().replaceDirectMethods(method -> this.fixupDirectMethod(newDirectMethods, iface, (DexEncodedMethod)method));
        iface.getMethodCollection().replaceVirtualMethods(this::fixupVirtualInterfaceMethod);
        assert (!iface.hasInstanceFields());
        Set<DexField> newFieldReferences = Sets.newIdentityHashSet();
        DexEncodedField[] staticFields = iface.clearStaticFields();
        iface.setStaticFields(this.fixupFields(staticFields, newFieldReferences));
        this.lensBuilder.commitPendingUpdates();
    }

    private DexTypeList fixupInterfaces(DexProgramClass clazz, DexTypeList interfaceTypes) {
        Set seen = Sets.newIdentityHashSet();
        return interfaceTypes.map(interfaceType -> {
            DexType rewrittenInterfaceType = this.mapClassType((DexType)interfaceType);
            assert (rewrittenInterfaceType != clazz.getType());
            return seen.add(rewrittenInterfaceType) ? rewrittenInterfaceType : null;
        });
    }

    private DexEncodedMethod fixupProgramMethod(DexMethod newMethodReference, DexEncodedMethod method) {
        DexMethod originalMethodReference = (DexMethod)method.getReference();
        if (newMethodReference == originalMethodReference) {
            return method;
        }
        this.lensBuilder.fixupMethod(originalMethodReference, newMethodReference);
        DexEncodedMethod newMethod = method.toTypeSubstitutedMethod(newMethodReference);
        if (newMethod.isNonPrivateVirtualMethod()) {
            assert (!method.isLibraryMethodOverride().isTrue());
            newMethod.setLibraryMethodOverride(OptionalBool.FALSE);
        }
        return newMethod;
    }

    private DexEncodedMethod fixupDirectMethod(Set<DexMethodSignature> newMethods, DexProgramClass clazz, DexEncodedMethod method) {
        DexMethod originalMethodReference = (DexMethod)method.getReference();
        DexMethod newMethodReference = this.fixupMethodReference(originalMethodReference);
        if (newMethods.contains(newMethodReference.getSignature())) {
            if (method.isInstanceInitializer()) {
                newMethodReference = this.dexItemFactory.createInstanceInitializerWithFreshProto(newMethodReference, this.syntheticArgumentClass.getArgumentClasses(), tryMethod -> !newMethods.contains(tryMethod.getSignature()));
                this.lensBuilder.addExtraParameters(originalMethodReference, ExtraUnusedNullParameter.computeExtraUnusedNullParameters(originalMethodReference, newMethodReference));
            } else {
                newMethodReference = this.dexItemFactory.createFreshMethodNameWithoutHolder(newMethodReference.getName().toSourceString(), newMethodReference.proto, newMethodReference.holder, tryMethod -> !this.reservedInterfaceSignatures.containsValue(tryMethod.getSignature()) && !newMethods.contains(tryMethod.getSignature()));
            }
        }
        boolean changed = newMethods.add(newMethodReference.getSignature());
        assert (changed);
        if (this.mode.isInitial() && method.hasCode() && method.getCode().isDefaultInstanceInitializerCode() && this.mergedClasses.hasBeenMergedOrIsMergeTarget(clazz.getSuperType())) {
            DexType originalSuperType = this.originalSuperTypes.getOrDefault(clazz, clazz.getSuperType());
            DefaultInstanceInitializerCode.uncanonicalizeCode(this.appView, method.asProgramMethod(clazz), originalSuperType);
        }
        return this.fixupProgramMethod(newMethodReference, method);
    }

    private DexMethodSignature lookupReservedVirtualName(DexMethod originalMethodReference, BiMap<DexMethodSignature, DexMethodSignature> renamedClassVirtualMethods) {
        DexMethodSignature originalSignature = originalMethodReference.getSignature();
        DexMethodSignature renamedVirtualName = (DexMethodSignature)renamedClassVirtualMethods.get(originalSignature);
        if (renamedVirtualName == null) {
            DexMethodSignature mappedInterfaceSignature = (DexMethodSignature)this.reservedInterfaceSignatures.get(originalSignature);
            if (mappedInterfaceSignature != null) {
                renamedVirtualName = mappedInterfaceSignature;
            }
        } else assert (!this.reservedInterfaceSignatures.containsKey(originalSignature));
        return renamedVirtualName;
    }

    private DexEncodedMethod fixupVirtualMethod(BiMap<DexMethodSignature, DexMethodSignature> renamedClassVirtualMethods, Set<DexMethodSignature> newMethods, DexEncodedMethod method) {
        DexMethod originalMethodReference = (DexMethod)method.getReference();
        DexMethodSignature originalSignature = originalMethodReference.getSignature();
        DexMethodSignature renamedVirtualName = this.lookupReservedVirtualName(originalMethodReference, renamedClassVirtualMethods);
        DexMethodSignature newSignature = this.fixupMethodSignature(originalSignature);
        if (renamedVirtualName != null) {
            newSignature = renamedVirtualName;
            assert (!newMethods.contains(newSignature));
        } else if (this.reservedInterfaceSignatures.containsValue(newSignature) || newMethods.contains(newSignature) || renamedClassVirtualMethods.containsValue(newSignature)) {
            newSignature = this.dexItemFactory.createFreshMethodSignatureName(originalMethodReference.getName().toSourceString(), null, newSignature.getProto(), trySignature -> !this.reservedInterfaceSignatures.containsValue(trySignature) && !newMethods.contains(trySignature) && !renamedClassVirtualMethods.containsValue(trySignature));
            renamedClassVirtualMethods.put(originalSignature, newSignature);
        } else if (Iterables.any(newSignature.getProto().getParameterBaseTypes(this.dexItemFactory), this.mergedClasses::isMergeTarget)) {
            renamedClassVirtualMethods.put(originalSignature, newSignature);
        }
        boolean changed = newMethods.add(newSignature);
        assert (changed);
        DexMethod newMethodReference = newSignature.withHolder(this.fixupType(originalMethodReference.holder), this.dexItemFactory);
        return this.fixupProgramMethod(newMethodReference, method);
    }

    private DexEncodedField[] fixupFields(DexEncodedField[] fields, Set<DexField> newFieldReferences) {
        if (fields == null || ArrayUtils.isEmpty(fields)) {
            return DexEncodedField.EMPTY_ARRAY;
        }
        DexEncodedField[] newFields = new DexEncodedField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            DexEncodedField oldField = fields[i];
            DexField oldFieldReference = (DexField)oldField.getReference();
            DexField newFieldReference = this.fixupFieldReference(oldFieldReference);
            if (!newFieldReferences.add(newFieldReference)) {
                DexField template = newFieldReference;
                newFieldReference = (DexField)this.dexItemFactory.createFreshMember(tryName -> Optional.of(template.withName((DexString)tryName, this.dexItemFactory)).filter(tryMethod -> !newFieldReferences.contains(tryMethod)), newFieldReference.name.toSourceString());
                boolean added = newFieldReferences.add(newFieldReference);
                assert (added);
            }
            if (newFieldReference != oldFieldReference) {
                this.lensBuilder.fixupField(oldFieldReference, newFieldReference);
                newFields[i] = oldField.toTypeSubstitutedField(this.appView, newFieldReference);
                continue;
            }
            newFields[i] = oldField;
        }
        return newFields;
    }

    public HorizontalClassMergerGraphLens fixupTypeReferences() {
        HorizontalClassMergerGraphLens lens = this.lensBuilder.build(this.appView, this.mergedClasses);
        if (this.appView.enableWholeProgramOptimizations()) {
            Collection<DexProgramClass> classes = ((AppInfo)this.appView.appInfo()).classesWithDeterministicOrder();
            Iterables.filter(classes, DexClass::isInterface).forEach(this::fixupInterfaceClass);
            classes.forEach(this::fixupAttributes);
            classes.forEach(this::fixupProgramClassSuperTypes);
            SubtypingForrestForClasses subtypingForrest = new SubtypingForrestForClasses(this.appView.withClassHierarchy());
            for (DexProgramClass root : subtypingForrest.getProgramRoots()) {
                subtypingForrest.traverseNodeDepthFirst(root, HashBiMap.create(), this::fixupProgramClass);
            }
            new AnnotationFixer(lens).run(((AppInfo)this.appView.appInfo()).classes());
        }
        return lens;
    }

    @Override
    public DexType mapClassType(DexType type) {
        return this.mergedClasses.getMergeTargetOrDefault(type);
    }

    @Override
    public void recordClassChange(DexType from, DexType to) {
        throw new Unreachable();
    }

    @Override
    public void recordFieldChange(DexField from, DexField to) {
        throw new Unreachable();
    }

    @Override
    public void recordMethodChange(DexMethod from, DexMethod to) {
        throw new Unreachable();
    }
}

