/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.code;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.cf.code.CfGoto;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.ClasspathMethod;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.IRMetadata;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.CfVersionUtils;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.ListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ClassInitializerMerger {
    private final ImmutableList<ProgramMethod> classInitializers;

    private ClassInitializerMerger(ImmutableList<ProgramMethod> classInitializers) {
        this.classInitializers = classInitializers;
    }

    public static ClassInitializerMerger create(MergeGroup group) {
        Builder builder = new Builder();
        group.forEach(clazz -> {
            if (clazz.hasClassInitializer()) {
                builder.add(clazz.getProgramClassInitializer());
            }
        });
        return builder.build();
    }

    public boolean isEmpty() {
        return this.classInitializers.isEmpty();
    }

    public Code getCode(DexMethod syntheticMethodReference) {
        assert (!this.classInitializers.isEmpty());
        ProgramMethod firstClassInitializer = ListUtils.first(this.classInitializers);
        if (((DexEncodedMethod)firstClassInitializer.getDefinition()).getCode().isCfCode()) {
            assert (IterableUtils.allIdentical(this.classInitializers, classInitializer -> ((DexEncodedMethod)classInitializer.getDefinition()).getCode().isCfCode()));
            return new CfCodeBuilder().build(syntheticMethodReference);
        }
        return new IRProvider(this.classInitializers, syntheticMethodReference);
    }

    public CfVersion getCfVersion() {
        ProgramMethod classInitializer = ListUtils.first(this.classInitializers);
        if (this.classInitializers.size() == 1) {
            DexEncodedMethod method2 = (DexEncodedMethod)classInitializer.getDefinition();
            return method2.hasClassFileVersion() ? method2.getClassFileVersion() : null;
        }
        if (((DexEncodedMethod)classInitializer.getDefinition()).getCode().isCfCode()) {
            assert (IterableUtils.allIdentical(this.classInitializers, method -> ((DexEncodedMethod)method.getDefinition()).getCode().isCfCode()));
            return CfVersionUtils.max(this.classInitializers);
        }
        return null;
    }

    public ComputedApiLevel getApiReferenceLevel(AppView<?> appView) {
        assert (!this.classInitializers.isEmpty());
        return ListUtils.fold(this.classInitializers, appView.computedMinApiLevel(), (accApiLevel, method) -> accApiLevel.max(((DexEncodedMethod)method.getDefinition()).getApiLevel()));
    }

    private static class IRProvider
    extends Code {
        private final ImmutableList<ProgramMethod> classInitializers;
        private final DexMethod syntheticMethodReference;

        private IRProvider(ImmutableList<ProgramMethod> classInitializers, DexMethod syntheticMethodReference) {
            this.classInitializers = classInitializers;
            this.syntheticMethodReference = syntheticMethodReference;
        }

        @Override
        public IRCode buildIR(ProgramMethod method, AppView<?> appView, Origin origin, MethodConversionOptions.MutableMethodConversionOptions conversionOptions) {
            assert (!this.classInitializers.isEmpty());
            Position.SyntheticPosition callerPosition = ((Position.SyntheticPosition.SyntheticPositionBuilder)((Position.SyntheticPosition.SyntheticPositionBuilder)Position.SyntheticPosition.builder().setLine(0)).setMethod(this.syntheticMethodReference)).build();
            IRMetadata metadata = new IRMetadata();
            NumberGenerator blockNumberGenerator = new NumberGenerator();
            NumberGenerator valueNumberGenerator = new NumberGenerator();
            BasicBlock block = new BasicBlock();
            block.setNumber(blockNumberGenerator.next());
            for (ProgramMethod classInitializer : this.classInitializers) {
                block.add((Instruction)((InvokeStatic.Builder)((InvokeStatic.Builder)InvokeStatic.builder().setMethod((DexMethod)classInitializer.getReference())).setPosition(callerPosition)).build(), metadata);
            }
            block.add((Instruction)((Return.Builder)Return.builder().setPosition(Position.none())).build(), metadata);
            block.setFilled();
            IRCode code = new IRCode(appView.options(), method, ListUtils.newLinkedList(block), valueNumberGenerator, blockNumberGenerator, metadata, origin, conversionOptions);
            BasicBlockIterator blockIterator = code.listIterator();
            InstructionListIterator instructionIterator = ((BasicBlock)blockIterator.next()).listIterator(code);
            Set<BasicBlock> blocksToRemove = Sets.newIdentityHashSet();
            for (ProgramMethod classInitializer : this.classInitializers) {
                if (!instructionIterator.hasNext()) {
                    instructionIterator = ((BasicBlock)blockIterator.next()).listIterator(code);
                }
                InvokeStatic invoke = ((Instruction)instructionIterator.next()).asInvokeStatic();
                assert (invoke != null);
                IRCode inliningIR = ((DexEncodedMethod)classInitializer.getDefinition()).getCode().buildInliningIR(method, classInitializer, appView, appView.codeLens(), valueNumberGenerator, callerPosition, classInitializer.getOrigin(), RewrittenPrototypeDescription.none());
                DexProgramClass downcast = null;
                instructionIterator.previous();
                instructionIterator.inlineInvoke(appView, code, inliningIR, blockIterator, blocksToRemove, downcast);
            }
            code.removeBlocks(blocksToRemove);
            code.removeAllDeadAndTrivialPhis();
            return code;
        }

        @Override
        protected int computeHashCode() {
            throw new Unreachable();
        }

        @Override
        protected boolean computeEquals(Object other) {
            throw new Unreachable();
        }

        @Override
        public int estimatedDexCodeSizeUpperBoundInBytes() {
            throw new Unreachable();
        }

        @Override
        public boolean isEmptyVoidMethod() {
            throw new Unreachable();
        }

        @Override
        public void registerCodeReferences(ProgramMethod method, UseRegistry registry) {
            throw new Unreachable();
        }

        @Override
        public void registerCodeReferencesForDesugaring(ClasspathMethod method, UseRegistry registry) {
            throw new Unreachable();
        }

        @Override
        public String toString() {
            throw new Unreachable();
        }

        @Override
        public String toString(DexEncodedMethod method, ClassNameMapper naming) {
            throw new Unreachable();
        }
    }

    private class CfCodeBuilder {
        private int maxStack = 0;
        private int maxLocals = 0;

        private CfCodeBuilder() {
        }

        private List<CfInstruction> buildInstructions(Position callerPosition) {
            ArrayList<CfInstruction> newInstructions = new ArrayList<CfInstruction>();
            ClassInitializerMerger.this.classInitializers.forEach(classInitializer -> this.addCfCode((List<CfInstruction>)newInstructions, (ProgramMethod)classInitializer, callerPosition));
            newInstructions.add(new CfReturnVoid());
            return newInstructions;
        }

        private void addCfCode(List<CfInstruction> newInstructions, ProgramMethod method, Position callerPosition) {
            CfCode code = ((DexEncodedMethod)method.getDefinition()).getCode().asCfCode();
            this.maxStack = Integer.max(this.maxStack, code.getMaxStack());
            this.maxLocals = Integer.max(this.maxLocals, code.getMaxLocals());
            CfLabel endLabel = new CfLabel();
            boolean requiresLabel = false;
            int index = 1;
            for (CfInstruction instruction : code.getInstructions()) {
                if (instruction.isPosition()) {
                    CfPosition cfPosition = instruction.asPosition();
                    newInstructions.add(new CfPosition(cfPosition.getLabel(), cfPosition.getPosition().withOutermostCallerPosition(callerPosition)));
                } else if (instruction.isReturn()) {
                    if (code.getInstructions().size() != index) {
                        newInstructions.add(new CfGoto(endLabel));
                        requiresLabel = true;
                    }
                } else {
                    newInstructions.add(instruction);
                }
                ++index;
            }
            if (requiresLabel) {
                newInstructions.add(endLabel);
            }
        }

        public CfCode build(DexMethod syntheticMethodReference) {
            Position.SyntheticPosition callerPosition = ((Position.SyntheticPosition.SyntheticPositionBuilder)((Position.SyntheticPosition.SyntheticPositionBuilder)Position.SyntheticPosition.builder().setLine(0)).setMethod(syntheticMethodReference)).build();
            List<CfInstruction> instructions = this.buildInstructions(callerPosition);
            return new CfCode(syntheticMethodReference.getHolderType(), this.maxStack, this.maxLocals, instructions);
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<ProgramMethod> classInitializers = ImmutableList.builder();

        public void add(ProgramMethod classInitializer) {
            assert (((DexEncodedMethod)classInitializer.getDefinition()).isClassInitializer());
            assert (((DexEncodedMethod)classInitializer.getDefinition()).hasCode());
            this.classInitializers.add((Object)classInitializer);
        }

        public ClassInitializerMerger build() {
            return new ClassInitializerMerger((ImmutableList)this.classInitializers.build());
        }
    }
}

