/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.code;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.IRCodeProvider;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class SyntheticInitializerConverter {
    private final AppView<?> appView;
    private final IRCodeProvider codeProvider;
    private final List<ProgramMethod> classInitializers;
    private final List<ProgramMethod> instanceInitializers;

    private SyntheticInitializerConverter(AppView<?> appView, IRCodeProvider codeProvider, List<ProgramMethod> classInitializers, List<ProgramMethod> instanceInitializers) {
        this.appView = appView;
        this.codeProvider = codeProvider;
        this.classInitializers = classInitializers;
        this.instanceInitializers = instanceInitializers;
    }

    public static Builder builder(AppView<?> appView, IRCodeProvider codeProvider) {
        return new Builder(appView, codeProvider);
    }

    private AppView<AppInfo> createAppViewForConversion() {
        AppView<AppInfo> appViewForConversion = AppView.createForD8(AppInfo.createInitialAppInfo(((AppInfo)this.appView.appInfo()).app()));
        appViewForConversion.setGraphLens(this.appView.graphLens());
        appViewForConversion.setCodeLens(this.appView.codeLens());
        return appViewForConversion;
    }

    private void processMethod(ProgramMethod method, IRConverter converter) {
        IRCode code = this.codeProvider.buildIR(method);
        converter.removeDeadCodeAndFinalizeIR(code, OptimizationFeedbackIgnore.getInstance(), Timing.empty());
    }

    public void convertClassInitializers(ExecutorService executorService) throws ExecutionException {
        if (!this.classInitializers.isEmpty()) {
            IRConverter converter = new IRConverter(this.createAppViewForConversion(), Timing.empty());
            ThreadUtils.processItems(this.classInitializers, method -> this.processMethod((ProgramMethod)method, converter), executorService);
        }
    }

    public void convertInstanceInitializers(ExecutorService executorService) throws ExecutionException {
        if (!this.instanceInitializers.isEmpty()) {
            IRConverter converter = new IRConverter(this.createAppViewForConversion(), Timing.empty());
            ThreadUtils.processItems(this.instanceInitializers, method -> this.processMethod((ProgramMethod)method, converter), executorService);
        }
    }

    public boolean isEmpty() {
        return this.classInitializers.isEmpty() && this.instanceInitializers.isEmpty();
    }

    public static class Builder {
        private final AppView<?> appView;
        private final IRCodeProvider codeProvider;
        private final List<ProgramMethod> classInitializers = new ArrayList<ProgramMethod>();
        private final List<ProgramMethod> instanceInitializers = new ArrayList<ProgramMethod>();

        private Builder(AppView<?> appView, IRCodeProvider codeProvider) {
            this.appView = appView;
            this.codeProvider = codeProvider;
        }

        public Builder addClassInitializer(ProgramMethod method) {
            this.classInitializers.add(method);
            return this;
        }

        public Builder addInstanceInitializer(ProgramMethod method) {
            this.instanceInitializers.add(method);
            return this;
        }

        public SyntheticInitializerConverter build() {
            return new SyntheticInitializerConverter(this.appView, this.codeProvider, this.classInitializers, this.instanceInitializers);
        }
    }
}

