/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.collections.EmptyBidirectionalOneToOneMap;
import java.util.Collection;
import java.util.Set;

public class FinalizeMergeGroup
extends MultiClassPolicy {
    private final AppView<?> appView;
    private final HorizontalClassMerger.Mode mode;

    public FinalizeMergeGroup(AppView<?> appView, HorizontalClassMerger.Mode mode) {
        this.appView = appView;
        this.mode = mode;
    }

    private boolean verifyAlreadyFinalized(MergeGroup group) {
        assert (group.hasTarget());
        assert (group.getClasses().contains(group.getTarget()));
        assert (group.hasInstanceFieldMap());
        Set types = SetUtils.newIdentityHashSet(builder -> group.forEach(clazz -> builder.accept(clazz.getType())));
        group.getInstanceFieldMap().forEach((sourceField, targetField) -> {
            assert (types.contains(sourceField.getHolderType()));
            assert (types.contains(targetField.getHolderType()));
        });
        return true;
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group) {
        if (this.appView.enableWholeProgramOptimizations()) {
            if (this.mode.isInitial() || group.isInterfaceGroup()) {
                group.selectTarget(this.appView);
                group.selectInstanceFieldMap(this.appView.withClassHierarchy());
            } else assert (this.verifyAlreadyFinalized(group));
        } else {
            assert (!group.hasTarget());
            assert (!group.hasInstanceFieldMap());
            group.selectTarget(this.appView);
            group.setInstanceFieldMap(new EmptyBidirectionalOneToOneMap<DexEncodedField, DexEncodedField>());
        }
        return ListUtils.newLinkedList(group);
    }

    @Override
    public String getName() {
        return "FinalizeMergeGroup";
    }

    @Override
    public boolean isIdentityForInterfaceGroups() {
        return true;
    }
}

