/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class LimitInterfaceGroups
extends MultiClassPolicy {
    private final int maxGroupSize;

    public LimitInterfaceGroups(AppView<? extends AppInfoWithClassHierarchy> appView) {
        this.maxGroupSize = appView.options().horizontalClassMergerOptions().getMaxInterfaceGroupSize();
        assert (this.maxGroupSize >= 0);
    }

    private void processClass(DexProgramClass clazz, Map<MergeGroup, Integer> newGroups) {
        int increment = clazz.getMethodCollection().size();
        for (Map.Entry<MergeGroup, Integer> entry : newGroups.entrySet()) {
            MergeGroup candidateGroup = entry.getKey();
            int candidateGroupSize = entry.getValue();
            int newCandidateGroupSize = candidateGroupSize + increment;
            if (newCandidateGroupSize > this.maxGroupSize) continue;
            candidateGroup.add(clazz);
            entry.setValue(newCandidateGroupSize);
            return;
        }
        newGroups.put(new MergeGroup(clazz), increment);
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group) {
        if (group.isClassGroup()) {
            return Collections.singletonList(group);
        }
        LinkedHashMap<MergeGroup, Integer> newGroups = new LinkedHashMap<MergeGroup, Integer>();
        for (DexProgramClass clazz : group) {
            this.processClass(clazz, newGroups);
        }
        return this.removeTrivialGroups(newGroups.keySet());
    }

    @Override
    public String getName() {
        return "LimitInterfaceGroups";
    }
}

