/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.HashMultiset;
import com.android.tools.r8.com.google.common.collect.Multiset;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class MinimizeInstanceFieldCasts
extends MultiClassPolicy {
    private void addExact(DexProgramClass clazz, Map<Multiset<DexType>, MergeGroup> groups2) {
        groups2.computeIfAbsent(this.getExactMergeKey(clazz), ignore -> new MergeGroup()).add(clazz);
    }

    private Multiset<DexType> getExactMergeKey(DexProgramClass clazz) {
        HashMultiset<DexType> fieldTypes = HashMultiset.create();
        for (DexEncodedField field : clazz.instanceFields()) {
            fieldTypes.add(field.getType());
        }
        return fieldTypes;
    }

    @Override
    public final Collection<MergeGroup> apply(MergeGroup group) {
        LinkedHashMap newGroups = new LinkedHashMap();
        group.forEach(clazz -> this.addExact((DexProgramClass)clazz, newGroups));
        MergeGroup pendingGroup = new MergeGroup();
        newGroups.values().removeIf(newGroup -> {
            if (newGroup.isTrivial()) {
                pendingGroup.add((MergeGroup)newGroup);
                return true;
            }
            return false;
        });
        if (pendingGroup.isEmpty()) {
            return newGroups.values();
        }
        if (!pendingGroup.isTrivial()) {
            ArrayList<MergeGroup> newGroupsIncludingRelaxedGroup = new ArrayList<MergeGroup>(newGroups.values());
            newGroupsIncludingRelaxedGroup.add(pendingGroup);
            return newGroupsIncludingRelaxedGroup;
        }
        MergeGroup smallestNewGroup = null;
        for (MergeGroup newGroup2 : newGroups.values()) {
            if (smallestNewGroup != null && newGroup2.size() >= smallestNewGroup.size()) continue;
            smallestNewGroup = newGroup2;
        }
        assert (smallestNewGroup != null);
        smallestNewGroup.add(pendingGroup);
        return newGroups.values();
    }

    @Override
    public String getName() {
        return "MinimizeFieldCasts";
    }
}

