/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.code.CfOrDexInstruction;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicyWithPreprocessing;
import com.android.tools.r8.horizontalclassmerging.policies.deadlock.SingleCallerInformation;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.TraversalContinuation;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class NoClassInitializerCycles
extends MultiClassPolicyWithPreprocessing<Void> {
    final AppView<AppInfoWithLiveness> appView;
    final Map<DexProgramClass, MergeGroup> allGroups = new IdentityHashMap<DexProgramClass, MergeGroup>();
    private SingleCallerInformation singleCallerInformation;

    public NoClassInitializerCycles(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    private void commit(MergeGroup oldGroup, List<MergeGroup> newGroups) {
        for (MergeGroup newGroup : newGroups) {
            for (DexProgramClass member : newGroup) {
                this.allGroups.put(member, newGroup);
            }
        }
        for (DexProgramClass member : oldGroup) {
            MergeGroup newGroup = this.allGroups.get(member);
            if (newGroup != oldGroup) continue;
            this.allGroups.remove(member);
        }
    }

    private MergeGroup getOrCreateGroupFor(DexProgramClass clazz, List<MergeGroup> groups2, Tracer tracer) {
        assert (!tracer.hasPossibleClassInitializerDeadlock(clazz));
        if (clazz.hasClassInitializer()) {
            tracer.setTracingRoot(clazz);
            tracer.enqueueTracingRoot(clazz.getProgramClassInitializer());
            tracer.trace();
            if (tracer.hasPossibleClassInitializerDeadlock(clazz)) {
                return null;
            }
        }
        for (MergeGroup group : groups2) {
            if (!this.canMerge(clazz, group, tracer)) continue;
            return group;
        }
        MergeGroup newGroup = new MergeGroup();
        groups2.add(newGroup);
        return newGroup;
    }

    private boolean canMerge(DexProgramClass clazz, MergeGroup group, Tracer tracer) {
        for (DexProgramClass member : group) {
            if (tracer.isClassInitializedByClassInitializationOf(member, clazz)) {
                return false;
            }
            if (!tracer.isClassInitializedByClassInitializationOf(clazz, member)) continue;
            return false;
        }
        return true;
    }

    private List<MergeGroup> partitionClassesWithPossibleClassInitializerDeadlock(MergeGroup group) {
        Set<DexProgramClass> superclasses = Sets.newIdentityHashSet();
        this.appView.appInfo().traverseSuperClasses(group.iterator().next(), (supertype, superclass, immediateSubclass) -> {
            if (superclass != null && superclass.isProgramClass()) {
                superclasses.add(superclass.asProgramClass());
                return TraversalContinuation.doContinue();
            }
            return TraversalContinuation.doBreak();
        });
        Tracer tracer = new Tracer(group);
        tracer.setTracingRoots(group);
        for (DexProgramClass superclass2 : superclasses) {
            if (!superclass2.hasClassInitializer()) continue;
            tracer.enqueueTracingRoot(superclass2.getProgramClassInitializer());
        }
        tracer.trace();
        MergeGroup notInitializedByInitializationOfParent = new MergeGroup();
        LinkedHashMap<DexProgramClass, MergeGroup> partitioning = new LinkedHashMap<DexProgramClass, MergeGroup>();
        for (DexProgramClass member : group) {
            if (tracer.hasPossibleClassInitializerDeadlock(member)) {
                DexProgramClass nearestLock = this.getNearestLock(member, superclasses);
                if (nearestLock == null) continue;
                partitioning.computeIfAbsent(nearestLock, MapUtils.ignoreKey(MergeGroup::new)).add(member);
                continue;
            }
            notInitializedByInitializationOfParent.add(member);
        }
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(notInitializedByInitializationOfParent)).addAll((Iterable)partitioning.values())).build();
    }

    private DexProgramClass getNearestLock(DexProgramClass clazz, Set<DexProgramClass> candidateOwners) {
        ProgramMethodSet seen = ProgramMethodSet.create();
        ProgramMethod singleCaller = this.singleCallerInformation.getSingleClassInitializerCaller(clazz);
        while (singleCaller != null && seen.add(singleCaller)) {
            if (((DexEncodedMethod)singleCaller.getDefinition()).isClassInitializer() && candidateOwners.contains(singleCaller.getHolder())) {
                return singleCaller.getHolder();
            }
            singleCaller = this.singleCallerInformation.getSingleCaller(singleCaller);
        }
        return null;
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group, Void nothing) {
        List<MergeGroup> partitioning = this.partitionClassesWithPossibleClassInitializerDeadlock(group);
        LinkedList<MergeGroup> newGroups = new LinkedList<MergeGroup>();
        for (MergeGroup partition : partitioning) {
            LinkedList<MergeGroup> newGroupsFromPartition = new LinkedList<MergeGroup>();
            Tracer tracer = new Tracer(partition);
            for (DexProgramClass clazz : partition) {
                MergeGroup newGroup = this.getOrCreateGroupFor(clazz, newGroupsFromPartition, tracer);
                if (newGroup == null) continue;
                newGroup.add(clazz);
            }
            newGroups.addAll(newGroupsFromPartition);
        }
        this.removeTrivialGroups(newGroups);
        this.commit(group, newGroups);
        return newGroups;
    }

    @Override
    public void clear() {
        this.allGroups.clear();
    }

    @Override
    public String getName() {
        return "NoClassInitializerCycles";
    }

    @Override
    public Void preprocess(Collection<MergeGroup> groups2, ExecutorService executorService) throws ExecutionException {
        for (MergeGroup group : groups2) {
            for (DexProgramClass clazz : group) {
                this.allGroups.put(clazz, group);
            }
        }
        this.singleCallerInformation = SingleCallerInformation.builder(this.appView).analyze(executorService).build();
        return null;
    }

    @Override
    public boolean shouldSkipPolicy() {
        InternalOptions.HorizontalClassMergerOptions options = this.appView.options().horizontalClassMergerOptions();
        return !options.isClassInitializerDeadlockDetectionEnabled();
    }

    private class Tracer {
        final MergeGroup group;
        final Set<DexProgramClass> groupMembers;
        private final Set<DexProgramClass> seenClassInitializers = Sets.newIdentityHashSet();
        private final ProgramMethodSet seenMethods = ProgramMethodSet.create();
        private final Deque<ProgramMethod> worklist = new ArrayDeque<ProgramMethod>();
        private final Map<DexProgramClass, Set<DexProgramClass>> classInitializerReachableFromClasses = new IdentityHashMap<DexProgramClass, Set<DexProgramClass>>();
        private Collection<DexProgramClass> tracingRoots;

        Tracer(MergeGroup group) {
            this.group = group;
            this.groupMembers = SetUtils.newIdentityHashSet(group);
        }

        private void processWorklist() {
            while (!this.worklist.isEmpty()) {
                ProgramMethod method = this.worklist.removeLast();
                method.registerCodeReferences(new TracerUseRegistry(method));
            }
        }

        void clearSeen() {
            this.seenClassInitializers.clear();
            this.seenMethods.clear();
        }

        void clearWorklist() {
            this.worklist.clear();
        }

        boolean markClassInitializerAsSeen(DexProgramClass clazz) {
            return this.seenClassInitializers.add(clazz);
        }

        boolean enqueueMethod(ProgramMethod method) {
            if (this.seenMethods.add(method)) {
                this.worklist.addLast(method);
                return true;
            }
            return false;
        }

        void enqueueTracingRoot(ProgramMethod tracingRoot) {
            boolean added = this.seenMethods.add(tracingRoot);
            assert (added);
            this.worklist.add(tracingRoot);
        }

        void recordClassInitializerReachableFromTracingRoots(DexProgramClass clazz) {
            assert (this.groupMembers.contains(clazz));
            this.classInitializerReachableFromClasses.computeIfAbsent(clazz, MapUtils.ignoreKey(Sets::newIdentityHashSet)).addAll(this.tracingRoots);
        }

        void recordTracingRootsIneligibleForClassMerging() {
            for (DexProgramClass tracingRoot : this.tracingRoots) {
                this.classInitializerReachableFromClasses.computeIfAbsent(tracingRoot, MapUtils.ignoreKey(Sets::newIdentityHashSet)).add(tracingRoot);
            }
        }

        boolean hasSingleTracingRoot(DexProgramClass clazz) {
            return this.tracingRoots.size() == 1 && this.tracingRoots.contains(clazz);
        }

        boolean hasPossibleClassInitializerDeadlock(DexProgramClass clazz) {
            return this.classInitializerReachableFromClasses.getOrDefault(clazz, Collections.emptySet()).contains(clazz);
        }

        boolean isClassInitializedByClassInitializationOf(DexProgramClass classToBeInitialized, DexProgramClass classBeingInitialized) {
            return this.classInitializerReachableFromClasses.getOrDefault(classToBeInitialized, Collections.emptySet()).contains(classBeingInitialized);
        }

        void setTracingRoot(DexProgramClass tracingRoot) {
            this.setTracingRoots(ImmutableList.of(tracingRoot));
        }

        void setTracingRoots(Collection<DexProgramClass> tracingRoots) {
            assert (this.verifySeenSetIsEmpty());
            assert (this.verifyWorklistIsEmpty());
            this.tracingRoots = tracingRoots;
        }

        void trace() {
            this.processWorklist();
            this.clearSeen();
        }

        boolean verifySeenSetIsEmpty() {
            assert (this.seenClassInitializers.isEmpty());
            assert (this.seenMethods.isEmpty());
            return true;
        }

        boolean verifyWorklistIsEmpty() {
            assert (this.worklist.isEmpty());
            return true;
        }

        class TracerUseRegistry
        extends UseRegistry<ProgramMethod> {
            TracerUseRegistry(ProgramMethod context) {
                super(NoClassInitializerCycles.this.appView, context);
            }

            private void fail() {
                Tracer.this.recordTracingRootsIneligibleForClassMerging();
                this.doBreak();
                Tracer.this.clearWorklist();
            }

            private void triggerClassInitializerIfNotAlreadyTriggeredInContext(DexType type) {
                DexProgramClass clazz = type.asProgramClass(NoClassInitializerCycles.this.appView);
                if (clazz != null) {
                    this.triggerClassInitializerIfNotAlreadyTriggeredInContext(clazz);
                }
            }

            private void triggerClassInitializerIfNotAlreadyTriggeredInContext(DexProgramClass clazz) {
                if (!this.isClassAlreadyInitializedInCurrentContext(clazz)) {
                    this.triggerClassInitializer(clazz);
                }
            }

            private boolean isClassAlreadyInitializedInCurrentContext(DexProgramClass clazz) {
                return NoClassInitializerCycles.this.appView.appInfo().isSubtype(((ProgramMethod)this.getContext()).getHolder(), clazz);
            }

            private void triggerClassInitializer(DexType type) {
                DexProgramClass clazz = type.asProgramClass(NoClassInitializerCycles.this.appView);
                if (clazz != null) {
                    this.triggerClassInitializer(clazz);
                }
            }

            private void triggerClassInitializer(DexProgramClass clazz) {
                ProgramMethod classInitializer;
                if (!Tracer.this.markClassInitializerAsSeen(clazz)) {
                    return;
                }
                if (Tracer.this.groupMembers.contains(clazz)) {
                    if (Tracer.this.hasSingleTracingRoot(clazz)) {
                        this.fail();
                    } else {
                        Tracer.this.recordClassInitializerReachableFromTracingRoots(clazz);
                    }
                }
                if ((classInitializer = clazz.getProgramClassInitializer()) != null && !Tracer.this.enqueueMethod(classInitializer)) {
                    return;
                }
                this.triggerClassInitializer(clazz.getSuperType());
                MergeGroup other = NoClassInitializerCycles.this.allGroups.get(clazz);
                if (other != null && other != Tracer.this.group) {
                    for (DexProgramClass member : other) {
                        this.triggerClassInitializer(member);
                    }
                }
            }

            @Override
            public void registerInitClass(DexType type) {
                DexType rewrittenType = NoClassInitializerCycles.this.appView.graphLens().lookupType(type);
                this.triggerClassInitializerIfNotAlreadyTriggeredInContext(rewrittenType);
            }

            @Override
            public void registerInvokeDirect(DexMethod method) {
                DexMethod rewrittenMethod = (DexMethod)NoClassInitializerCycles.this.appView.graphLens().lookupInvokeDirect(method, (ProgramMethod)this.getContext()).getReference();
                MethodResolutionResult resolutionResult = NoClassInitializerCycles.this.appView.appInfo().resolveMethodOnClass(rewrittenMethod);
                if (resolutionResult.isSingleResolution() && resolutionResult.getResolvedHolder().isProgramClass()) {
                    Tracer.this.enqueueMethod(resolutionResult.getResolvedProgramMethod());
                }
            }

            @Override
            public void registerInvokeInterface(DexMethod method) {
                DexMethod rewrittenMethod = (DexMethod)NoClassInitializerCycles.this.appView.graphLens().lookupInvokeInterface(method, (ProgramMethod)this.getContext()).getReference();
                DexClassAndMethod resolvedMethod = NoClassInitializerCycles.this.appView.appInfo().resolveMethodOnInterface(rewrittenMethod).getResolutionPair();
                if (resolvedMethod != null) {
                    this.fail();
                }
            }

            @Override
            public void registerInvokeStatic(DexMethod method) {
                DexMethod rewrittenMethod = (DexMethod)NoClassInitializerCycles.this.appView.graphLens().lookupInvokeStatic(method, (ProgramMethod)this.getContext()).getReference();
                ProgramMethod resolvedMethod = NoClassInitializerCycles.this.appView.appInfo().unsafeResolveMethodDueToDexFormat(rewrittenMethod).getResolvedProgramMethod();
                if (resolvedMethod != null) {
                    this.triggerClassInitializerIfNotAlreadyTriggeredInContext(resolvedMethod.getHolder());
                    Tracer.this.enqueueMethod(resolvedMethod);
                }
            }

            @Override
            public void registerInvokeSuper(DexMethod method) {
                DexMethod rewrittenMethod = (DexMethod)NoClassInitializerCycles.this.appView.graphLens().lookupInvokeSuper(method, (ProgramMethod)this.getContext()).getReference();
                ProgramMethod superTarget = DexClassAndMethod.asProgramMethodOrNull(NoClassInitializerCycles.this.appView.appInfo().lookupSuperTarget(rewrittenMethod, (ProgramMethod)this.getContext()));
                if (superTarget != null) {
                    Tracer.this.enqueueMethod(superTarget);
                }
            }

            @Override
            public void registerInvokeVirtual(DexMethod method) {
                DexMethod rewrittenMethod = (DexMethod)NoClassInitializerCycles.this.appView.graphLens().lookupInvokeVirtual(method, (ProgramMethod)this.getContext()).getReference();
                DexClassAndMethod resolvedMethod = NoClassInitializerCycles.this.appView.appInfo().resolveMethodOnClass(rewrittenMethod).getResolutionPair();
                if (resolvedMethod != null) {
                    if (!resolvedMethod.getHolder().isEffectivelyFinal(NoClassInitializerCycles.this.appView)) {
                        this.fail();
                    } else if (resolvedMethod.isProgramMethod()) {
                        Tracer.this.enqueueMethod(resolvedMethod.asProgramMethod());
                    }
                }
            }

            @Override
            public void registerNewInstance(DexType type) {
                DexType rewrittenType = NoClassInitializerCycles.this.appView.graphLens().lookupType(type);
                this.triggerClassInitializerIfNotAlreadyTriggeredInContext(rewrittenType);
            }

            @Override
            public void registerStaticFieldRead(DexField field) {
                DexField rewrittenField = NoClassInitializerCycles.this.appView.graphLens().lookupField(field);
                this.triggerClassInitializerIfNotAlreadyTriggeredInContext(rewrittenField.getHolderType());
            }

            @Override
            public void registerStaticFieldWrite(DexField field) {
                DexField rewrittenField = NoClassInitializerCycles.this.appView.graphLens().lookupField(field);
                this.triggerClassInitializerIfNotAlreadyTriggeredInContext(rewrittenField.getHolderType());
            }

            @Override
            public void registerTypeReference(DexType type) {
            }

            @Override
            public void registerCallSite(DexCallSite callSite) {
                if (!LambdaDescriptor.isLambdaMetafactoryMethod(callSite, NoClassInitializerCycles.this.appView.appInfo())) {
                    this.fail();
                }
            }

            @Override
            public void registerCheckCast(DexType type, boolean ignoreCompatRules) {
            }

            @Override
            public void registerConstClass(DexType type, ListIterator<? extends CfOrDexInstruction> iterator2, boolean ignoreCompatRules) {
            }

            @Override
            public void registerInstanceFieldRead(DexField field) {
            }

            @Override
            public void registerInstanceFieldWrite(DexField field) {
            }

            @Override
            public void registerInstanceOf(DexType type) {
            }

            @Override
            public void registerExceptionGuard(DexType guard) {
            }
        }
    }
}

