/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicyWithPreprocessing;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.WorkList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class NoConstructorCollisions
extends MultiClassPolicyWithPreprocessing<Set<DexType>> {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;

    public NoConstructorCollisions(AppView<?> appView, HorizontalClassMerger.Mode mode) {
        assert (mode.isFinal());
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
    }

    private DexProto rewriteProto(DexProto proto, Map<DexType, MergeGroup> groups2) {
        DexType[] parameters = ArrayUtils.map(proto.getParameters().values, parameter -> this.rewriteType((DexType)parameter, groups2), DexType.EMPTY_ARRAY);
        return this.dexItemFactory.createProto(this.rewriteType(proto.getReturnType(), groups2), parameters);
    }

    private DexMethod rewriteReference(DexMethod method, Map<DexType, MergeGroup> groups2) {
        return this.dexItemFactory.createMethod(this.rewriteType(method.getHolderType(), groups2), this.rewriteProto(method.getProto(), groups2), method.getName());
    }

    private DexType rewriteType(DexType type, Map<DexType, MergeGroup> groups2) {
        if (type.isArrayType()) {
            DexType baseType = type.toBaseType(this.dexItemFactory);
            DexType rewrittenBaseType = this.rewriteType(baseType, groups2);
            if (rewrittenBaseType == baseType) {
                return type;
            }
            return type.replaceBaseType(rewrittenBaseType, this.dexItemFactory);
        }
        if (type.isClassType()) {
            if (!groups2.containsKey(type)) {
                return type;
            }
            return groups2.get(type).getClasses().getFirst().getType();
        }
        assert (type.isPrimitiveType() || type.isVoidType());
        return type;
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group, Set<DexType> collisionResolution) {
        MergeGroup newGroup = new MergeGroup(Iterables.filter(group, clazz -> !collisionResolution.contains(clazz.getType())));
        return newGroup.isTrivial() ? Collections.emptyList() : ListUtils.newLinkedList(newGroup);
    }

    @Override
    public Set<DexType> preprocess(Collection<MergeGroup> groups2, ExecutorService executorService) {
        IdentityHashMap<DexType, MergeGroup> groupsByType = new IdentityHashMap<DexType, MergeGroup>();
        for (MergeGroup group : groups2) {
            for (DexProgramClass clazz : group) {
                groupsByType.put(clazz.getType(), group);
            }
        }
        Set<DexType> collisionResolution = Sets.newIdentityHashSet();
        WorkList<DexProgramClass> workList = WorkList.newIdentityWorkList(((AppInfo)this.appView.appInfo()).classes());
        while (workList.hasNext()) {
            DexProgramClass current = workList.next();
            Iterable group = groupsByType.containsKey(current.getType()) ? (Iterable)groupsByType.get(current.getType()) : IterableUtils.singleton(current);
            Set<DexMethod> seen = Sets.newIdentityHashSet();
            for (DexProgramClass clazz : group) {
                for (DexEncodedMethod method : clazz.directMethods(DexEncodedMethod::isInstanceInitializer)) {
                    DexMethod newReference = this.rewriteReference((DexMethod)method.getReference(), groupsByType);
                    if (seen.add(newReference)) continue;
                    for (DexType type : method.getProto().getBaseTypes(this.dexItemFactory)) {
                        if (!type.isClassType() || !groupsByType.containsKey(type)) continue;
                        collisionResolution.add(type);
                    }
                }
            }
            workList.markAsSeen(group);
        }
        return collisionResolution;
    }

    @Override
    public String getName() {
        return "NoConstructorCollisions";
    }
}

