/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.horizontalclassmerging.SingleClassPolicy;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;

public class NoFailedResolutionTargets
extends SingleClassPolicy {
    private final Set<DexType> failedResolutionHolders = Sets.newIdentityHashSet();

    public NoFailedResolutionTargets(AppView<AppInfoWithLiveness> appView) {
        for (DexMethod method : appView.appInfo().getFailedMethodResolutionTargets()) {
            this.failedResolutionHolders.add(method.holder);
        }
    }

    @Override
    public String getName() {
        return "NoFailedResolutionTargets";
    }

    @Override
    public boolean canMerge(DexProgramClass program) {
        return !this.failedResolutionHolders.contains(program.getType());
    }
}

