/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.SingleClassPolicy;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class NoIllegalInlining
extends SingleClassPolicy {
    private final AppView<AppInfoWithLiveness> appView;

    public NoIllegalInlining(AppView<AppInfoWithLiveness> appView, HorizontalClassMerger.Mode mode) {
        assert (mode.isInitial());
        this.appView = appView;
    }

    private boolean disallowInlining(ProgramMethod method) {
        Code code = ((DexEncodedMethod)method.getDefinition()).getCode();
        if (!this.appView.getKeepInfo(method).isInliningAllowed(this.appView.options())) {
            return true;
        }
        if (code == null) {
            return true;
        }
        if (code.isCfCode()) {
            CfCode cfCode = code.asCfCode();
            Inliner.ConstraintWithTarget constraint = cfCode.computeInliningConstraint(method, this.appView, this.appView.graphLens(), method);
            return constraint == Inliner.ConstraintWithTarget.NEVER;
        }
        return !code.isDefaultInstanceInitializerCode();
    }

    @Override
    public boolean canMerge(DexProgramClass program) {
        return !Iterables.any(program.directProgramMethods(), method -> ((DexEncodedMethod)method.getDefinition()).isInstanceInitializer() && this.disallowInlining((ProgramMethod)method));
    }

    @Override
    public String getName() {
        return "DontInlinePolicy";
    }
}

