/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.horizontalclassmerging.MultiClassSameReferencePolicy;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import com.android.tools.r8.shaking.RuntimeTypeCheckInfo;

public class NoIndirectRuntimeTypeChecks
extends MultiClassSameReferencePolicy<DexTypeList> {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final RuntimeTypeCheckInfo runtimeTypeCheckInfo;
    private final Reference2BooleanMap<DexType> cache = new Reference2BooleanOpenHashMap<DexType>();

    public NoIndirectRuntimeTypeChecks(AppView<? extends AppInfoWithClassHierarchy> appView, RuntimeTypeCheckInfo runtimeTypeCheckInfo) {
        this.appView = appView;
        this.runtimeTypeCheckInfo = runtimeTypeCheckInfo;
    }

    private boolean computeInterfaceHasDirectOrIndirectRuntimeTypeCheck(DexType type) {
        if (this.cache.containsKey(type)) {
            return this.cache.getBoolean(type);
        }
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz == null || !clazz.isInterface()) {
            this.cache.put(type, true);
            return true;
        }
        if (!clazz.isProgramClass()) {
            this.cache.put(type, true);
            return true;
        }
        if (this.runtimeTypeCheckInfo == null || this.runtimeTypeCheckInfo.isRuntimeCheckType(clazz.asProgramClass())) {
            this.cache.put(type, true);
            return true;
        }
        if (clazz.hasClassInitializer() && clazz.getClassInitializer().getOptimizationInfo().mayHaveSideEffects() && clazz.getMethodCollection().hasVirtualMethods(method -> !method.isAbstract())) {
            this.cache.put(type, true);
            return true;
        }
        for (DexType parentType : clazz.getInterfaces()) {
            if (!this.computeInterfaceHasDirectOrIndirectRuntimeTypeCheck(parentType)) continue;
            this.cache.put(type, true);
            return true;
        }
        return false;
    }

    @Override
    public DexTypeList getMergeKey(DexProgramClass clazz) {
        return clazz.getInterfaces().keepIf(this::computeInterfaceHasDirectOrIndirectRuntimeTypeCheck).getSorted();
    }

    @Override
    public String getName() {
        return "NoIndirectRuntimeTypeChecks";
    }
}

