/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.SetUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class NoVirtualMethodMerging
extends MultiClassPolicy {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;

    public NoVirtualMethodMerging(AppView<? extends AppInfoWithClassHierarchy> appView, HorizontalClassMerger.Mode mode) {
        assert (mode.isFinal());
        this.appView = appView;
    }

    private boolean canAddNonAbstractVirtualMethodsToGroup(DexProgramClass clazz, Collection<ProgramMethod> methods, MergeGroup group, Map<DexMethodSignature, ProgramMethod> groupMethods) {
        for (ProgramMethod method : methods) {
            ProgramMethod groupMethod = groupMethods.get(method.getMethodSignature());
            if (groupMethod == null && !this.hasNonAbstractDefinitionInHierarchy(group, method)) continue;
            return false;
        }
        for (ProgramMethod method : groupMethods.values()) {
            if (!this.hasNonAbstractDefinitionInHierarchy(clazz, method)) continue;
            return false;
        }
        return true;
    }

    private boolean hasNonAbstractDefinitionInHierarchy(MergeGroup group, ProgramMethod method) {
        return this.hasNonAbstractDefinitionInSuperClass(group.getSuperType(), method) || this.hasNonAbstractDefinitionInSuperInterface(SetUtils.newIdentityHashSet(IterableUtils.flatMap(group, DexClass::getInterfaces)), method);
    }

    private boolean hasNonAbstractDefinitionInHierarchy(DexProgramClass clazz, ProgramMethod method) {
        return this.hasNonAbstractDefinitionInSuperClass(clazz.getSuperType(), method) || this.hasNonAbstractDefinitionInSuperInterface(clazz.getInterfaces(), method);
    }

    private boolean hasNonAbstractDefinitionInSuperClass(DexType superType, ProgramMethod method) {
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOnClass((DexMethod)method.getReference(), superType).asSingleResolution();
        return resolutionResult != null && !resolutionResult.getResolvedMethod().isAbstract();
    }

    private boolean hasNonAbstractDefinitionInSuperInterface(Iterable<DexType> interfaceTypes, ProgramMethod method) {
        return Iterables.any(interfaceTypes, interfaceType -> {
            MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOnInterface((DexType)interfaceType, (DexMethod)method.getReference()).asSingleResolution();
            return resolutionResult != null && !resolutionResult.getResolvedMethod().isAbstract();
        });
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group) {
        LinkedHashMap newGroups = new LinkedHashMap();
        for (DexProgramClass clazz : group) {
            HashMap classMethods = new HashMap();
            clazz.forEachProgramVirtualMethodMatching(DexEncodedMethod::isNonAbstractVirtualMethod, method -> classMethods.put(method.getMethodSignature(), method));
            MergeGroup newGroup = null;
            for (Map.Entry entry : newGroups.entrySet()) {
                MergeGroup candidateGroup = (MergeGroup)entry.getKey();
                Map groupMethods = (Map)entry.getValue();
                if (!this.canAddNonAbstractVirtualMethodsToGroup(clazz, classMethods.values(), candidateGroup, groupMethods)) continue;
                newGroup = candidateGroup;
                groupMethods.putAll(classMethods);
                break;
            }
            if (newGroup != null) {
                newGroup.add(clazz);
                continue;
            }
            newGroups.put(new MergeGroup(clazz), classMethods);
        }
        return this.removeTrivialGroups(newGroups.keySet());
    }

    @Override
    public String getName() {
        return "NoVirtualMethodMerging";
    }
}

