/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.OptionalBool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

public class PreserveMethodCharacteristics
extends MultiClassPolicy {
    private final AppView<AppInfoWithLiveness> appView;

    public PreserveMethodCharacteristics(AppView<AppInfoWithLiveness> appView, HorizontalClassMerger.Mode mode) {
        assert (mode.isInitial());
        this.appView = appView;
    }

    @Override
    public String getName() {
        return "PreserveMethodCharacteristics";
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group) {
        ArrayList<TargetGroup> groups2 = new ArrayList<TargetGroup>();
        for (DexProgramClass clazz : group) {
            boolean added = Iterables.any(groups2, targetGroup -> targetGroup.tryAdd(this.appView, clazz));
            if (added) continue;
            TargetGroup newGroup = new TargetGroup();
            added = newGroup.tryAdd(this.appView, clazz);
            assert (added);
            groups2.add(newGroup);
        }
        LinkedList<MergeGroup> newGroups = new LinkedList<MergeGroup>();
        for (TargetGroup newGroup : groups2) {
            if (newGroup.getGroup().isTrivial()) continue;
            newGroups.add(newGroup.getGroup());
        }
        return newGroups;
    }

    public static class TargetGroup {
        private final MergeGroup group = new MergeGroup();
        private final Map<DexMethodSignature, MethodCharacteristics> methodMap = new HashMap<DexMethodSignature, MethodCharacteristics>();

        private boolean isSubjectToMethodMerging(DexEncodedMethod method) {
            return !method.isStatic() && (!method.isPrivate() || method.isInstanceInitializer());
        }

        public MergeGroup getGroup() {
            return this.group;
        }

        public boolean tryAdd(AppView<AppInfoWithLiveness> appView, DexProgramClass clazz) {
            HashMap<DexMethodSignature, MethodCharacteristics> newMethods = new HashMap<DexMethodSignature, MethodCharacteristics>();
            for (DexEncodedMethod method : clazz.methods(this::isSubjectToMethodMerging)) {
                DexMethodSignature signature = method.getSignature();
                MethodCharacteristics existingCharacteristics = this.methodMap.get(signature);
                MethodCharacteristics methodCharacteristics = MethodCharacteristics.create(appView, method);
                if (existingCharacteristics == null) {
                    newMethods.put(signature, methodCharacteristics);
                    continue;
                }
                if (methodCharacteristics.equals(existingCharacteristics)) continue;
                return false;
            }
            this.methodMap.putAll(newMethods);
            this.group.add(clazz);
            return true;
        }
    }

    static class MethodCharacteristics {
        private final MethodAccessFlags accessFlags;
        private final boolean isAssumeNoSideEffectsMethod;
        private final OptionalBool isLibraryMethodOverride;
        private final boolean isMainDexRoot;

        private MethodCharacteristics(DexEncodedMethod method, boolean isAssumeNoSideEffectsMethod, boolean isMainDexRoot) {
            this.accessFlags = (MethodAccessFlags)((MethodAccessFlags.Builder)((MethodAccessFlags.Builder)((MethodAccessFlags.Builder)MethodAccessFlags.builder().setPrivate(method.getAccessFlags().isPrivate())).setProtected(method.getAccessFlags().isProtected())).setPublic(method.getAccessFlags().isPublic())).setStrict(method.getAccessFlags().isStrict()).setSynchronized(method.getAccessFlags().isSynchronized()).build();
            this.isAssumeNoSideEffectsMethod = isAssumeNoSideEffectsMethod;
            this.isLibraryMethodOverride = method.isLibraryMethodOverride();
            this.isMainDexRoot = isMainDexRoot;
        }

        static MethodCharacteristics create(AppView<AppInfoWithLiveness> appView, DexEncodedMethod method) {
            return new MethodCharacteristics(method, appView.appInfo().isAssumeNoSideEffectsMethod((DexMethod)method.getReference()), appView.appInfo().getMainDexInfo().isTracedMethodRoot((DexMethod)method.getReference()));
        }

        public int hashCode() {
            return Objects.hash(this.accessFlags, this.isAssumeNoSideEffectsMethod, this.isLibraryMethodOverride.ordinal(), this.isMainDexRoot);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodCharacteristics characteristics = (MethodCharacteristics)obj;
            return this.accessFlags.equals(characteristics.accessFlags) && this.isAssumeNoSideEffectsMethod == characteristics.isAssumeNoSideEffectsMethod && this.isLibraryMethodOverride == characteristics.isLibraryMethodOverride && this.isMainDexRoot == characteristics.isMainDexRoot;
        }
    }
}

