/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.HashMultiset;
import com.android.tools.r8.com.google.common.collect.Multiset;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.MultiClassSameReferencePolicy;
import java.util.Objects;

public class SameInstanceFields
extends MultiClassSameReferencePolicy<Multiset<InstanceFieldInfo>> {
    private final DexItemFactory dexItemFactory;
    private final HorizontalClassMerger.Mode mode;

    public SameInstanceFields(AppView<? extends AppInfoWithClassHierarchy> appView, HorizontalClassMerger.Mode mode) {
        this.dexItemFactory = appView.dexItemFactory();
        this.mode = mode;
    }

    @Override
    public Multiset<InstanceFieldInfo> getMergeKey(DexProgramClass clazz) {
        HashMultiset<InstanceFieldInfo> fields = HashMultiset.create();
        for (DexEncodedField field : clazz.instanceFields()) {
            InstanceFieldInfo instanceFieldInfo = this.mode.isInitial() ? InstanceFieldInfo.createRelaxed(field, this.dexItemFactory) : InstanceFieldInfo.createExact(field);
            fields.add(instanceFieldInfo);
        }
        return fields;
    }

    @Override
    public String getName() {
        return "SameInstanceFields";
    }

    public static class InstanceFieldInfo {
        private final FieldAccessFlags accessFlags;
        private final DexType type;

        private InstanceFieldInfo(FieldAccessFlags accessFlags, DexType type) {
            this.accessFlags = (FieldAccessFlags)((FieldAccessFlags)FieldAccessFlags.fromSharedAccessFlags(accessFlags.materialize()).unsetFinal()).unsetSynthetic();
            this.type = type;
        }

        public static InstanceFieldInfo createExact(DexEncodedField field) {
            return new InstanceFieldInfo(field.getAccessFlags(), field.getType());
        }

        public static InstanceFieldInfo createRelaxed(DexEncodedField field, DexItemFactory dexItemFactory) {
            return new InstanceFieldInfo(field.getAccessFlags(), field.getType().isReferenceType() ? dexItemFactory.objectType : field.getType());
        }

        public FieldAccessFlags getAccessFlags() {
            return this.accessFlags;
        }

        public InstanceFieldInfo toInfoWithRelaxedType(DexItemFactory dexItemFactory) {
            return new InstanceFieldInfo(this.accessFlags, this.type.isReferenceType() ? dexItemFactory.objectType : this.type);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceFieldInfo info = (InstanceFieldInfo)obj;
            return this.accessFlags.materialize() == info.accessFlags.materialize() && this.type == info.type;
        }

        public int hashCode() {
            return Objects.hash(this.accessFlags, this.type);
        }
    }
}

