/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.inspector.internal;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.inspector.ClassInspector;
import com.android.tools.r8.inspector.FieldInspector;
import com.android.tools.r8.inspector.MethodInspector;
import com.android.tools.r8.inspector.internal.FieldInspectorImpl;
import com.android.tools.r8.inspector.internal.MethodInspectorImpl;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.Reference;
import java.util.function.Consumer;

public class ClassInspectorImpl
implements ClassInspector {
    private final DexClass clazz;
    private ClassReference reference = null;

    ClassInspectorImpl(DexClass clazz) {
        this.clazz = clazz;
    }

    @Override
    public ClassReference getClassReference() {
        if (this.reference == null) {
            this.reference = Reference.classFromDescriptor(this.clazz.type.toDescriptorString());
        }
        return this.reference;
    }

    @Override
    public String getSourceFile() {
        DexString sourceFile = this.clazz.getSourceFile();
        return sourceFile == null ? null : sourceFile.toString();
    }

    @Override
    public void forEachField(Consumer<FieldInspector> inspection) {
        this.clazz.forEachField((DexEncodedField field) -> inspection.accept(new FieldInspectorImpl(this, (DexEncodedField)field)));
    }

    @Override
    public void forEachMethod(Consumer<MethodInspector> inspection) {
        this.clazz.forEachMethod((DexEncodedMethod method) -> inspection.accept(new MethodInspectorImpl(this, (DexEncodedMethod)method)));
    }
}

