/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.inspector.internal;

import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.inspector.BooleanValueInspector;
import com.android.tools.r8.inspector.ByteValueInspector;
import com.android.tools.r8.inspector.CharValueInspector;
import com.android.tools.r8.inspector.DoubleValueInspector;
import com.android.tools.r8.inspector.FloatValueInspector;
import com.android.tools.r8.inspector.IntValueInspector;
import com.android.tools.r8.inspector.LongValueInspector;
import com.android.tools.r8.inspector.ShortValueInspector;
import com.android.tools.r8.inspector.StringValueInspector;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.references.TypeReference;

public class ValueInspectorImpl
implements BooleanValueInspector,
ByteValueInspector,
CharValueInspector,
ShortValueInspector,
IntValueInspector,
LongValueInspector,
FloatValueInspector,
DoubleValueInspector,
StringValueInspector {
    private final DexValue value;
    private final DexType type;

    public ValueInspectorImpl(DexValue value, DexType type) {
        this.value = value;
        this.type = type;
    }

    private static void guard(boolean precondition) {
        if (!precondition) {
            throw new IllegalStateException("Invalid call on ValueInspector");
        }
    }

    @Override
    public TypeReference getTypeReference() {
        return Reference.typeFromDescriptor(this.type.toDescriptorString());
    }

    @Override
    public boolean isPrimitive() {
        return this.type.isPrimitiveType();
    }

    @Override
    public boolean isBooleanValue() {
        return this.type.isBooleanType();
    }

    @Override
    public BooleanValueInspector asBooleanValue() {
        return this.isBooleanValue() ? this : null;
    }

    @Override
    public boolean getBooleanValue() {
        ValueInspectorImpl.guard(this.isBooleanValue());
        return this.value.asDexValueBoolean().getValue();
    }

    @Override
    public boolean isByteValue() {
        return this.type.isByteType();
    }

    @Override
    public ByteValueInspector asByteValue() {
        return this.isByteValue() ? this : null;
    }

    @Override
    public byte getByteValue() {
        ValueInspectorImpl.guard(this.isByteValue());
        return this.value.asDexValueByte().getValue();
    }

    @Override
    public boolean isCharValue() {
        return this.type.isCharType();
    }

    @Override
    public CharValueInspector asCharValue() {
        return this.isCharValue() ? this : null;
    }

    @Override
    public char getCharValue() {
        ValueInspectorImpl.guard(this.isCharValue());
        return this.value.asDexValueChar().getValue();
    }

    @Override
    public boolean isShortValue() {
        return this.type.isShortType();
    }

    @Override
    public ShortValueInspector asShortValue() {
        return this.isShortValue() ? this : null;
    }

    @Override
    public short getShortValue() {
        ValueInspectorImpl.guard(this.isShortValue());
        return this.value.asDexValueShort().getValue();
    }

    @Override
    public boolean isIntValue() {
        return this.type.isIntType();
    }

    @Override
    public IntValueInspector asIntValue() {
        return this.isIntValue() ? this : null;
    }

    @Override
    public int getIntValue() {
        ValueInspectorImpl.guard(this.isIntValue());
        return this.value.asDexValueInt().value;
    }

    @Override
    public boolean isLongValue() {
        return this.type.isLongType();
    }

    @Override
    public LongValueInspector asLongValue() {
        return this.isLongValue() ? this : null;
    }

    @Override
    public long getLongValue() {
        ValueInspectorImpl.guard(this.isLongValue());
        return this.value.asDexValueLong().getValue();
    }

    @Override
    public boolean isFloatValue() {
        return this.type.isFloatType();
    }

    @Override
    public FloatValueInspector asFloatValue() {
        return this.isFloatValue() ? this : null;
    }

    @Override
    public float getFloatValue() {
        ValueInspectorImpl.guard(this.isFloatValue());
        return this.value.asDexValueFloat().getValue();
    }

    @Override
    public boolean isDoubleValue() {
        return this.type.isDoubleType();
    }

    @Override
    public DoubleValueInspector asDoubleValue() {
        return this.isDoubleValue() ? this : null;
    }

    @Override
    public double getDoubleValue() {
        ValueInspectorImpl.guard(this.isDoubleValue());
        return this.value.asDexValueDouble().getValue();
    }

    @Override
    public boolean isStringValue() {
        return this.type.isClassType() && this.value.isDexValueString();
    }

    @Override
    public StringValueInspector asStringValue() {
        return this.isStringValue() ? this : null;
    }

    @Override
    public String getStringValue() {
        ValueInspectorImpl.guard(this.isStringValue());
        return ((DexString)this.value.asDexValueString().getValue()).toString();
    }
}

