/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeSuper;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClassInitializationAnalysis {
    private static final ClassInitializationAnalysis TRIVIAL = new ClassInitializationAnalysis(){

        @Override
        public boolean isClassDefinitelyLoadedBeforeInstruction(DexType type, Instruction instruction) {
            return false;
        }
    };
    private final AppView<AppInfoWithLiveness> appView;
    private final IRCode code;
    private DominatorTree dominatorTree = null;
    private int markingColor = -1;

    private ClassInitializationAnalysis() {
        this.appView = null;
        this.code = null;
    }

    public ClassInitializationAnalysis(AppView<AppInfoWithLiveness> appView, IRCode code) {
        this.appView = appView;
        this.code = code;
    }

    public static ClassInitializationAnalysis trivial() {
        return TRIVIAL;
    }

    private AnalysisAssumption getAssumptionForDominator(BasicBlock dominator, BasicBlock block) {
        if (!dominator.hasCatchHandlers()) {
            return AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW;
        }
        Instruction exceptionalExit = dominator.exceptionalExit();
        if (exceptionalExit == null) {
            return AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW;
        }
        if (this.markingColor < 0) {
            this.markingColor = this.code.reserveMarkingColor();
            this.code.markTransitivePredecessors(block, this.markingColor);
        }
        for (CatchHandlers.CatchHandler<BasicBlock> catchHandler : dominator.getCatchHandlers()) {
            if (!((BasicBlock)catchHandler.target).isMarked(this.markingColor)) continue;
            return AnalysisAssumption.NONE;
        }
        return AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW;
    }

    private void returnMarkingColor() {
        if (this.markingColor >= 0) {
            this.code.returnMarkingColor(this.markingColor);
            this.markingColor = -1;
        }
    }

    public boolean isClassDefinitelyLoadedBeforeInstruction(DexType type, Instruction instruction) {
        Instruction previous;
        ProgramMethod context = this.code.context();
        BasicBlock block = instruction.getBlock();
        Iterator<Object> iterator2 = block.getInstructions().iterator();
        while (iterator2.hasNext() && (previous = (Instruction)iterator2.next()) != instruction) {
            if (!previous.definitelyTriggersClassInitialization(type, context, this.appView, Query.DIRECTLY_OR_INDIRECTLY, AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW)) continue;
            return true;
        }
        if (this.dominatorTree == null) {
            this.dominatorTree = new DominatorTree(this.code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        }
        block1: for (BasicBlock dominator : this.dominatorTree.dominatorBlocks(block, DominatorTree.Inclusive.NO)) {
            AnalysisAssumption assumption = this.getAssumptionForDominator(dominator, block);
            InstructionIterator instructionIterator = dominator.iterator();
            while (instructionIterator.hasNext()) {
                Instruction previous2 = (Instruction)instructionIterator.next();
                if (previous2.definitelyTriggersClassInitialization(type, context, this.appView, Query.DIRECTLY_OR_INDIRECTLY, assumption)) {
                    return true;
                }
                if (!dominator.hasCatchHandlers() || !previous2.instructionTypeCanThrow()) continue;
                assert (Streams.stream(instructionIterator).noneMatch(Instruction::instructionTypeCanThrow));
                continue block1;
            }
        }
        return false;
    }

    public void notifyCodeHasChanged() {
        this.dominatorTree = null;
        this.returnMarkingColor();
    }

    public void finish() {
        this.returnMarkingColor();
    }

    public static class InstructionUtils {
        public static boolean forInitClass(InitClass instruction, DexType type, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            if (assumption == AnalysisAssumption.NONE) {
                return false;
            }
            DexClass clazz = appView.definitionFor(instruction.getClassValue());
            return clazz != null && InstructionUtils.isTypeInitializedBy(instruction, type, clazz, appView, mode);
        }

        public static boolean forInstanceGet(InstanceGet instruction, DexType type, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forInstanceGetOrPut(instruction, type, appView, mode, assumption);
        }

        public static boolean forInstancePut(InstancePut instruction, DexType type, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forInstanceGetOrPut(instruction, type, appView, mode, assumption);
        }

        private static boolean forInstanceGetOrPut(FieldInstruction instruction, DexType type, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            DexEncodedField field;
            assert (instruction.isInstanceGet() || instruction.isInstancePut());
            if (assumption == AnalysisAssumption.NONE) {
                Value object;
                Value value = object = instruction.isInstanceGet() ? instruction.asInstanceGet().object() : instruction.asInstancePut().object();
                if (object.getType().isNullable()) {
                    return false;
                }
            }
            return (field = appView.appInfo().resolveField(instruction.getField()).getResolvedField()) != null && InstructionUtils.isTypeInitializedBy(instruction, type, field, appView, mode);
        }

        public static boolean forInvokeDirect(InvokeDirect instruction, DexType type, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            DexClass holder;
            if (assumption == AnalysisAssumption.NONE && instruction.getReceiver().getType().isNullable()) {
                return false;
            }
            DexMethod invokedMethod = instruction.getInvokedMethod();
            DexEncodedMethod method = invokedMethod.lookupOnClass(holder = appView.definitionForHolder(invokedMethod));
            return method != null && InstructionUtils.isTypeInitializedBy(instruction, type, method, appView, mode);
        }

        public static boolean forInvokeInterface(InvokeInterface instruction, DexType type, ProgramMethod context, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            DexClassAndMethod singleTarget;
            if (assumption == AnalysisAssumption.NONE && instruction.getReceiver().getType().isNullable()) {
                return false;
            }
            if (mode == Query.DIRECTLY) {
                return false;
            }
            if (appView.appInfo().hasLiveness() && (singleTarget = instruction.lookupSingleTarget(appView.withLiveness(), context)) != null) {
                return InstructionUtils.isTypeInitializedBy(instruction, type, singleTarget.getDefinition(), appView, mode);
            }
            DexMethod method = instruction.getInvokedMethod();
            MethodResolutionResult resolutionResult = appView.appInfo().resolveMethodOnInterface(method.holder, method);
            if (!resolutionResult.isSingleResolution()) {
                return false;
            }
            DexType holder = resolutionResult.getSingleTarget().getHolderType();
            return appView.isSubtype(holder, type).isTrue();
        }

        public static boolean forInvokeStatic(InvokeStatic instruction, DexType type, ProgramMethod context, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            if (assumption == AnalysisAssumption.NONE) {
                return false;
            }
            DexClassAndMethod method = instruction.lookupSingleTarget(appView, context);
            return method != null && InstructionUtils.isTypeInitializedBy(instruction, type, method.getDefinition(), appView, mode);
        }

        public static boolean forInvokeSuper(InvokeSuper instruction, DexType type, ProgramMethod context, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            DexClassAndMethod singleTarget;
            if (assumption == AnalysisAssumption.NONE && instruction.getReceiver().getType().isNullable()) {
                return false;
            }
            if (mode == Query.DIRECTLY) {
                return false;
            }
            if (appView.appInfo().hasLiveness() && (singleTarget = instruction.lookupSingleTarget(appView.withLiveness(), context)) != null) {
                return InstructionUtils.isTypeInitializedBy(instruction, type, singleTarget.getDefinition(), appView, mode);
            }
            DexMethod method = instruction.getInvokedMethod();
            DexClass enclosingClass = appView.definitionFor(method.holder);
            if (enclosingClass == null) {
                return false;
            }
            DexType superType = enclosingClass.superType;
            if (superType == null) {
                return false;
            }
            MethodResolutionResult resolutionResult = appView.appInfo().resolveMethodOn(superType, method, instruction.isInterface);
            if (!resolutionResult.isSingleResolution()) {
                return false;
            }
            DexType holder = resolutionResult.getSingleTarget().getHolderType();
            return appView.isSubtype(holder, type).isTrue();
        }

        public static boolean forInvokeVirtual(InvokeVirtual instruction, DexType type, ProgramMethod context, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            DexClassAndMethod singleTarget;
            if (assumption == AnalysisAssumption.NONE && instruction.getReceiver().getType().isNullable()) {
                return false;
            }
            if (mode == Query.DIRECTLY) {
                return false;
            }
            if (appView.appInfo().hasLiveness() && (singleTarget = instruction.lookupSingleTarget(appView.withLiveness(), context)) != null) {
                return InstructionUtils.isTypeInitializedBy(instruction, type, singleTarget.getDefinition(), appView, mode);
            }
            DexMethod method = instruction.getInvokedMethod();
            MethodResolutionResult resolutionResult = appView.appInfo().resolveMethodOnClass(method, method.holder);
            if (!resolutionResult.isSingleResolution()) {
                return false;
            }
            DexType holder = resolutionResult.getSingleTarget().getHolderType();
            return appView.isSubtype(holder, type).isTrue();
        }

        public static boolean forNewInstance(NewInstance instruction, DexType type, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            if (assumption == AnalysisAssumption.NONE) {
                return false;
            }
            DexClass clazz = appView.definitionFor(instruction.clazz);
            return clazz != null && InstructionUtils.isTypeInitializedBy(instruction, type, clazz, appView, mode);
        }

        public static boolean forStaticGet(StaticGet instruction, DexType type, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forStaticGetOrPut(instruction, type, appView, mode, assumption);
        }

        public static boolean forStaticPut(StaticPut instruction, DexType type, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            return InstructionUtils.forStaticGetOrPut(instruction, type, appView, mode, assumption);
        }

        private static boolean forStaticGetOrPut(FieldInstruction instruction, DexType type, AppView<AppInfoWithLiveness> appView, Query mode, AnalysisAssumption assumption) {
            assert (instruction.isStaticGet() || instruction.isStaticPut());
            if (assumption == AnalysisAssumption.NONE) {
                return false;
            }
            DexEncodedField field = appView.appInfo().resolveField(instruction.getField()).getResolvedField();
            return field != null && InstructionUtils.isTypeInitializedBy(instruction, type, field, appView, mode);
        }

        private static boolean isTypeInitializedBy(Instruction instruction, DexType typeToBeInitialized, DexDefinition definition, AppView<AppInfoWithLiveness> appView, Query mode) {
            if (mode == Query.DIRECTLY) {
                if (definition.isDexClass()) {
                    return definition.asDexClass().type == typeToBeInitialized;
                }
                if (definition.isDexEncodedMember()) {
                    return ((DexMember)definition.asDexEncodedMember().getReference()).holder == typeToBeInitialized;
                }
                throw new Unreachable();
            }
            Set<DexType> visited = Sets.newIdentityHashSet();
            ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
            if (definition.isDexClass()) {
                DexClass clazz = definition.asDexClass();
                InstructionUtils.enqueue(clazz.type, visited, worklist);
            } else if (definition.isDexEncodedField()) {
                DexEncodedField field = definition.asDexEncodedField();
                InstructionUtils.enqueue(field.getHolderType(), visited, worklist);
            } else if (definition.isDexEncodedMethod()) {
                assert (instruction.isInvokeMethod());
                DexEncodedMethod method = definition.asDexEncodedMethod();
                InstructionUtils.enqueue(method.getHolderType(), visited, worklist);
                InstructionUtils.enqueueInitializedClassesOnNormalExit(method, instruction.inValues(), visited, worklist);
            } else assert (false);
            while (!worklist.isEmpty()) {
                DexEncodedMethod classInitializer;
                DexType typeKnownToBeInitialized = (DexType)worklist.removeFirst();
                assert (visited.contains(typeKnownToBeInitialized));
                if (appView.isSubtype(typeKnownToBeInitialized, typeToBeInitialized).isTrue()) {
                    return true;
                }
                DexClass clazz = appView.definitionFor(typeKnownToBeInitialized);
                if (clazz == null || (classInitializer = clazz.getClassInitializer()) == null) continue;
                InstructionUtils.enqueueInitializedClassesOnNormalExit(classInitializer, ImmutableList.of(), visited, worklist);
            }
            return false;
        }

        private static void enqueue(DexType type, Set<DexType> visited, Deque<DexType> worklist) {
            if (type.isClassType() && visited.add(type)) {
                worklist.add(type);
            }
        }

        private static void enqueueInitializedClassesOnNormalExit(DexEncodedMethod method, List<Value> arguments, Set<DexType> visited, Deque<DexType> worklist) {
            BitSet nonNullParamOrThrowFacts;
            for (DexType type : method.getOptimizationInfo().getInitializedClassesOnNormalExit()) {
                InstructionUtils.enqueue(type, visited, worklist);
            }
            if (!method.isStatic()) {
                assert (arguments.size() > 0);
                TypeElement type = arguments.get(0).getType();
                if (type.isClassType()) {
                    InstructionUtils.enqueue(type.asClassType().getClassType(), visited, worklist);
                }
            }
            if ((nonNullParamOrThrowFacts = method.getOptimizationInfo().getNonNullParamOrThrow()) != null) {
                for (int i = 0; i < arguments.size(); ++i) {
                    TypeElement type;
                    if (!nonNullParamOrThrowFacts.get(i) || !(type = arguments.get(i).getType()).isClassType()) continue;
                    InstructionUtils.enqueue(type.asClassType().getClassType(), visited, worklist);
                }
            }
        }
    }

    public static enum Query {
        DIRECTLY,
        DIRECTLY_OR_INDIRECTLY;

    }

    public static enum AnalysisAssumption {
        INSTRUCTION_DOES_NOT_THROW,
        NONE;

    }
}

