/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class DeterminismAnalysis {
    public static boolean returnValueOnlyDependsOnArguments(AppView<AppInfoWithLiveness> appView, IRCode code) {
        for (Instruction instr : code.instructions()) {
            if (instr.outValue() == null || !instr.outValue().isUsed()) continue;
            if (instr.isStaticGet()) {
                return false;
            }
            if (instr.isInstanceGet()) {
                return false;
            }
            if (instr.isArrayGet() || instr.isArrayLength()) {
                return false;
            }
            if (instr.isInvokeMethod()) {
                DexClassAndMethod target = instr.asInvokeMethod().lookupSingleTarget(appView, code.context());
                if (target != null && ((DexEncodedMethod)target.getDefinition()).getOptimizationInfo().returnValueOnlyDependsOnArguments()) continue;
                return false;
            }
            if (instr.isInvokeCustom() || instr.isInvokePolymorphic()) {
                return false;
            }
            if (instr.isCreatingInstanceOrArray()) {
                return false;
            }
            if (instr.isMoveException()) {
                return false;
            }
            assert (instr.isArgument() || instr.isAssume() || instr.isBinop() || instr.isInitClass() || instr.isUnop() || instr.isMonitor() || instr.isMove() || instr.isCheckCast() || instr.isInstanceOf() || instr.isConstInstruction() || instr.isJumpInstruction() || instr.isDebugInstruction()) : "Instruction that impacts determinism: " + instr;
        }
        return true;
    }
}

