/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.analysis.VerifyTypesHelper;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Throw;

public class TypeChecker {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final VerifyTypesHelper verifyTypesHelper;

    public TypeChecker(AppView<? extends AppInfoWithClassHierarchy> appView, VerifyTypesHelper verifyTypesHelper) {
        this.appView = appView;
        this.verifyTypesHelper = verifyTypesHelper;
    }

    public boolean check(IRCode code) {
        for (Instruction instruction : code.instructions()) {
            if (!(instruction.isInstancePut() ? !this.check(instruction.asInstancePut()) : (instruction.isReturn() ? !this.check(instruction.asReturn(), code.method()) : (instruction.isStaticPut() ? !this.check(instruction.asStaticPut()) : instruction.isThrow() && !this.check(instruction.asThrow()))))) continue;
            return false;
        }
        return true;
    }

    public boolean check(InstancePut instruction) {
        return this.checkFieldPut(instruction);
    }

    public boolean check(Return instruction, DexEncodedMethod method) {
        TypeElement returnType;
        if (instruction.isReturnVoid()) {
            return true;
        }
        TypeElement valueType = instruction.returnValue().getType();
        if (this.verifyTypesHelper.isAssignable(valueType, returnType = TypeElement.fromDexType(((DexMethod)method.getReference()).proto.returnType, Nullability.maybeNull(), this.appView))) {
            return true;
        }
        if (returnType.isClassType() && valueType.isReferenceType()) {
            DexClass clazz = this.appView.definitionFor(((DexMethod)method.getReference()).proto.returnType);
            return clazz != null && clazz.isInterface();
        }
        return false;
    }

    public boolean check(StaticPut instruction) {
        return this.checkFieldPut(instruction);
    }

    public boolean checkFieldPut(FieldInstruction instruction) {
        TypeElement fieldType;
        assert (instruction.isFieldPut());
        TypeElement valueType = instruction.value().getType();
        if (this.verifyTypesHelper.isAssignable(valueType, fieldType = TypeElement.fromDexType(instruction.getField().type, valueType.nullability(), this.appView))) {
            return true;
        }
        if (fieldType.isClassType() && valueType.isReferenceType()) {
            DexClass clazz = this.appView.definitionFor(instruction.getField().type);
            return clazz != null && clazz.isInterface();
        }
        return false;
    }

    public boolean check(Throw instruction) {
        TypeElement valueType = instruction.exception().getType();
        TypeElement throwableType = TypeElement.fromDexType(this.appView.dexItemFactory().throwableType, valueType.nullability(), this.appView);
        return this.verifyTypesHelper.isAssignable(valueType, throwableType);
    }
}

