/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.fieldaccess;

import com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.bytecodemetadata.BytecodeMetadataProvider;
import com.android.tools.r8.ir.analysis.fieldaccess.FieldAssignmentTracker;
import com.android.tools.r8.ir.analysis.fieldaccess.FieldBitAccessAnalysis;
import com.android.tools.r8.ir.analysis.fieldaccess.FieldReadForInvokeReceiverAnalysis;
import com.android.tools.r8.ir.analysis.fieldaccess.FieldReadForWriteAnalysis;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.ClassInitializerDefaultsOptimization;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;

public class FieldAccessAnalysis {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final FieldAssignmentTracker fieldAssignmentTracker;
    private final FieldBitAccessAnalysis fieldBitAccessAnalysis;
    private final FieldReadForInvokeReceiverAnalysis fieldReadForInvokeReceiverAnalysis;
    private final FieldReadForWriteAnalysis fieldReadForWriteAnalysis;

    public FieldAccessAnalysis(AppView<AppInfoWithLiveness> appView) {
        InternalOptions options = appView.options();
        this.appView = appView;
        this.fieldBitAccessAnalysis = options.enableFieldBitAccessAnalysis ? new FieldBitAccessAnalysis() : null;
        this.fieldAssignmentTracker = new FieldAssignmentTracker(appView);
        this.fieldReadForInvokeReceiverAnalysis = new FieldReadForInvokeReceiverAnalysis(appView);
        this.fieldReadForWriteAnalysis = new FieldReadForWriteAnalysis(appView);
    }

    @VisibleForTesting
    public FieldAccessAnalysis(AppView<? extends AppInfoWithClassHierarchy> appView, FieldAssignmentTracker fieldAssignmentTracker, FieldBitAccessAnalysis fieldBitAccessAnalysis, FieldReadForInvokeReceiverAnalysis fieldReadForInvokeReceiverAnalysis, FieldReadForWriteAnalysis fieldReadForWriteAnalysis) {
        this.appView = appView;
        this.fieldAssignmentTracker = fieldAssignmentTracker;
        this.fieldBitAccessAnalysis = fieldBitAccessAnalysis;
        this.fieldReadForInvokeReceiverAnalysis = fieldReadForInvokeReceiverAnalysis;
        this.fieldReadForWriteAnalysis = fieldReadForWriteAnalysis;
    }

    public FieldAssignmentTracker fieldAssignmentTracker() {
        return this.fieldAssignmentTracker;
    }

    public void acceptClassInitializerDefaultsResult(ClassInitializerDefaultsOptimization.ClassInitializerDefaultsResult classInitializerDefaultsResult) {
        if (this.fieldAssignmentTracker != null) {
            this.fieldAssignmentTracker.acceptClassInitializerDefaultsResult(classInitializerDefaultsResult);
        }
    }

    public void recordFieldAccesses(IRCode code, BytecodeMetadataProvider.Builder bytecodeMetadataProviderBuilder, OptimizationFeedback feedback, MethodProcessor methodProcessor) {
        if (!methodProcessor.isPrimaryMethodProcessor()) {
            return;
        }
        if (!code.metadata().mayHaveFieldInstruction() && !code.metadata().mayHaveNewInstance()) {
            return;
        }
        for (Instruction instruction : code.instructions()) {
            if (instruction.isFieldInstruction()) {
                FieldInstruction fieldInstruction = instruction.asFieldInstruction();
                ProgramField field = this.appView.appInfo().resolveField(fieldInstruction.getField()).getProgramField();
                if (field == null) continue;
                if (this.fieldAssignmentTracker != null) {
                    this.fieldAssignmentTracker.recordFieldAccess(fieldInstruction, field, code.context());
                }
                if (this.fieldBitAccessAnalysis != null) {
                    this.fieldBitAccessAnalysis.recordFieldAccess(fieldInstruction, (DexEncodedField)field.getDefinition(), feedback);
                }
                if (this.fieldReadForInvokeReceiverAnalysis != null) {
                    this.fieldReadForInvokeReceiverAnalysis.recordFieldAccess(fieldInstruction, field, bytecodeMetadataProviderBuilder, code.context());
                }
                if (this.fieldReadForWriteAnalysis == null) continue;
                this.fieldReadForWriteAnalysis.recordFieldAccess(fieldInstruction, field, bytecodeMetadataProviderBuilder);
                continue;
            }
            if (!instruction.isNewInstance()) continue;
            NewInstance newInstance = instruction.asNewInstance();
            DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(newInstance.clazz));
            if (clazz == null || this.fieldAssignmentTracker == null) continue;
            this.fieldAssignmentTracker.recordAllocationSite(newInstance, clazz, code.context());
        }
    }
}

