/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.fieldaccess;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.bytecodemetadata.BytecodeInstructionMetadata;
import com.android.tools.r8.graph.bytecodemetadata.BytecodeMetadataProvider;
import com.android.tools.r8.ir.code.FieldGet;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.FieldPut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.WorkList;

public class FieldReadForWriteAnalysis {
    private final AppView<AppInfoWithLiveness> appView;

    FieldReadForWriteAnalysis(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    private boolean isValueOnlyUsedToWriteField(Value value, ProgramField field) {
        WorkList<Instruction> users = WorkList.newIdentityWorkList(value.uniqueUsers());
        if (!this.enqueueUsersForAnalysis(value, users)) {
            return false;
        }
        boolean foundWrite = false;
        while (users.hasNext()) {
            ProgramField writtenField;
            FieldPut fieldPut;
            DexField writtenFieldReference;
            Instruction user = users.next();
            if (user.isArithmeticBinop() || user.isLogicalBinop() || user.isUnop()) {
                if (this.enqueueUsersForAnalysis(user.outValue(), users)) {
                    continue;
                }
            } else if (user.isFieldPut() && (writtenFieldReference = (fieldPut = user.asFieldPut()).getField()).match((DexField)field.getReference()) && fieldPut.isStaticPut() == field.getAccessFlags().isStatic() && (writtenField = this.appView.appInfo().resolveField(writtenFieldReference).getSingleProgramField()) != null && writtenField.isStructurallyEqualTo(field)) {
                foundWrite = true;
                continue;
            }
            return false;
        }
        return foundWrite;
    }

    private boolean enqueueUsersForAnalysis(Value value, WorkList<Instruction> users) {
        if (value.hasDebugUsers() || value.hasPhiUsers()) {
            return false;
        }
        users.addIfNotSeen(value.uniqueUsers());
        return true;
    }

    public void recordFieldAccess(FieldInstruction instruction, ProgramField field, BytecodeMetadataProvider.Builder bytecodeMetadataProviderBuilder) {
        if (instruction.isFieldPut()) {
            return;
        }
        FieldGet fieldGet = instruction.asFieldGet();
        if (this.isValueOnlyUsedToWriteField(fieldGet.outValue(), field)) {
            bytecodeMetadataProviderBuilder.addMetadata(instruction, BytecodeInstructionMetadata.Builder::setIsReadForWrite);
        }
    }
}

