/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.fieldaccess;

import com.android.tools.r8.code.CfOrDexInstanceFieldRead;
import com.android.tools.r8.code.CfOrDexStaticFieldRead;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AbstractAccessContexts;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessInfo;
import com.android.tools.r8.graph.FieldAccessInfoCollection;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.graph.bytecodemetadata.BytecodeInstructionMetadata;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleFieldValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.conversion.PostMethodProcessor;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackDelayed;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class TrivialFieldAccessReprocessor {
    private final AppView<AppInfoWithLiveness> appView;
    private final PostMethodProcessor.Builder postMethodProcessorBuilder;
    private final Map<DexEncodedField, ProgramMethodSet> dependencies = new ConcurrentHashMap<DexEncodedField, ProgramMethodSet>();
    private final Map<DexEncodedField, AbstractAccessContexts> readFields = new ConcurrentHashMap<DexEncodedField, AbstractAccessContexts>();
    private final Map<DexEncodedField, AbstractAccessContexts> writtenFields = new ConcurrentHashMap<DexEncodedField, AbstractAccessContexts>();
    private final Set<DexEncodedField> constantFields = Sets.newConcurrentHashSet();
    private final Set<DexEncodedField> nonConstantFields = Sets.newConcurrentHashSet();
    private final ProgramMethodSet methodsToReprocess = ProgramMethodSet.createConcurrent();

    public TrivialFieldAccessReprocessor(AppView<AppInfoWithLiveness> appView, PostMethodProcessor.Builder postMethodProcessorBuilder) {
        this.appView = appView;
        this.postMethodProcessorBuilder = postMethodProcessorBuilder;
    }

    private void markWriteOnlyFieldAsDead(DexEncodedField field) {
        this.markFieldAsDead(field);
        OptimizationFeedback.getSimpleFeedback().recordFieldHasAbstractValue(field, this.appView, this.appView.abstractValueFactory().createNullValue());
    }

    private void markFieldAsDead(DexEncodedField field) {
        if (this.appView.appInfo().isPinned(field)) {
            assert (field.getType().isAlwaysNull(this.appView));
        } else {
            OptimizationFeedback.getSimpleFeedback().markFieldAsDead(field);
        }
    }

    private void computeFieldsWithNonTrivialValue() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            FieldClassification fieldClassification;
            block5: for (DexEncodedField field : clazz.instanceFields()) {
                fieldClassification = TrivialFieldAccessReprocessor.classifyField(field, this.appView);
                switch (fieldClassification) {
                    case CONSTANT: {
                        this.constantFields.add(field);
                        continue block5;
                    }
                    case NON_CONSTANT: {
                        this.nonConstantFields.add(field);
                        continue block5;
                    }
                }
                assert (fieldClassification == FieldClassification.UNKNOWN);
            }
            if (!this.appView.canUseInitClass() && clazz.classInitializationMayHaveSideEffects(this.appView)) continue;
            for (DexEncodedField field : clazz.staticFields()) {
                fieldClassification = TrivialFieldAccessReprocessor.classifyField(field, this.appView);
                if (fieldClassification == FieldClassification.CONSTANT) {
                    this.constantFields.add(field);
                    continue;
                }
                assert (fieldClassification == FieldClassification.NON_CONSTANT || fieldClassification == FieldClassification.UNKNOWN);
            }
        }
        assert (TrivialFieldAccessReprocessor.verifyNoConstantFieldsOnSynthesizedClasses(this.appView));
    }

    private void clearReadsAndWritesFromFieldsOfInterest(AppInfoWithLiveness appInfo) {
        FieldAccessInfoCollection<? extends FieldAccessInfo> fieldAccessInfoCollection = appInfo.getFieldAccessInfoCollection();
        for (DexEncodedField field : this.constantFields) {
            fieldAccessInfoCollection.get((DexField)field.getReference()).asMutable().clearReads();
        }
        for (DexEncodedField field : this.readFields.keySet()) {
            fieldAccessInfoCollection.get((DexField)field.getReference()).asMutable().clearWrites();
        }
        for (DexEncodedField field : this.writtenFields.keySet()) {
            fieldAccessInfoCollection.get((DexField)field.getReference()).asMutable().clearReads();
        }
    }

    private void enqueueMethodsForReprocessing(AppInfoWithLiveness appInfo, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(appInfo.classes(), this::processClass, executorService);
        ThreadUtils.processItems(appInfo.getSyntheticItems().getPendingSyntheticClasses(), this::processClass, executorService);
        this.processFieldsNeverRead(appInfo);
        this.processFieldsNeverWritten(appInfo);
        this.postMethodProcessorBuilder.rewrittenWithLens(this.appView.graphLens()).put(this.methodsToReprocess);
    }

    private void processClass(DexProgramClass clazz) {
        clazz.forEachProgramMethodMatching(DexEncodedMethod::hasCode, method -> method.registerCodeReferences(new TrivialFieldAccessUseRegistry((ProgramMethod)method)));
    }

    private static FieldClassification classifyField(DexEncodedField field, AppView<AppInfoWithLiveness> appView) {
        FieldAccessInfo fieldAccessInfo = appView.appInfo().getFieldAccessInfoCollection().get((DexField)field.getReference());
        if (fieldAccessInfo == null || fieldAccessInfo.hasReflectiveAccess() || fieldAccessInfo.isAccessedFromMethodHandle() || fieldAccessInfo.isReadFromAnnotation()) {
            return FieldClassification.UNKNOWN;
        }
        AbstractValue abstractValue = field.getOptimizationInfo().getAbstractValue();
        if (abstractValue.isSingleValue()) {
            SingleFieldValue singleFieldValue;
            DexField singleField;
            SingleValue singleValue = abstractValue.asSingleValue();
            if (!singleValue.isMaterializableInAllContexts(appView)) {
                return FieldClassification.UNKNOWN;
            }
            if (singleValue.isSingleConstValue()) {
                return FieldClassification.CONSTANT;
            }
            if (singleValue.isSingleFieldValue() && (singleField = (singleFieldValue = singleValue.asSingleFieldValue()).getField()) != field.getReference() && !singleFieldValue.mayHaveFinalizeMethodDirectlyOrIndirectly(appView)) {
                return FieldClassification.CONSTANT;
            }
            return FieldClassification.UNKNOWN;
        }
        if (abstractValue.isNonConstantNumberValue()) {
            return FieldClassification.NON_CONSTANT;
        }
        return FieldClassification.UNKNOWN;
    }

    private void processFieldsNeverRead(AppInfoWithLiveness appInfo) {
        FieldAccessInfoCollection<? extends FieldAccessInfo> fieldAccessInfoCollection = appInfo.getFieldAccessInfoCollection();
        this.writtenFields.entrySet().removeIf(entry -> !((AbstractAccessContexts)entry.getValue()).isConcrete() || !this.canOptimizeOnlyReadOrWrittenField((DexEncodedField)entry.getKey(), true, fieldAccessInfoCollection));
        this.writtenFields.forEach((field, contexts) -> {
            assert (!this.readFields.containsKey(field));
            fieldAccessInfoCollection.get((DexField)field.getReference()).asMutable().clearReads();
            this.methodsToReprocess.addAll(contexts.asConcrete().getAccessesWithContexts().values().iterator().next());
            this.methodsToReprocess.addAll(this.dependencies.getOrDefault(field, ProgramMethodSet.empty()));
        });
    }

    private void processFieldsNeverWritten(AppInfoWithLiveness appInfo) {
        FieldAccessInfoCollection<? extends FieldAccessInfo> fieldAccessInfoCollection = appInfo.getFieldAccessInfoCollection();
        this.readFields.entrySet().removeIf(entry -> !((AbstractAccessContexts)entry.getValue()).isConcrete() || !this.canOptimizeOnlyReadOrWrittenField((DexEncodedField)entry.getKey(), false, fieldAccessInfoCollection));
        this.readFields.forEach((field, contexts) -> {
            assert (!this.writtenFields.containsKey(field));
            this.methodsToReprocess.addAll(contexts.asConcrete().getAccessesWithContexts().values().iterator().next());
            this.methodsToReprocess.addAll(this.dependencies.getOrDefault(field, ProgramMethodSet.empty()));
        });
    }

    private boolean canOptimizeOnlyReadOrWrittenField(DexEncodedField field, boolean isWrite, FieldAccessInfoCollection<?> fieldAccessInfoCollection) {
        ReferenceTypeElement fieldType;
        ClassTypeElement classType;
        assert (!this.appView.appInfo().isPinned(field) || field.getType().isAlwaysNull(this.appView));
        Object fieldAccessInfo = fieldAccessInfoCollection.get((DexField)field.getReference());
        if (fieldAccessInfo == null) {
            assert (false) : "Expected program field with concrete accesses to be present in field access collection";
            return false;
        }
        if (fieldAccessInfo.hasReflectiveAccess() || fieldAccessInfo.isAccessedFromMethodHandle() || fieldAccessInfo.isReadFromRecordInvokeDynamic() || fieldAccessInfo.isReadFromAnnotation()) {
            return false;
        }
        return !isWrite || !field.getType().isReferenceType() || (classType = ((fieldType = field.getTypeElement(this.appView).asReferenceType()).isArrayType() ? fieldType.asArrayType().getBaseType() : fieldType).asClassType()) == null || !this.appView.appInfo().mayHaveFinalizeMethodDirectlyOrIndirectly(classType);
    }

    private static boolean verifyNoConstantFieldsOnSynthesizedClasses(AppView<AppInfoWithLiveness> appView) {
        for (DexProgramClass clazz : appView.appInfo().getSyntheticItems().getPendingSyntheticClasses()) {
            for (DexEncodedField field : clazz.fields()) {
                assert (field.getOptimizationInfo().getAbstractValue().isUnknown());
            }
        }
        return true;
    }

    public void run(ExecutorService executorService, OptimizationFeedbackDelayed feedback, Timing timing) throws ExecutionException {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        timing.begin("Trivial field accesses analysis");
        assert (feedback.noUpdatesLeft());
        timing.begin("Compute fields of interest");
        this.computeFieldsWithNonTrivialValue();
        timing.end();
        timing.begin("Enqueue methods for reprocessing");
        this.enqueueMethodsForReprocessing(appInfo, executorService);
        timing.end();
        timing.begin("Clear reads and writes from fields of interest");
        this.clearReadsAndWritesFromFieldsOfInterest(appInfo);
        timing.end();
        timing.end();
        this.constantFields.forEach(this::markFieldAsDead);
        this.readFields.keySet().forEach(this::markFieldAsDead);
        this.writtenFields.keySet().forEach(this::markWriteOnlyFieldAsDead);
    }

    class TrivialFieldAccessUseRegistry
    extends UseRegistry<ProgramMethod> {
        TrivialFieldAccessUseRegistry(ProgramMethod method) {
            super(TrivialFieldAccessReprocessor.this.appView, method);
        }

        private void registerFieldAccess(DexField reference, boolean isStatic, boolean isWrite, BytecodeInstructionMetadata metadata) {
            FieldResolutionResult resolutionResult = ((AppInfoWithLiveness)TrivialFieldAccessReprocessor.this.appView.appInfo()).resolveField(reference);
            if (!resolutionResult.hasProgramResult()) {
                return;
            }
            ProgramField field = resolutionResult.getProgramField();
            DexEncodedField definition = (DexEncodedField)field.getDefinition();
            if (definition.isStatic() != isStatic || TrivialFieldAccessReprocessor.this.appView.isCfByteCodePassThrough((DexEncodedMethod)((ProgramMethod)this.getContext()).getDefinition()) || resolutionResult.isAccessibleFrom((ProgramDefinition)this.getContext(), TrivialFieldAccessReprocessor.this.appView).isPossiblyFalse() || !resolutionResult.isSingleProgramFieldResolutionResult()) {
                this.recordAccessThatCannotBeOptimized(field, definition);
                return;
            }
            if (metadata != null) {
                if (this.isUnusedReadAfterMethodStaticizing(field, metadata)) {
                    TrivialFieldAccessReprocessor.this.dependencies.computeIfAbsent((DexEncodedField)field.getDefinition(), MapUtils.ignoreKey(ProgramMethodSet::createConcurrent)).add((ProgramMethod)this.getContext());
                    return;
                }
                if (metadata.isReadForWrite()) {
                    return;
                }
            }
            if (field.isProgramField() && ((AppInfoWithLiveness)TrivialFieldAccessReprocessor.this.appView.appInfo()).mayPropagateValueFor((AppView<AppInfoWithLiveness>)TrivialFieldAccessReprocessor.this.appView, field)) {
                if (field.getAccessFlags().isStatic() == isStatic) {
                    if (isWrite) {
                        this.recordFieldAccessContext(definition, TrivialFieldAccessReprocessor.this.writtenFields, TrivialFieldAccessReprocessor.this.readFields);
                    } else {
                        this.recordFieldAccessContext(definition, TrivialFieldAccessReprocessor.this.readFields, TrivialFieldAccessReprocessor.this.writtenFields);
                    }
                } else {
                    this.destroyFieldAccessContexts(definition);
                }
            }
            if (TrivialFieldAccessReprocessor.this.constantFields.contains(definition) || !isWrite && TrivialFieldAccessReprocessor.this.nonConstantFields.contains(definition)) {
                TrivialFieldAccessReprocessor.this.methodsToReprocess.add((ProgramMethod)this.getContext());
            }
        }

        private boolean isUnusedReadAfterMethodStaticizing(DexClassAndField field, BytecodeInstructionMetadata metadata) {
            if (!metadata.isReadForInvokeReceiver() || field.getOptimizationInfo().getDynamicType().getNullability().isMaybeNull()) {
                return false;
            }
            Set<DexMethod> readForInvokeReceiver = metadata.getReadForInvokeReceiver();
            for (DexMethod methodReference : readForInvokeReceiver) {
                DexProgramClass holder;
                DexMethod rewrittenMethodReference = TrivialFieldAccessReprocessor.this.appView.graphLens().getRenamedMethodSignature(methodReference, TrivialFieldAccessReprocessor.this.appView.codeLens());
                ProgramMethod method = rewrittenMethodReference.lookupOnProgramClass(holder = DexProgramClass.asProgramClassOrNull(TrivialFieldAccessReprocessor.this.appView.definitionFor(rewrittenMethodReference.getHolderType())));
                if (method == null) {
                    assert (false);
                    return false;
                }
                if (((DexEncodedMethod)method.getDefinition()).isStatic()) continue;
                return false;
            }
            return true;
        }

        private void recordAccessThatCannotBeOptimized(DexClassAndField field, DexEncodedField definition) {
            TrivialFieldAccessReprocessor.this.constantFields.remove(definition);
            if (field.isProgramField() && ((AppInfoWithLiveness)TrivialFieldAccessReprocessor.this.appView.appInfo()).mayPropagateValueFor((AppView<AppInfoWithLiveness>)TrivialFieldAccessReprocessor.this.appView, field)) {
                this.destroyFieldAccessContexts(definition);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recordFieldAccessContext(DexEncodedField field, Map<DexEncodedField, AbstractAccessContexts> fieldAccesses, Map<DexEncodedField, AbstractAccessContexts> otherFieldAccesses) {
            DexEncodedField dexEncodedField = field;
            synchronized (dexEncodedField) {
                AbstractAccessContexts otherAccessContexts = otherFieldAccesses.getOrDefault(field, AbstractAccessContexts.empty());
                if (otherAccessContexts.isBottom()) {
                    AbstractAccessContexts accessContexts = fieldAccesses.computeIfAbsent(field, ignore -> new AbstractAccessContexts.ConcreteAccessContexts());
                    assert (accessContexts.isConcrete());
                    accessContexts.asConcrete().recordAccess((DexField)field.getReference(), (ProgramMethod)this.getContext());
                } else if (!otherAccessContexts.isTop()) {
                    fieldAccesses.put(field, AbstractAccessContexts.unknown());
                    otherFieldAccesses.put(field, AbstractAccessContexts.unknown());
                } else {
                    assert (fieldAccesses.getOrDefault(field, AbstractAccessContexts.empty()).isTop());
                    assert (otherFieldAccesses.getOrDefault(field, AbstractAccessContexts.empty()).isTop());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroyFieldAccessContexts(DexEncodedField field) {
            DexEncodedField dexEncodedField = field;
            synchronized (dexEncodedField) {
                TrivialFieldAccessReprocessor.this.readFields.put(field, AbstractAccessContexts.unknown());
                TrivialFieldAccessReprocessor.this.writtenFields.put(field, AbstractAccessContexts.unknown());
            }
        }

        @Override
        public void registerInstanceFieldRead(DexField field) {
            this.registerFieldAccess(field, false, false, BytecodeInstructionMetadata.none());
        }

        @Override
        public void registerInstanceFieldReadInstruction(CfOrDexInstanceFieldRead instruction) {
            BytecodeInstructionMetadata metadata = ((DexEncodedMethod)((ProgramMethod)this.getContext()).getDefinition()).getCode().getMetadata(instruction);
            this.registerFieldAccess(instruction.getField(), false, false, metadata);
        }

        @Override
        public void registerInstanceFieldWrite(DexField field) {
            this.registerFieldAccess(field, false, true, null);
        }

        @Override
        public void registerStaticFieldRead(DexField field) {
            this.registerFieldAccess(field, true, false, BytecodeInstructionMetadata.none());
        }

        @Override
        public void registerStaticFieldReadInstruction(CfOrDexStaticFieldRead instruction) {
            BytecodeInstructionMetadata metadata = ((DexEncodedMethod)((ProgramMethod)this.getContext()).getDefinition()).getCode().getMetadata(instruction);
            this.registerFieldAccess(instruction.getField(), true, false, metadata);
        }

        @Override
        public void registerStaticFieldWrite(DexField field) {
            this.registerFieldAccess(field, true, true, null);
        }

        @Override
        public void registerInitClass(DexType clazz) {
        }

        @Override
        public void registerInvokeVirtual(DexMethod method) {
        }

        @Override
        public void registerInvokeDirect(DexMethod method) {
        }

        @Override
        public void registerInvokeStatic(DexMethod method) {
        }

        @Override
        public void registerInvokeInterface(DexMethod method) {
        }

        @Override
        public void registerInvokeSuper(DexMethod method) {
        }

        @Override
        public void registerNewInstance(DexType type) {
        }

        @Override
        public void registerTypeReference(DexType type) {
        }

        @Override
        public void registerInstanceOf(DexType type) {
        }
    }

    static enum FieldClassification {
        CONSTANT,
        NON_CONSTANT,
        UNKNOWN;

    }
}

