/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.fieldvalueanalysis;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;

public abstract class StaticFieldValues {
    public static Builder builder(DexProgramClass clazz) {
        return clazz.isEnum() ? EnumStaticFieldValues.builder() : EmptyStaticValues.builder();
    }

    public boolean isEnumStaticFieldValues() {
        return false;
    }

    public EnumStaticFieldValues asEnumStaticFieldValues() {
        return null;
    }

    public static class EmptyStaticValues
    extends StaticFieldValues {
        private static EmptyStaticValues INSTANCE = new EmptyStaticValues();

        private EmptyStaticValues() {
        }

        public static EmptyStaticValues getInstance() {
            return INSTANCE;
        }

        static com.android.tools.r8.ir.analysis.fieldvalueanalysis.StaticFieldValues$Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends com.android.tools.r8.ir.analysis.fieldvalueanalysis.StaticFieldValues$Builder {
            @Override
            public void recordStaticField(DexEncodedField staticField, AbstractValue value, DexItemFactory factory) {
            }

            @Override
            public StaticFieldValues build() {
                return EmptyStaticValues.getInstance();
            }
        }
    }

    public static class EnumStaticFieldValues
    extends StaticFieldValues {
        private final ImmutableMap<DexField, ObjectState> enumAbstractValues;

        public EnumStaticFieldValues(ImmutableMap<DexField, ObjectState> enumAbstractValues) {
            this.enumAbstractValues = enumAbstractValues;
        }

        static com.android.tools.r8.ir.analysis.fieldvalueanalysis.StaticFieldValues$Builder builder() {
            return new Builder();
        }

        @Override
        public boolean isEnumStaticFieldValues() {
            return true;
        }

        @Override
        public EnumStaticFieldValues asEnumStaticFieldValues() {
            return this;
        }

        public ObjectState getObjectStateForPossiblyPinnedField(DexField field) {
            return this.enumAbstractValues.get(field);
        }

        public static class Builder
        extends com.android.tools.r8.ir.analysis.fieldvalueanalysis.StaticFieldValues$Builder {
            private final ImmutableMap.Builder<DexField, ObjectState> enumObjectStateBuilder = ImmutableMap.builder();
            private AbstractValue valuesCandidateAbstractValue;

            Builder() {
            }

            @Override
            public void recordStaticField(DexEncodedField staticField, AbstractValue value, DexItemFactory factory) {
                if (factory.enumMembers.isValuesFieldCandidate(staticField, staticField.getHolderType())) {
                    if (value.isSingleFieldValue() && value.asSingleFieldValue().getObjectState().isEnumValuesObjectState()) {
                        assert (this.valuesCandidateAbstractValue == null || this.valuesCandidateAbstractValue.equals(value));
                        this.valuesCandidateAbstractValue = value;
                        this.enumObjectStateBuilder.put((DexField)staticField.getReference(), value.asSingleFieldValue().getObjectState());
                    }
                } else if (factory.enumMembers.isEnumField(staticField, staticField.getHolderType()) && value.isSingleFieldValue() && !value.asSingleFieldValue().getObjectState().isEmpty()) {
                    this.enumObjectStateBuilder.put((DexField)staticField.getReference(), value.asSingleFieldValue().getObjectState());
                }
            }

            @Override
            public StaticFieldValues build() {
                ImmutableMap<DexField, ObjectState> enumAbstractValues = this.enumObjectStateBuilder.build();
                if (enumAbstractValues.isEmpty()) {
                    return EmptyStaticValues.getInstance();
                }
                assert (enumAbstractValues.values().stream().noneMatch(ObjectState::isEmpty));
                return new EnumStaticFieldValues(enumAbstractValues);
            }
        }
    }

    public static abstract class Builder {
        public abstract void recordStaticField(DexEncodedField var1, AbstractValue var2, DexItemFactory var3);

        public abstract StaticFieldValues build();
    }
}

