/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.framework.intraprocedural;

import com.android.tools.r8.ir.analysis.framework.intraprocedural.AbstractState;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.AbstractTransferFunction;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.DataflowAnalysisResult;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.TransferFunctionResult;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.WorkList;
import java.util.IdentityHashMap;
import java.util.Map;

public class IntraproceduralDataflowAnalysis<StateType extends AbstractState<StateType>> {
    private final StateType bottom;
    private final AbstractTransferFunction<StateType> transfer;
    private final Map<BasicBlock, StateType> blockExitStates = new IdentityHashMap<BasicBlock, StateType>();
    private final Map<BasicBlock, StateType> blockEntryStatesCache = new IdentityHashMap<BasicBlock, StateType>();

    public IntraproceduralDataflowAnalysis(StateType bottom, AbstractTransferFunction<StateType> transfer) {
        this.bottom = bottom;
        this.transfer = transfer;
    }

    private DataflowAnalysisResult run(WorkList<BasicBlock> worklist, Timing timing) {
        while (worklist.hasNext()) {
            BasicBlock initialBlock;
            BasicBlock block = initialBlock = worklist.next();
            BasicBlock end = null;
            AbstractState state = timing.time("Compute block entry state", () -> this.computeBlockEntryState(initialBlock));
            timing.begin("Compute transfers");
            do {
                for (Instruction instruction : block.getInstructions()) {
                    TransferFunctionResult<AbstractState> transferResult = this.transfer.apply(instruction, state);
                    if (transferResult.isFailedTransferResult()) {
                        timing.end();
                        return new DataflowAnalysisResult.FailedDataflowAnalysisResult();
                    }
                    assert (transferResult.isAbstractState());
                    state = transferResult.asAbstractState();
                }
                if (block.hasUniqueSuccessorWithUniquePredecessor()) {
                    block = block.getUniqueSuccessor();
                    continue;
                }
                end = block;
                block = null;
            } while (block != null);
            timing.end();
            if (this.setBlockExitState(end, state)) {
                worklist.addAllIgnoringSeenSet(end.getSuccessors());
            }
            this.updateBlockEntryStateCacheForSuccessors(end, state);
        }
        return new DataflowAnalysisResult.SuccessfulDataflowAnalysisResult<StateType>(this.blockExitStates);
    }

    private StateType computeBlockEntryState(BasicBlock block) {
        if (this.shouldCacheBlockEntryStateFor(block)) {
            return (StateType)((AbstractState)this.blockEntryStatesCache.getOrDefault(block, this.bottom));
        }
        AbstractState result = this.bottom;
        for (BasicBlock predecessor : block.getPredecessors()) {
            AbstractState edgeState = this.transfer.computeBlockEntryState(block, predecessor, (AbstractState)this.blockExitStates.getOrDefault(predecessor, this.bottom));
            result = result.join((AbstractState)edgeState);
        }
        return (StateType)result;
    }

    private boolean setBlockExitState(BasicBlock block, StateType state) {
        assert (!block.hasUniqueSuccessorWithUniquePredecessor());
        AbstractState previous = (AbstractState)this.blockExitStates.put(block, state);
        assert (previous == null || state.isGreaterThanOrEquals((AbstractState)previous));
        return !state.equals(previous);
    }

    private void updateBlockEntryStateCacheForSuccessors(BasicBlock block, StateType state) {
        for (BasicBlock successor : block.getSuccessors()) {
            if (!this.shouldCacheBlockEntryStateFor(successor)) continue;
            StateType edgeState = this.transfer.computeBlockEntryState(successor, block, state);
            AbstractState previous = (AbstractState)this.blockEntryStatesCache.getOrDefault(successor, this.bottom);
            this.blockEntryStatesCache.put(successor, previous.join(edgeState));
        }
    }

    private boolean shouldCacheBlockEntryStateFor(BasicBlock block) {
        return block.getPredecessors().size() > 2;
    }

    public DataflowAnalysisResult run(BasicBlock root) {
        return this.run(root, Timing.empty());
    }

    public DataflowAnalysisResult run(BasicBlock root, Timing timing) {
        return this.run(WorkList.newIdentityWorkList(root), timing);
    }
}

