/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.inlining;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.proto.ArgumentInfo;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.graph.proto.RemovedArgumentInfo;
import com.android.tools.r8.graph.proto.RewrittenTypeInfo;
import com.android.tools.r8.ir.analysis.inlining.AlwaysSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.NeverSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningArgumentConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraintFactory;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class NullSimpleInliningConstraint
extends SimpleInliningArgumentConstraint {
    private final Nullability nullability;

    private NullSimpleInliningConstraint(int argumentIndex, Nullability nullability) {
        super(argumentIndex);
        assert (nullability.isDefinitelyNull() || nullability.isDefinitelyNotNull());
        this.nullability = nullability;
    }

    static NullSimpleInliningConstraint create(int argumentIndex, Nullability nullability, SimpleInliningConstraintFactory witness) {
        assert (witness != null);
        return new NullSimpleInliningConstraint(argumentIndex, nullability);
    }

    @Override
    public SimpleInliningConstraint fixupAfterParametersChanged(AppView<AppInfoWithLiveness> appView, ArgumentInfoCollection changes, SimpleInliningConstraintFactory factory) {
        ArgumentInfo argumentInfo = changes.getArgumentInfo(this.getArgumentIndex());
        if (argumentInfo.isRemovedArgumentInfo()) {
            RemovedArgumentInfo removedArgumentInfo = changes.getArgumentInfo(this.getArgumentIndex()).asRemovedArgumentInfo();
            if (!removedArgumentInfo.hasSingleValue()) {
                assert (false);
                return NeverSimpleInliningConstraint.getInstance();
            }
            return removedArgumentInfo.getSingleValue().isNull() && this.nullability.isDefinitelyNull() ? AlwaysSimpleInliningConstraint.getInstance() : NeverSimpleInliningConstraint.getInstance();
        }
        if (argumentInfo.isRewrittenTypeInfo()) {
            RewrittenTypeInfo rewrittenTypeInfo = argumentInfo.asRewrittenTypeInfo();
            if (rewrittenTypeInfo.getNewType().isIntType()) {
                return this.nullability.isDefinitelyNull() ? factory.createEqualToNumberConstraint(this.getArgumentIndex(), 0L) : factory.createNotEqualToNumberConstraint(this.getArgumentIndex(), 0L);
            }
            return this;
        }
        return this.withArgumentIndex(changes.getNewArgumentIndex(this.getArgumentIndex()), factory);
    }

    @Override
    public final boolean isSatisfied(InvokeMethod invoke) {
        Value argument = this.getArgument(invoke);
        TypeElement argumentType = argument.getType();
        assert (argumentType.isReferenceType());
        if (argumentType.nullability() == this.nullability) {
            return true;
        }
        return argument.isDefinedByInstructionSatisfying(Instruction::isAssume) && argument.getAliasedValue().getType().nullability() == this.nullability;
    }

    @Override
    SimpleInliningArgumentConstraint withArgumentIndex(int argumentIndex, SimpleInliningConstraintFactory factory) {
        return factory.createNullConstraint(argumentIndex, this.nullability);
    }
}

