/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.inlining;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.graph.proto.RemovedArgumentInfo;
import com.android.tools.r8.ir.analysis.inlining.AlwaysSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.NeverSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningArgumentConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraintFactory;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public abstract class NumberSimpleInliningConstraint
extends SimpleInliningArgumentConstraint {
    private final long rawValue;

    NumberSimpleInliningConstraint(int argumentIndex, long rawValue) {
        super(argumentIndex);
        this.rawValue = rawValue;
    }

    long getRawValue() {
        return this.rawValue;
    }

    @Override
    public SimpleInliningConstraint fixupAfterParametersChanged(AppView<AppInfoWithLiveness> appView, ArgumentInfoCollection changes, SimpleInliningConstraintFactory factory) {
        if (changes.isArgumentRemoved(this.getArgumentIndex())) {
            RemovedArgumentInfo removedArgumentInfo = changes.getArgumentInfo(this.getArgumentIndex()).asRemovedArgumentInfo();
            if (!removedArgumentInfo.hasSingleValue()) {
                assert (false);
                return NeverSimpleInliningConstraint.getInstance();
            }
            SingleValue singleValue = removedArgumentInfo.getSingleValue();
            return singleValue.isSingleNumberValue() && this.test(singleValue.asSingleNumberValue().getValue()) ? AlwaysSimpleInliningConstraint.getInstance() : NeverSimpleInliningConstraint.getInstance();
        }
        assert (!changes.hasArgumentInfo(this.getArgumentIndex()));
        return this.withArgumentIndex(changes.getNewArgumentIndex(this.getArgumentIndex()), factory);
    }

    @Override
    public final boolean isSatisfied(InvokeMethod invoke) {
        Value argumentRoot = this.getArgument(invoke).getAliasedValue();
        return argumentRoot.isDefinedByInstructionSatisfying(Instruction::isConstNumber) && this.test(argumentRoot.getDefinition().asConstNumber().getRawValue());
    }

    abstract boolean test(long var1);
}

