/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.inlining;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.analysis.inlining.AlwaysSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.NeverSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraintConjunction;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraintDisjunction;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraintFactory;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.function.Supplier;

public abstract class SimpleInliningConstraint {
    public boolean isAlways() {
        return false;
    }

    public boolean isArgumentConstraint() {
        return false;
    }

    public boolean isConjunction() {
        return false;
    }

    public SimpleInliningConstraintConjunction asConjunction() {
        return null;
    }

    public boolean isDisjunction() {
        return false;
    }

    public SimpleInliningConstraintDisjunction asDisjunction() {
        return null;
    }

    public boolean isNever() {
        return false;
    }

    public abstract boolean isSatisfied(InvokeMethod var1);

    public final SimpleInliningConstraint meet(SimpleInliningConstraint other) {
        if (this.isAlways()) {
            return other;
        }
        if (other.isAlways()) {
            return this;
        }
        if (this.isNever() || other.isNever()) {
            return NeverSimpleInliningConstraint.getInstance();
        }
        if (this.isConjunction()) {
            return this.asConjunction().add(other);
        }
        if (other.isConjunction()) {
            return other.asConjunction().add(this);
        }
        assert (this.isArgumentConstraint() || this.isDisjunction());
        assert (other.isArgumentConstraint() || other.isDisjunction());
        return new SimpleInliningConstraintConjunction(ImmutableList.of(this, other));
    }

    public final SimpleInliningConstraint lazyMeet(Supplier<SimpleInliningConstraint> supplier) {
        if (this.isNever()) {
            return NeverSimpleInliningConstraint.getInstance();
        }
        return this.meet(supplier.get());
    }

    public final SimpleInliningConstraint join(SimpleInliningConstraint other) {
        if (this.isAlways() || other.isAlways()) {
            return AlwaysSimpleInliningConstraint.getInstance();
        }
        if (this.isNever()) {
            return other;
        }
        if (other.isNever()) {
            return this;
        }
        if (this.isDisjunction()) {
            return this.asDisjunction().add(other);
        }
        if (other.isDisjunction()) {
            return other.asDisjunction().add(this);
        }
        assert (this.isArgumentConstraint() || this.isConjunction());
        assert (other.isArgumentConstraint() || other.isConjunction());
        return new SimpleInliningConstraintDisjunction(ImmutableList.of(this, other));
    }

    public abstract SimpleInliningConstraint fixupAfterParametersChanged(AppView<AppInfoWithLiveness> var1, ArgumentInfoCollection var2, SimpleInliningConstraintFactory var3);
}

