/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.inlining;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.inlining.AlwaysSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.NeverSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraintFactory;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;

public class SimpleInliningConstraintAnalysis {
    private final SimpleInliningConstraintFactory factory;
    private final ProgramMethod method;
    private final InternalOptions options;
    private final int simpleInliningConstraintThreshold;
    private final Set<BasicBlock> seen = Sets.newIdentityHashSet();

    public SimpleInliningConstraintAnalysis(AppView<AppInfoWithLiveness> appView, ProgramMethod method) {
        this.factory = appView.simpleInliningConstraintFactory();
        this.method = method;
        this.options = appView.options();
        Objects.requireNonNull(appView.options());
        this.simpleInliningConstraintThreshold = 0;
    }

    private SimpleInliningConstraint analyzeInstructionsInBlock(BasicBlock block, int depth) {
        return this.analyzeInstructionsInBlock(block, depth, block.iterator());
    }

    private SimpleInliningConstraint analyzeInstructionsInBlock(BasicBlock block, int instructionDepth, InstructionIterator instructionIterator) {
        if (!this.seen.add(block)) {
            return NeverSimpleInliningConstraint.getInstance();
        }
        Instruction instruction = (Instruction)instructionIterator.next();
        while (!instruction.isJumpInstruction()) {
            assert (!instruction.isArgument());
            assert (!instruction.isDebugInstruction());
            if (!instruction.isAssume()) {
                ++instructionDepth;
            }
            instruction = (Instruction)instructionIterator.next();
        }
        if (instructionDepth > this.simpleInliningConstraintThreshold) {
            return NeverSimpleInliningConstraint.getInstance();
        }
        switch (instruction.opcode()) {
            case 25: {
                If ifInstruction = instruction.asIf();
                Value singleArgumentOperand = this.getSingleArgumentOperand(ifInstruction);
                if (singleArgumentOperand == null || singleArgumentOperand.isThis()) break;
                Value otherOperand = ifInstruction.isZeroTest() ? null : ifInstruction.getOperand(1 - ifInstruction.inValues().indexOf(singleArgumentOperand));
                int argumentIndex = singleArgumentOperand.getAliasedValue().getDefinition().asArgument().getIndex();
                DexType argumentType = ((DexEncodedMethod)this.method.getDefinition()).getArgumentType(argumentIndex);
                int currentDepth = instructionDepth;
                SimpleInliningConstraint trueTargetConstraint = this.computeConstraintFromIfTest(argumentIndex, argumentType, otherOperand, ifInstruction.getType()).lazyMeet(() -> this.analyzeInstructionsInBlock(ifInstruction.getTrueTarget(), currentDepth));
                SimpleInliningConstraint fallthroughTargetConstraint = this.computeConstraintFromIfTest(argumentIndex, argumentType, otherOperand, ifInstruction.getType().inverted()).lazyMeet(() -> this.analyzeInstructionsInBlock(ifInstruction.fallthroughBlock(), currentDepth));
                return trueTargetConstraint.join(fallthroughTargetConstraint);
            }
            case 24: {
                return this.analyzeInstructionsInBlock(instruction.asGoto().getTarget(), instructionDepth);
            }
            case 56: {
                return AlwaysSimpleInliningConstraint.getInstance();
            }
            case 65: {
                return block.hasCatchHandlers() ? NeverSimpleInliningConstraint.getInstance() : AlwaysSimpleInliningConstraint.getInstance();
            }
        }
        return NeverSimpleInliningConstraint.getInstance();
    }

    private SimpleInliningConstraint computeConstraintFromIfTest(int argumentIndex, DexType argumentType, Value otherOperand, If.Type type) {
        boolean isZeroTest = otherOperand == null;
        switch (type) {
            case EQ: {
                OptionalLong rawValue;
                if (isZeroTest) {
                    if (argumentType.isReferenceType()) {
                        return this.factory.createEqualToNullConstraint(argumentIndex);
                    }
                    if (argumentType.isBooleanType()) {
                        return this.factory.createEqualToFalseConstraint(argumentIndex);
                    }
                } else if (argumentType.isPrimitiveType() && (rawValue = this.getRawNumberValue(otherOperand)).isPresent()) {
                    return this.factory.createEqualToNumberConstraint(argumentIndex, rawValue.getAsLong());
                }
                return NeverSimpleInliningConstraint.getInstance();
            }
            case NE: {
                OptionalLong rawValue;
                if (isZeroTest) {
                    if (argumentType.isReferenceType()) {
                        return this.factory.createNotEqualToNullConstraint(argumentIndex);
                    }
                    if (argumentType.isBooleanType()) {
                        return this.factory.createEqualToTrueConstraint(argumentIndex);
                    }
                } else if (argumentType.isPrimitiveType() && (rawValue = this.getRawNumberValue(otherOperand)).isPresent()) {
                    return this.factory.createNotEqualToNumberConstraint(argumentIndex, rawValue.getAsLong());
                }
                return NeverSimpleInliningConstraint.getInstance();
            }
        }
        return NeverSimpleInliningConstraint.getInstance();
    }

    private OptionalLong getRawNumberValue(Value value) {
        Value root = value.getAliasedValue();
        if (root.isDefinedByInstructionSatisfying(Instruction::isConstNumber)) {
            return OptionalLong.of(root.getDefinition().asConstNumber().getRawValue());
        }
        return OptionalLong.empty();
    }

    private Value getSingleArgumentOperand(If ifInstruction) {
        Value rhs;
        Value singleArgumentOperand = null;
        Value lhs = ifInstruction.lhs();
        if (lhs.getAliasedValue().isArgument()) {
            singleArgumentOperand = lhs;
        }
        if (!ifInstruction.isZeroTest() && (rhs = ifInstruction.rhs()).getAliasedValue().isArgument()) {
            if (singleArgumentOperand != null) {
                return null;
            }
            singleArgumentOperand = rhs;
        }
        return singleArgumentOperand;
    }

    public SimpleInliningConstraint analyzeCode(IRCode code) {
        if (((DexMethod)this.method.getReference()).getArity() == 0) {
            return NeverSimpleInliningConstraint.getInstance();
        }
        if (this.options.debug) {
            return NeverSimpleInliningConstraint.getInstance();
        }
        InstructionIterator instructionIterator = code.entryBlock().iterator(code.getNumberOfArguments());
        return this.analyzeInstructionsInBlock(code.entryBlock(), 0, instructionIterator);
    }
}

