/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.inlining;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.analysis.inlining.AlwaysSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.NeverSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraintFactory;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ListUtils;
import java.util.List;

public class SimpleInliningConstraintConjunction
extends SimpleInliningConstraint {
    private final List<SimpleInliningConstraint> constraints;

    public SimpleInliningConstraintConjunction(List<SimpleInliningConstraint> constraints) {
        assert (constraints.size() > 1);
        assert (constraints.stream().noneMatch(SimpleInliningConstraint::isAlways));
        assert (constraints.stream().noneMatch(SimpleInliningConstraint::isConjunction));
        assert (constraints.stream().noneMatch(SimpleInliningConstraint::isNever));
        this.constraints = constraints;
    }

    SimpleInliningConstraint add(SimpleInliningConstraint constraint) {
        assert (!constraint.isAlways());
        assert (!constraint.isNever());
        if (constraint.isConjunction()) {
            return this.addAll(constraint.asConjunction());
        }
        assert (constraint.isArgumentConstraint() || constraint.isDisjunction());
        return new SimpleInliningConstraintConjunction((List<SimpleInliningConstraint>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.constraints)).add(constraint)).build()));
    }

    public SimpleInliningConstraintConjunction addAll(SimpleInliningConstraintConjunction conjunction) {
        return new SimpleInliningConstraintConjunction((List<SimpleInliningConstraint>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.constraints)).addAll(conjunction.constraints)).build()));
    }

    @Override
    public boolean isConjunction() {
        return true;
    }

    @Override
    public SimpleInliningConstraintConjunction asConjunction() {
        return this;
    }

    @Override
    public boolean isSatisfied(InvokeMethod invoke) {
        for (SimpleInliningConstraint constraint : this.constraints) {
            if (constraint.isSatisfied(invoke)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SimpleInliningConstraint fixupAfterParametersChanged(AppView<AppInfoWithLiveness> appView, ArgumentInfoCollection changes, SimpleInliningConstraintFactory factory) {
        List<SimpleInliningConstraint> rewrittenConstraints = ListUtils.mapOrElse(this.constraints, constraint -> {
            SimpleInliningConstraint rewrittenConstraint = constraint.fixupAfterParametersChanged(appView, changes, factory);
            if (rewrittenConstraint.isAlways()) {
                return null;
            }
            return rewrittenConstraint;
        }, null);
        if (rewrittenConstraints == null) {
            return this;
        }
        if (rewrittenConstraints.isEmpty()) {
            return AlwaysSimpleInliningConstraint.getInstance();
        }
        if (rewrittenConstraints.size() == 1) {
            return ListUtils.first(rewrittenConstraints);
        }
        if (Iterables.any(rewrittenConstraints, SimpleInliningConstraint::isNever)) {
            return NeverSimpleInliningConstraint.getInstance();
        }
        return new SimpleInliningConstraintConjunction(rewrittenConstraints);
    }
}

