/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.inlining;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.analysis.inlining.AlwaysSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.NeverSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraintFactory;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ListUtils;
import java.util.List;

public class SimpleInliningConstraintDisjunction
extends SimpleInliningConstraint {
    private final List<SimpleInliningConstraint> constraints;

    public SimpleInliningConstraintDisjunction(List<SimpleInliningConstraint> constraints) {
        assert (constraints.size() > 1);
        assert (constraints.stream().noneMatch(SimpleInliningConstraint::isAlways));
        assert (constraints.stream().noneMatch(SimpleInliningConstraint::isDisjunction));
        assert (constraints.stream().noneMatch(SimpleInliningConstraint::isNever));
        this.constraints = constraints;
    }

    SimpleInliningConstraint add(SimpleInliningConstraint constraint) {
        assert (!constraint.isAlways());
        assert (!constraint.isNever());
        if (constraint.isDisjunction()) {
            return this.addAll(constraint.asDisjunction());
        }
        assert (constraint.isArgumentConstraint() || constraint.isConjunction());
        return new SimpleInliningConstraintDisjunction((List<SimpleInliningConstraint>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.constraints)).add(constraint)).build()));
    }

    public SimpleInliningConstraintDisjunction addAll(SimpleInliningConstraintDisjunction disjunction) {
        return new SimpleInliningConstraintDisjunction((List<SimpleInliningConstraint>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.constraints)).addAll(disjunction.constraints)).build()));
    }

    @Override
    public boolean isDisjunction() {
        return true;
    }

    @Override
    public SimpleInliningConstraintDisjunction asDisjunction() {
        return this;
    }

    @Override
    public boolean isSatisfied(InvokeMethod invoke) {
        for (SimpleInliningConstraint constraint : this.constraints) {
            if (!constraint.isSatisfied(invoke)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SimpleInliningConstraint fixupAfterParametersChanged(AppView<AppInfoWithLiveness> appView, ArgumentInfoCollection changes, SimpleInliningConstraintFactory factory) {
        List<SimpleInliningConstraint> rewrittenConstraints = ListUtils.mapOrElse(this.constraints, constraint -> {
            SimpleInliningConstraint rewrittenConstraint = constraint.fixupAfterParametersChanged(appView, changes, factory);
            if (rewrittenConstraint.isNever()) {
                return null;
            }
            return rewrittenConstraint;
        }, null);
        if (rewrittenConstraints == null) {
            return this;
        }
        if (rewrittenConstraints.isEmpty()) {
            return NeverSimpleInliningConstraint.getInstance();
        }
        if (rewrittenConstraints.size() == 1) {
            return ListUtils.first(rewrittenConstraints);
        }
        if (Iterables.any(rewrittenConstraints, SimpleInliningConstraint::isAlways)) {
            return AlwaysSimpleInliningConstraint.getInstance();
        }
        return new SimpleInliningConstraintDisjunction(rewrittenConstraints);
    }
}

