/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.inlining;

import com.android.tools.r8.ir.analysis.inlining.EqualToBooleanSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.EqualToNumberSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.NotEqualToNumberSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.NullSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningArgumentConstraint;
import com.android.tools.r8.ir.analysis.type.Nullability;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class SimpleInliningConstraintFactory {
    private final EqualToBooleanSimpleInliningConstraint[] lowEqualToFalseConstraints = new EqualToBooleanSimpleInliningConstraint[5];
    private final EqualToBooleanSimpleInliningConstraint[] lowEqualToTrueConstraints = new EqualToBooleanSimpleInliningConstraint[5];
    private final NullSimpleInliningConstraint[] lowNotEqualToNullConstraints = new NullSimpleInliningConstraint[5];
    private final NullSimpleInliningConstraint[] lowEqualToNullConstraints = new NullSimpleInliningConstraint[5];
    private final Map<Integer, EqualToBooleanSimpleInliningConstraint> highEqualToFalseConstraints = new ConcurrentHashMap<Integer, EqualToBooleanSimpleInliningConstraint>();
    private final Map<Integer, EqualToBooleanSimpleInliningConstraint> highEqualToTrueConstraints = new ConcurrentHashMap<Integer, EqualToBooleanSimpleInliningConstraint>();
    private final Map<Integer, NullSimpleInliningConstraint> highNotEqualToNullConstraints = new ConcurrentHashMap<Integer, NullSimpleInliningConstraint>();
    private final Map<Integer, NullSimpleInliningConstraint> highEqualToNullConstraints = new ConcurrentHashMap<Integer, NullSimpleInliningConstraint>();

    public SimpleInliningConstraintFactory() {
        int i;
        for (i = 0; i < this.lowEqualToFalseConstraints.length; ++i) {
            this.lowEqualToFalseConstraints[i] = EqualToBooleanSimpleInliningConstraint.create(i, false, this);
        }
        for (i = 0; i < this.lowEqualToTrueConstraints.length; ++i) {
            this.lowEqualToTrueConstraints[i] = EqualToBooleanSimpleInliningConstraint.create(i, true, this);
        }
        for (i = 0; i < this.lowNotEqualToNullConstraints.length; ++i) {
            this.lowNotEqualToNullConstraints[i] = NullSimpleInliningConstraint.create(i, Nullability.definitelyNotNull(), this);
        }
        for (i = 0; i < this.lowEqualToNullConstraints.length; ++i) {
            this.lowEqualToNullConstraints[i] = NullSimpleInliningConstraint.create(i, Nullability.definitelyNull(), this);
        }
    }

    private <T extends SimpleInliningArgumentConstraint> T createArgumentConstraint(int argumentIndex, T[] lowConstraints, Map<Integer, T> highConstraints, Supplier<T> fn) {
        return (T)(argumentIndex < lowConstraints.length ? lowConstraints[argumentIndex] : highConstraints.computeIfAbsent(argumentIndex, key -> (SimpleInliningArgumentConstraint)fn.get()));
    }

    public EqualToBooleanSimpleInliningConstraint createEqualToFalseConstraint(int argumentIndex) {
        return this.createEqualToBooleanConstraint(argumentIndex, false);
    }

    public EqualToBooleanSimpleInliningConstraint createEqualToTrueConstraint(int argumentIndex) {
        return this.createEqualToBooleanConstraint(argumentIndex, true);
    }

    public EqualToBooleanSimpleInliningConstraint createEqualToBooleanConstraint(int argumentIndex, boolean value) {
        return (EqualToBooleanSimpleInliningConstraint)this.createArgumentConstraint(argumentIndex, value ? this.lowEqualToTrueConstraints : this.lowEqualToFalseConstraints, value ? this.highEqualToTrueConstraints : this.highEqualToFalseConstraints, () -> EqualToBooleanSimpleInliningConstraint.create(argumentIndex, value, this));
    }

    public NullSimpleInliningConstraint createEqualToNullConstraint(int argumentIndex) {
        return this.createNullConstraint(argumentIndex, Nullability.definitelyNull());
    }

    public NullSimpleInliningConstraint createNotEqualToNullConstraint(int argumentIndex) {
        return this.createNullConstraint(argumentIndex, Nullability.definitelyNotNull());
    }

    public NullSimpleInliningConstraint createNullConstraint(int argumentIndex, Nullability nullability) {
        return (NullSimpleInliningConstraint)this.createArgumentConstraint(argumentIndex, nullability.isDefinitelyNull() ? this.lowEqualToNullConstraints : this.lowNotEqualToNullConstraints, nullability.isDefinitelyNull() ? this.highEqualToNullConstraints : this.highNotEqualToNullConstraints, () -> NullSimpleInliningConstraint.create(argumentIndex, nullability, this));
    }

    public NotEqualToNumberSimpleInliningConstraint createNotEqualToNumberConstraint(int argumentIndex, long rawValue) {
        return NotEqualToNumberSimpleInliningConstraint.create(argumentIndex, rawValue, this);
    }

    public EqualToNumberSimpleInliningConstraint createEqualToNumberConstraint(int argumentIndex, long rawValue) {
        return EqualToNumberSimpleInliningConstraint.create(argumentIndex, rawValue, this);
    }
}

