/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessInfo;
import com.android.tools.r8.graph.FieldAccessInfoCollection;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.IRCodeUtils;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.OneTimeMethodProcessor;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.DefaultTreePrunerConfiguration;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.shaking.TreePrunerConfiguration;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class GeneratedExtensionRegistryShrinker {
    private final AppView<AppInfoWithLiveness> appView;
    private final InternalOptions options;
    private final ProtoReferences references;
    private final Map<DexType, Map<DexField, Enqueuer.Mode>> removedExtensionFields = new IdentityHashMap<DexType, Map<DexField, Enqueuer.Mode>>();

    GeneratedExtensionRegistryShrinker(AppView<AppInfoWithLiveness> appView, ProtoReferences references) {
        assert (appView.options().protoShrinking().enableGeneratedExtensionRegistryShrinking);
        this.appView = appView;
        this.options = appView.options();
        this.references = references;
    }

    private void recordDeadProtoExtensionField(DexField field, Enqueuer.Mode mode) {
        assert (mode.isInitialTreeShaking() || mode.isFinalTreeShaking());
        this.removedExtensionFields.computeIfAbsent(field.getHolderType(), ignore -> new IdentityHashMap()).put(field, mode);
    }

    private TreePrunerConfiguration createTreePrunerConfiguration(Enqueuer.Mode mode) {
        if (mode.isFinalTreeShaking()) {
            return new DefaultTreePrunerConfiguration(){

                @Override
                public boolean isReachableOrReferencedField(AppInfoWithLiveness appInfo, DexEncodedField field) {
                    return !GeneratedExtensionRegistryShrinker.this.wasRemoved((DexField)field.getReference()) && super.isReachableOrReferencedField(appInfo, field);
                }
            };
        }
        return DefaultTreePrunerConfiguration.getInstance();
    }

    private void rewriteClassInitializer(IRCode code) {
        ArrayList<StaticPut> toBeRemoved = new ArrayList<StaticPut>();
        for (StaticPut staticPut : code.instructions(Instruction::isStaticPut)) {
            if (!this.wasRemoved(staticPut.getField())) continue;
            toBeRemoved.add(staticPut);
        }
        for (StaticPut instruction : toBeRemoved) {
            if (!instruction.hasBlock()) continue;
            IRCodeUtils.removeInstructionAndTransitiveInputsIfNotUsed(code, instruction);
        }
    }

    private void forEachMethodThatRequiresPostOptimization(Consumer<ProgramMethod> consumer) {
        this.forEachClassInitializerWithRemovedExtensionFields(consumer, Enqueuer.Mode.FINAL_TREE_SHAKING);
        this.forEachFindLiteExtensionByNumberMethod(consumer);
    }

    private void forEachClassInitializerWithRemovedExtensionFields(Consumer<ProgramMethod> consumer, Enqueuer.Mode modeOfInterest) {
        Set classesWithRemovedExtensionFieldsInModeOfInterest = Sets.newIdentityHashSet();
        this.removedExtensionFields.values().forEach(removedExtensionFieldsForHolder -> removedExtensionFieldsForHolder.forEach((field, mode) -> {
            if (mode == modeOfInterest) {
                classesWithRemovedExtensionFieldsInModeOfInterest.add(field.getHolderType());
            }
        }));
        classesWithRemovedExtensionFieldsInModeOfInterest.forEach(type -> {
            DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.appInfo().definitionFor((DexType)type));
            if (clazz != null && clazz.hasClassInitializer()) {
                consumer.accept(clazz.getProgramClassInitializer());
            }
        });
    }

    private void forEachFindLiteExtensionByNumberMethod(Consumer<ProgramMethod> consumer) {
        this.appView.appInfo().forEachInstantiatedSubType(this.references.extensionRegistryLiteType, clazz -> clazz.forEachProgramMethodMatching(definition -> this.references.isFindLiteExtensionByNumberMethod((DexMethod)definition.getReference()), consumer), lambda -> {
            assert (false);
        });
    }

    private void forEachDeadProtoExtensionField(Consumer<DexField> consumer) {
        FieldAccessInfoCollection<? extends FieldAccessInfo> fieldAccessInfoCollection = this.appView.appInfo().getFieldAccessInfoCollection();
        fieldAccessInfoCollection.forEach(info -> {
            DexField field = info.getField();
            if (this.isDeadProtoExtensionField(field)) {
                consumer.accept(field);
            }
        });
    }

    public TreePrunerConfiguration run(Enqueuer.Mode mode) {
        this.forEachDeadProtoExtensionField(field -> this.recordDeadProtoExtensionField((DexField)field, mode));
        this.appView.appInfo().getFieldAccessInfoCollection().removeIf((field, info) -> this.wasRemoved((DexField)field));
        return this.createTreePrunerConfiguration(mode);
    }

    public void rewriteCode(DexEncodedMethod method, IRCode code) {
        if (method.isClassInitializer() && this.removedExtensionFields.containsKey(method.getHolderType()) && code.metadata().mayHaveStaticPut()) {
            this.rewriteClassInitializer(code);
        }
    }

    public boolean wasRemoved(DexField field) {
        return this.removedExtensionFields.getOrDefault(field.getHolderType(), Collections.emptyMap()).containsKey(field);
    }

    public void postOptimizeGeneratedExtensionRegistry(IRConverter converter, ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("[Proto] Post optimize generated extension registry");
        ProgramMethodSet wave = ProgramMethodSet.create(this::forEachMethodThatRequiresPostOptimization);
        OneTimeMethodProcessor methodProcessor = OneTimeMethodProcessor.create(wave, this.appView);
        methodProcessor.forEachWaveWithExtension((method, methodProcessingContext) -> converter.processDesugaredMethod(method, OptimizationFeedbackIgnore.getInstance(), methodProcessor, methodProcessingContext), executorService);
        timing.end();
    }

    public void handleFailedOrUnknownFieldResolution(DexField fieldReference, ProgramMethod context, Enqueuer.Mode mode) {
        if (mode.isTreeShaking() && this.references.isFindLiteExtensionByNumberMethod(context)) {
            this.recordDeadProtoExtensionField(fieldReference, mode);
        }
    }

    public boolean isDeadProtoExtensionField(DexField fieldReference) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        ProgramField field = appInfo.resolveField(fieldReference).getSingleProgramField();
        return field != null && this.isDeadProtoExtensionField(field, appInfo.getFieldAccessInfoCollection(), appInfo.getKeepInfo());
    }

    public boolean isDeadProtoExtensionField(ProgramField field, FieldAccessInfoCollection<?> fieldAccessInfoCollection, KeepInfoCollection keepInfo) {
        if (keepInfo.getFieldInfo(field).isPinned(this.options)) {
            return false;
        }
        if (((DexField)field.getReference()).type != this.references.generatedExtensionType) {
            return false;
        }
        Object fieldAccessInfo = fieldAccessInfoCollection.get((DexField)field.getReference());
        if (fieldAccessInfo == null) {
            return false;
        }
        return fieldAccessInfo.isReadOnlyInMethodSatisfying(this.references::isFindLiteExtensionByNumberMethod);
    }
}

