/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import com.android.tools.r8.ir.analysis.proto.ProtoUtils;
import com.android.tools.r8.ir.analysis.proto.RawMessageInfoDecoder;
import com.android.tools.r8.ir.analysis.proto.RawMessageInfoEncoder;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoMessageInfo;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoObject;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.IRCodeUtils;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.OneTimeMethodProcessor;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.DependentMinimumKeepInfoCollection;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class GeneratedMessageLiteShrinker {
    private final AppView<?> appView;
    private final RawMessageInfoDecoder decoder;
    private final RawMessageInfoEncoder encoder;
    private final ProtoReferences references;
    private final TypeElement objectArrayType;
    private final TypeElement stringType;

    public GeneratedMessageLiteShrinker(AppView<?> appView, RawMessageInfoDecoder decoder, ProtoReferences references) {
        this.appView = appView;
        this.decoder = decoder;
        this.encoder = new RawMessageInfoEncoder(appView.dexItemFactory());
        this.references = references;
        this.objectArrayType = TypeElement.fromDexType(appView.dexItemFactory().objectArrayType, Nullability.definitelyNotNull(), appView);
        this.stringType = TypeElement.stringClassType(appView, Nullability.definitelyNotNull());
    }

    private void optimizeNewMutableInstance(AppView<AppInfoWithLiveness> appView, IRCode code) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        BasicBlockIterator blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            InstructionListIterator instructionIterator = block.listIterator(code);
            while (instructionIterator.hasNext()) {
                DexMethod instanceInitializerReference;
                ProgramMethod instanceInitializer;
                Instruction instruction = (Instruction)instructionIterator.next();
                DexType newMutableInstanceType = this.getNewMutableInstanceType(appView, instruction);
                if (newMutableInstanceType == null || (instanceInitializer = DexClassAndMethod.asProgramMethodOrNull(appView.definitionFor(instanceInitializerReference = appView.dexItemFactory().createInstanceInitializer(newMutableInstanceType, new DexType[0])))) == null || AccessControl.isMemberAccessible(instanceInitializer, (DexClass)instanceInitializer.getHolder(), code.context(), appView).isPossiblyFalse()) continue;
                NewInstance newInstance = ((NewInstance.Builder)((NewInstance.Builder)NewInstance.builder().setType(newMutableInstanceType).setFreshOutValue(code, newMutableInstanceType.toTypeElement(appView, Nullability.definitelyNotNull()))).setPosition(instruction)).build();
                instructionIterator.replaceCurrentInstruction(newInstance, affectedValues);
                InvokeDirect constructorInvoke = ((InvokeDirect.Builder)((InvokeDirect.Builder)((InvokeDirect.Builder)InvokeDirect.builder().setMethod(instanceInitializerReference)).setSingleArgument(newInstance.outValue())).setPosition(instruction)).build();
                if (block.hasCatchHandlers()) {
                    BasicBlock splitBlock = instructionIterator.splitCopyCatchHandlers(code, blockIterator, appView.options());
                    instructionIterator = splitBlock.listIterator(code);
                    instructionIterator.add(constructorInvoke);
                    BasicBlock previousBlock = blockIterator.previousUntil(previous -> previous == splitBlock);
                    assert (previousBlock != null);
                    blockIterator.next();
                    continue;
                }
                instructionIterator.add(constructorInvoke);
            }
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(appView).narrowing(affectedValues);
        }
    }

    private DexType getNewMutableInstanceType(AppView<AppInfoWithLiveness> appView, Instruction instruction) {
        if (!instruction.isInvokeMethodWithReceiver()) {
            return null;
        }
        InvokeMethodWithReceiver invoke = instruction.asInvokeMethodWithReceiver();
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (!this.references.isDynamicMethod(invokedMethod) && !this.references.isDynamicMethodBridge(invokedMethod)) {
            return null;
        }
        assert (invokedMethod.getParameter(0) == this.references.methodToInvokeType);
        if (!this.references.methodToInvokeMembers.isNewMutableInstanceEnum(invoke.getFirstNonReceiverArgument())) {
            return null;
        }
        TypeElement receiverType = invoke.getReceiver().getDynamicUpperBoundType(appView);
        if (!receiverType.isClassType()) {
            return null;
        }
        DexType rawReceiverType = receiverType.asClassType().getClassType();
        return appView.appInfo().isStrictSubtypeOf(rawReceiverType, this.references.generatedMessageLiteType) ? rawReceiverType : null;
    }

    private void forEachDynamicMethod(Consumer<ProgramMethod> consumer) {
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        this.appView.appInfoWithLiveness().forEachInstantiatedSubType(this.references.generatedMessageLiteType, clazz -> {
            DexMethod dynamicMethodReference = dexItemFactory.createMethod(clazz.type, this.references.dynamicMethodProto, this.references.dynamicMethodName);
            ProgramMethod dynamicMethod = clazz.lookupProgramMethod(dynamicMethodReference);
            if (dynamicMethod != null) {
                consumer.accept(dynamicMethod);
            }
        }, lambda -> {
            assert (false);
        });
    }

    private void rewriteDynamicMethod(ProgramMethod method, IRCode code) {
        InvokeMethod newMessageInfoInvoke = GeneratedMessageLiteShrinker.getNewMessageInfoInvoke(code, this.references);
        if (newMessageInfoInvoke != null) {
            Value objectsValue;
            Value infoValue = ProtoUtils.getInfoValueFromMessageInfoConstructionInvoke(newMessageInfoInvoke, this.references);
            ProtoMessageInfo protoMessageInfo = this.decoder.run(method, infoValue, objectsValue = ProtoUtils.getObjectsValueFromMessageInfoConstructionInvoke(newMessageInfoInvoke, this.references));
            if (protoMessageInfo != null) {
                this.rewriteArgumentsToNewMessageInfo(code, newMessageInfoInvoke, infoValue, protoMessageInfo);
                IRCodeUtils.removeArrayAndTransitiveInputsIfNotUsed(code, objectsValue.definition);
            } else assert (false);
        }
    }

    private void rewriteArgumentsToNewMessageInfo(IRCode code, InvokeMethod newMessageInfoInvoke, Value infoValue, ProtoMessageInfo protoMessageInfo) {
        this.rewriteInfoArgumentToNewMessageInfo(code, infoValue, protoMessageInfo);
        this.rewriteObjectsArgumentToNewMessageInfo(code, newMessageInfoInvoke, protoMessageInfo);
    }

    private void rewriteInfoArgumentToNewMessageInfo(IRCode code, Value infoValue, ProtoMessageInfo protoMessageInfo) {
        infoValue.definition.replace(new ConstString(code.createValue(this.stringType), this.encoder.encodeInfo(protoMessageInfo)), code);
    }

    private void rewriteObjectsArgumentToNewMessageInfo(IRCode code, InvokeMethod newMessageInfoInvoke, ProtoMessageInfo protoMessageInfo) {
        BasicBlock block = newMessageInfoInvoke.getBlock();
        InstructionListIterator instructionIterator = block.listIterator(code, newMessageInfoInvoke);
        Instruction previous = (Instruction)instructionIterator.previous();
        instructionIterator.setInsertionPosition(newMessageInfoInvoke.getPosition());
        assert (previous == newMessageInfoInvoke);
        List<ProtoObject> objects = this.encoder.encodeObjects(protoMessageInfo);
        Value sizeValue = instructionIterator.insertConstIntInstruction(code, this.appView.options(), objects.size());
        Value newObjectsValue = code.createValue(this.objectArrayType);
        instructionIterator.add(new NewArrayEmpty(newObjectsValue, sizeValue, this.appView.dexItemFactory().objectArrayType));
        for (int i = 0; i < objects.size(); ++i) {
            Value indexValue = instructionIterator.insertConstIntInstruction(code, this.appView.options(), i);
            Instruction materializingInstruction = objects.get(i).buildIR(this.appView, code);
            instructionIterator.add(materializingInstruction);
            instructionIterator.add(new ArrayPut(MemberType.OBJECT, newObjectsValue, indexValue, materializingInstruction.outValue()));
        }
        ProtoUtils.setObjectsValueForMessageInfoConstructionInvoke(newMessageInfoInvoke, newObjectsValue, this.references);
    }

    public static InvokeMethod getNewMessageInfoInvoke(IRCode code, ProtoReferences references) {
        for (Instruction instruction : code.instructions()) {
            InvokeMethod invoke;
            if (!instruction.isInvokeMethod() || !references.isMessageInfoConstructionMethod((invoke = instruction.asInvokeMethod()).getInvokedMethod())) continue;
            return invoke;
        }
        return null;
    }

    public void extendRootSet(DependentMinimumKeepInfoCollection dependentMinimumKeepInfo) {
        DexProgramClass generatedMessageLiteClass = DexProgramClass.asProgramClassOrNull(((AppInfo)this.appView.appInfo()).definitionForWithoutExistenceAssert(this.references.generatedMessageLiteType));
        if (generatedMessageLiteClass != null) {
            ProgramMethod dynamicMethod = generatedMessageLiteClass.lookupProgramMethod(this.references.dynamicMethod);
            if (dynamicMethod != null) {
                dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(dynamicMethod.getReference()).disallowOptimization();
            }
            this.references.forEachMethodReference(reference -> {
                DexProgramClass holder = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(reference.getHolderType()));
                ProgramMethod method = reference.lookupOnProgramClass(holder);
                if (method != null) {
                    dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(method.getReference()).disallowOptimization();
                }
            });
        }
    }

    public void run(IRCode code) {
        ProgramMethod method = code.context();
        if (this.references.isDynamicMethod((DexMethod)method.getReference())) {
            this.rewriteDynamicMethod(method, code);
        } else if (this.appView.hasLiveness()) {
            this.optimizeNewMutableInstance(this.appView.withLiveness(), code);
        }
    }

    public void postOptimizeDynamicMethods(IRConverter converter, ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("[Proto] Post optimize dynamic methods");
        ProgramMethodSet wave = ProgramMethodSet.create(this::forEachDynamicMethod);
        OneTimeMethodProcessor methodProcessor = OneTimeMethodProcessor.create(wave, this.appView);
        methodProcessor.forEachWaveWithExtension((method, methodProcessingContext) -> converter.processDesugaredMethod(method, OptimizationFeedbackIgnore.getInstance(), methodProcessor, methodProcessingContext), executorService);
        timing.end();
    }
}

