/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.code.CfOrDexInstruction;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import com.android.tools.r8.shaking.DefaultEnqueuerUseRegistry;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerUseRegistryFactory;
import java.util.ListIterator;

public class ProtoEnqueuerUseRegistry
extends DefaultEnqueuerUseRegistry {
    private static final EnqueuerUseRegistryFactory FACTORY = ProtoEnqueuerUseRegistry::new;
    private final ProtoReferences references;

    public ProtoEnqueuerUseRegistry(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod currentMethod, Enqueuer enqueuer, AndroidApiLevelCompute apiLevelCompute) {
        super(appView, currentMethod, enqueuer, apiLevelCompute);
        this.references = appView.protoShrinker().references;
    }

    public static EnqueuerUseRegistryFactory getFactory() {
        return FACTORY;
    }

    private boolean isStaticFieldReadForProtoSchemaDefinition(DexField field) {
        if (field == this.references.getDefaultInstanceField(this.getContextHolder())) {
            return true;
        }
        DexProgramClass holder = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(field.getHolderType()));
        return holder != null && holder.getInterfaces().contains(this.references.enumVerifierType) && field == this.references.getEnumVerifierInstanceField(holder);
    }

    @Override
    public void registerConstClass(DexType type, ListIterator<? extends CfOrDexInstruction> iterator2, boolean ignoreCompatRules) {
        if (this.references.isDynamicMethod(this.getContextMethod())) {
            this.enqueuer.addDeadProtoTypeCandidate(type);
            return;
        }
        super.registerConstClass(type, iterator2, ignoreCompatRules);
    }

    @Override
    public void registerStaticFieldRead(DexField field) {
        if (this.references.isDynamicMethod(this.getContextMethod()) && field.getHolderType() != this.getContextHolder().getType() && this.isStaticFieldReadForProtoSchemaDefinition(field)) {
            this.enqueuer.addDeadProtoTypeCandidate(field.getHolderType());
            return;
        }
        super.registerStaticFieldRead(field);
    }
}

