/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.DefaultInliningOracle;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.inliner.InliningReasonStrategy;

public class ProtoInliningReasonStrategy
implements InliningReasonStrategy {
    private static final int METHOD_TO_INVOKE_ARGUMENT_POSITION_IN_DYNAMIC_METHOD = 1;
    private final AppView<?> appView;
    private final InliningReasonStrategy parent;
    private final ProtoReferences references;

    public ProtoInliningReasonStrategy(AppView<?> appView, InliningReasonStrategy parent) {
        this.appView = appView;
        this.parent = parent;
        this.references = appView.protoShrinker().references;
    }

    private Inliner.Reason computeInliningReasonForDynamicMethod(InvokeMethod invoke, ProgramMethod target, ProgramMethod context) {
        if (this.references.isDynamicMethod(target) && this.references.isProtoLibraryClass(context.getHolder())) {
            return Inliner.Reason.NEVER;
        }
        Value methodToInvokeValue = invoke.inValues().get(1).getAliasedValue();
        if (methodToInvokeValue.isPhi()) {
            return Inliner.Reason.NEVER;
        }
        Instruction methodToInvokeDefinition = methodToInvokeValue.definition;
        if (!methodToInvokeDefinition.isStaticGet()) {
            return Inliner.Reason.NEVER;
        }
        ProtoReferences.MethodToInvokeMembers methodToInvokeMembers = this.references.methodToInvokeMembers;
        DexField field = methodToInvokeDefinition.asStaticGet().getField();
        if (methodToInvokeMembers.isMethodToInvokeWithSimpleBody(field)) {
            return Inliner.Reason.ALWAYS;
        }
        assert (field.holder != this.references.methodToInvokeType || methodToInvokeMembers.isMethodToInvokeWithNonSimpleBody(field));
        return Inliner.Reason.NEVER;
    }

    @Override
    public Inliner.Reason computeInliningReason(InvokeMethod invoke, ProgramMethod target, ProgramMethod context, DefaultInliningOracle oracle, MethodProcessor methodProcessor) {
        if (this.references.isAbstractGeneratedMessageLiteBuilder(context.getHolder()) && invoke.isInvokeSuper()) {
            return Inliner.Reason.ALWAYS;
        }
        return this.references.isDynamicMethod(target) || this.references.isDynamicMethodBridge(target) ? this.computeInliningReasonForDynamicMethod(invoke, target, context) : this.parent.computeInliningReason(invoke, target, context, oracle, methodProcessor);
    }
}

