/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto;

import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.Value;
import java.util.function.Consumer;

public class ProtoReferences {
    private final DexItemFactory dexItemFactory;
    public final DexType enumLiteType;
    public final DexType enumLiteMapType;
    public final DexType enumVerifierType;
    public final DexType extendableMessageType;
    public final DexType extensionDescriptorType;
    public final DexType extensionRegistryLiteType;
    public final DexType generatedExtensionType;
    public final DexType generatedMessageLiteType;
    public final DexType generatedMessageLiteBuilderType;
    public final DexType generatedMessageLiteExtendableBuilderType;
    public final DexType generatedMessageLiteExtendableMessageType;
    public final DexType rawMessageInfoType;
    public final DexType messageLiteType;
    public final DexType methodToInvokeType;
    public final DexType wireFormatFieldType;
    public final GeneratedExtensionMethods generatedExtensionMethods;
    public final GeneratedMessageLiteMethods generatedMessageLiteMethods;
    public final GeneratedMessageLiteBuilderMethods generatedMessageLiteBuilderMethods;
    public final GeneratedMessageLiteExtendableBuilderMethods generatedMessageLiteExtendableBuilderMethods;
    public final MethodToInvokeMembers methodToInvokeMembers;
    public final DexString defaultInstanceFieldName;
    public final DexString instanceFieldName;
    public final DexString internalValueMapFieldName;
    public final DexString dynamicMethodName;
    public final DexString findLiteExtensionByNumberName;
    public final DexString newBuilderMethodName;
    public final DexString findValueByNumberName;
    public final DexString protobufPackageDescriptorPrefix;
    public final DexProto dynamicMethodProto;
    public final DexProto findLiteExtensionByNumberProto;
    public final DexMethod dynamicMethod;
    public final DexMethod newMessageInfoMethod;
    public final DexMethod rawMessageInfoConstructor;

    public ProtoReferences(DexItemFactory factory) {
        this.dexItemFactory = factory;
        this.enumLiteType = factory.createType("Lcom/google/protobuf/Internal$EnumLite;");
        this.enumLiteMapType = factory.createType("Lcom/google/protobuf/Internal$EnumLiteMap;");
        this.enumVerifierType = factory.createType("Lcom/google/protobuf/Internal$EnumVerifier;");
        this.extendableMessageType = factory.createType("Lcom/google/protobuf/GeneratedMessageLite$ExtendableMessage;");
        this.extensionDescriptorType = factory.createType("Lcom/google/protobuf/GeneratedMessageLite$ExtensionDescriptor;");
        this.extensionRegistryLiteType = factory.createType("Lcom/google/protobuf/ExtensionRegistryLite;");
        this.generatedExtensionType = factory.createType("Lcom/google/protobuf/GeneratedMessageLite$GeneratedExtension;");
        this.generatedMessageLiteType = factory.createType("Lcom/google/protobuf/GeneratedMessageLite;");
        this.generatedMessageLiteBuilderType = factory.createType("Lcom/google/protobuf/GeneratedMessageLite$Builder;");
        this.generatedMessageLiteExtendableBuilderType = factory.createType("Lcom/google/protobuf/GeneratedMessageLite$ExtendableBuilder;");
        this.generatedMessageLiteExtendableMessageType = factory.createType("Lcom/google/protobuf/GeneratedMessageLite$ExtendableMessage;");
        this.rawMessageInfoType = factory.createType("Lcom/google/protobuf/RawMessageInfo;");
        this.messageLiteType = factory.createType("Lcom/google/protobuf/MessageLite;");
        this.methodToInvokeType = factory.createType("Lcom/google/protobuf/GeneratedMessageLite$MethodToInvoke;");
        this.wireFormatFieldType = factory.createType("Lcom/google/protobuf/WireFormat$FieldType;");
        this.defaultInstanceFieldName = factory.createString("DEFAULT_INSTANCE");
        this.instanceFieldName = factory.createString("INSTANCE");
        this.internalValueMapFieldName = factory.createString("internalValueMap");
        this.dynamicMethodName = factory.createString("dynamicMethod");
        this.findLiteExtensionByNumberName = factory.createString("findLiteExtensionByNumber");
        this.newBuilderMethodName = factory.createString("newBuilder");
        this.findValueByNumberName = factory.createString("findValueByNumber");
        this.protobufPackageDescriptorPrefix = factory.createString("Lcom/google/protobuf/");
        this.dynamicMethodProto = factory.createProto(factory.objectType, this.methodToInvokeType, factory.objectType, factory.objectType);
        this.findLiteExtensionByNumberProto = factory.createProto(this.generatedExtensionType, this.messageLiteType, factory.intType);
        this.dynamicMethod = factory.createMethod(this.generatedMessageLiteType, this.dynamicMethodProto, this.dynamicMethodName);
        this.newMessageInfoMethod = factory.createMethod(this.generatedMessageLiteType, factory.createProto(factory.objectType, this.messageLiteType, factory.stringType, factory.objectArrayType), factory.createString("newMessageInfo"));
        this.rawMessageInfoConstructor = factory.createMethod(this.rawMessageInfoType, factory.createProto(factory.voidType, this.messageLiteType, factory.stringType, factory.objectArrayType), factory.constructorMethodName);
        this.generatedExtensionMethods = new GeneratedExtensionMethods(factory);
        this.generatedMessageLiteMethods = new GeneratedMessageLiteMethods(factory);
        this.generatedMessageLiteBuilderMethods = new GeneratedMessageLiteBuilderMethods(factory);
        this.generatedMessageLiteExtendableBuilderMethods = new GeneratedMessageLiteExtendableBuilderMethods(factory);
        this.methodToInvokeMembers = new MethodToInvokeMembers(factory);
    }

    public void forEachMethodReference(Consumer<DexMethod> consumer) {
        this.generatedExtensionMethods.forEachMethodReference(consumer);
        this.generatedMessageLiteMethods.forEachMethodReference(consumer);
        this.generatedMessageLiteBuilderMethods.forEachMethodReference(consumer);
        this.generatedMessageLiteExtendableBuilderMethods.forEachMethodReference(consumer);
        this.methodToInvokeMembers.forEachMethodReference(consumer);
        consumer.accept(this.dynamicMethod);
        consumer.accept(this.newMessageInfoMethod);
        consumer.accept(this.rawMessageInfoConstructor);
    }

    public DexField getDefaultInstanceField(DexProgramClass holder) {
        return this.dexItemFactory.createField(holder.type, holder.type, this.defaultInstanceFieldName);
    }

    public DexField getEnumVerifierInstanceField(DexProgramClass holder) {
        return this.dexItemFactory.createField(holder.type, this.enumVerifierType, this.instanceFieldName);
    }

    public boolean isAbstractGeneratedMessageLiteBuilder(DexProgramClass clazz) {
        return clazz.type == this.generatedMessageLiteBuilderType || clazz.type == this.generatedMessageLiteExtendableBuilderType;
    }

    public boolean isDynamicMethod(DexMethod method) {
        return method.name == this.dynamicMethodName && method.proto == this.dynamicMethodProto;
    }

    public boolean isDynamicMethod(DexEncodedMethod encodedMethod) {
        return this.isDynamicMethod((DexMethod)encodedMethod.getReference());
    }

    public boolean isDynamicMethod(ProgramMethod method) {
        return this.isDynamicMethod((DexMethod)method.getReference());
    }

    public boolean isDynamicMethodBridge(DexMethod method) {
        return method == this.generatedMessageLiteMethods.dynamicMethodBridgeMethod || method == this.generatedMessageLiteMethods.dynamicMethodBridgeMethodWithObject;
    }

    public boolean isDynamicMethodBridge(DexEncodedMethod method) {
        return this.isDynamicMethodBridge((DexMethod)method.getReference());
    }

    public boolean isDynamicMethodBridge(ProgramMethod method) {
        return this.isDynamicMethodBridge((DexMethod)method.getReference());
    }

    public boolean isFindLiteExtensionByNumberMethod(DexMethod method) {
        return method.proto == this.findLiteExtensionByNumberProto && method.name.startsWith(this.findLiteExtensionByNumberName) && method.holder != this.extensionRegistryLiteType;
    }

    public boolean isFindLiteExtensionByNumberMethod(ProgramMethod method) {
        return this.isFindLiteExtensionByNumberMethod((DexMethod)method.getReference());
    }

    public boolean isGeneratedMessageLiteBuilder(DexProgramClass clazz) {
        return (clazz.superType == this.generatedMessageLiteBuilderType || clazz.superType == this.generatedMessageLiteExtendableBuilderType) && !this.isAbstractGeneratedMessageLiteBuilder(clazz);
    }

    public boolean isMessageInfoConstructionMethod(DexMethod method) {
        return method.match(this.newMessageInfoMethod) || method == this.rawMessageInfoConstructor;
    }

    public boolean isProtoLibraryClass(DexProgramClass clazz) {
        return clazz.type.descriptor.startsWith(this.protobufPackageDescriptorPrefix);
    }

    public class MethodToInvokeMembers {
        public final DexField buildMessageInfoField;
        public final DexField getDefaultInstanceField;
        public final DexField getMemoizedIsInitializedField;
        public final DexField getParserField;
        public final DexField newBuilderField;
        public final DexField newMutableInstanceField;
        public final DexField setMemoizedIsInitializedField;

        private MethodToInvokeMembers(DexItemFactory dexItemFactory) {
            this.buildMessageInfoField = dexItemFactory.createField(ProtoReferences.this.methodToInvokeType, ProtoReferences.this.methodToInvokeType, "BUILD_MESSAGE_INFO");
            this.getDefaultInstanceField = dexItemFactory.createField(ProtoReferences.this.methodToInvokeType, ProtoReferences.this.methodToInvokeType, "GET_DEFAULT_INSTANCE");
            this.getMemoizedIsInitializedField = dexItemFactory.createField(ProtoReferences.this.methodToInvokeType, ProtoReferences.this.methodToInvokeType, "GET_MEMOIZED_IS_INITIALIZED");
            this.getParserField = dexItemFactory.createField(ProtoReferences.this.methodToInvokeType, ProtoReferences.this.methodToInvokeType, "GET_PARSER");
            this.newBuilderField = dexItemFactory.createField(ProtoReferences.this.methodToInvokeType, ProtoReferences.this.methodToInvokeType, "NEW_BUILDER");
            this.newMutableInstanceField = dexItemFactory.createField(ProtoReferences.this.methodToInvokeType, ProtoReferences.this.methodToInvokeType, "NEW_MUTABLE_INSTANCE");
            this.setMemoizedIsInitializedField = dexItemFactory.createField(ProtoReferences.this.methodToInvokeType, ProtoReferences.this.methodToInvokeType, "SET_MEMOIZED_IS_INITIALIZED");
        }

        public void forEachMethodReference(Consumer<DexMethod> consumer) {
        }

        public boolean isNewMutableInstanceEnum(DexField field) {
            return field == this.newMutableInstanceField;
        }

        public boolean isNewMutableInstanceEnum(Value value) {
            Value root = value.getAliasedValue();
            return !root.isPhi() && root.definition.isStaticGet() && this.isNewMutableInstanceEnum(root.definition.asStaticGet().getField());
        }

        public boolean isMethodToInvokeWithSimpleBody(DexField field) {
            return field == this.getDefaultInstanceField || field == this.getMemoizedIsInitializedField || field == this.newBuilderField || field == this.newMutableInstanceField || field == this.setMemoizedIsInitializedField;
        }

        public boolean isMethodToInvokeWithNonSimpleBody(DexField field) {
            return field == this.buildMessageInfoField || field == this.getParserField;
        }
    }

    public class GeneratedMessageLiteExtendableBuilderMethods {
        public final DexMethod buildPartialMethod;
        public final DexMethod constructorMethod;

        private GeneratedMessageLiteExtendableBuilderMethods(DexItemFactory dexItemFactory) {
            this.buildPartialMethod = dexItemFactory.createMethod(ProtoReferences.this.generatedMessageLiteExtendableBuilderType, dexItemFactory.createProto(ProtoReferences.this.extendableMessageType, new DexType[0]), "buildPartial");
            this.constructorMethod = dexItemFactory.createMethod(ProtoReferences.this.generatedMessageLiteExtendableBuilderType, dexItemFactory.createProto(dexItemFactory.voidType, ProtoReferences.this.generatedMessageLiteExtendableMessageType), dexItemFactory.constructorMethodName);
        }

        public void forEachMethodReference(Consumer<DexMethod> consumer) {
            consumer.accept(this.buildPartialMethod);
            consumer.accept(this.constructorMethod);
        }
    }

    public class GeneratedMessageLiteBuilderMethods {
        public final DexMethod constructorMethod;

        private GeneratedMessageLiteBuilderMethods(DexItemFactory dexItemFactory) {
            this.constructorMethod = dexItemFactory.createMethod(ProtoReferences.this.generatedMessageLiteBuilderType, dexItemFactory.createProto(dexItemFactory.voidType, ProtoReferences.this.generatedMessageLiteType), dexItemFactory.constructorMethodName);
        }

        public void forEachMethodReference(Consumer<DexMethod> consumer) {
            consumer.accept(this.constructorMethod);
        }
    }

    public class GeneratedMessageLiteMethods {
        public final DexMethod createBuilderMethod;
        public final DexMethod dynamicMethodBridgeMethod;
        public final DexMethod dynamicMethodBridgeMethodWithObject;
        public final DexMethod newRepeatedGeneratedExtension;
        public final DexMethod newSingularGeneratedExtension;

        private GeneratedMessageLiteMethods(DexItemFactory dexItemFactory) {
            this.createBuilderMethod = dexItemFactory.createMethod(ProtoReferences.this.generatedMessageLiteType, dexItemFactory.createProto(ProtoReferences.this.generatedMessageLiteBuilderType, new DexType[0]), "createBuilder");
            this.dynamicMethodBridgeMethod = dexItemFactory.createMethod(ProtoReferences.this.generatedMessageLiteType, dexItemFactory.createProto(dexItemFactory.objectType, ProtoReferences.this.methodToInvokeType), "dynamicMethod");
            this.dynamicMethodBridgeMethodWithObject = dexItemFactory.createMethod(ProtoReferences.this.generatedMessageLiteType, dexItemFactory.createProto(dexItemFactory.objectType, ProtoReferences.this.methodToInvokeType, dexItemFactory.objectType), "dynamicMethod");
            this.newRepeatedGeneratedExtension = dexItemFactory.createMethod(ProtoReferences.this.generatedMessageLiteType, dexItemFactory.createProto(ProtoReferences.this.generatedExtensionType, ProtoReferences.this.messageLiteType, ProtoReferences.this.messageLiteType, ProtoReferences.this.enumLiteMapType, dexItemFactory.intType, ProtoReferences.this.wireFormatFieldType, dexItemFactory.booleanType, dexItemFactory.classType), "newRepeatedGeneratedExtension");
            this.newSingularGeneratedExtension = dexItemFactory.createMethod(ProtoReferences.this.generatedMessageLiteType, dexItemFactory.createProto(ProtoReferences.this.generatedExtensionType, ProtoReferences.this.messageLiteType, dexItemFactory.objectType, ProtoReferences.this.messageLiteType, ProtoReferences.this.enumLiteMapType, dexItemFactory.intType, ProtoReferences.this.wireFormatFieldType, dexItemFactory.classType), "newSingularGeneratedExtension");
        }

        public void forEachMethodReference(Consumer<DexMethod> consumer) {
            consumer.accept(this.createBuilderMethod);
            consumer.accept(this.dynamicMethodBridgeMethod);
            consumer.accept(this.dynamicMethodBridgeMethodWithObject);
            consumer.accept(this.newRepeatedGeneratedExtension);
            consumer.accept(this.newSingularGeneratedExtension);
        }
    }

    public class GeneratedExtensionMethods {
        public final DexMethod constructor;
        public final DexMethod constructorWithClass;

        private GeneratedExtensionMethods(DexItemFactory dexItemFactory) {
            this.constructor = dexItemFactory.createMethod(ProtoReferences.this.generatedExtensionType, dexItemFactory.createProto(dexItemFactory.voidType, ProtoReferences.this.messageLiteType, dexItemFactory.objectType, ProtoReferences.this.messageLiteType, ProtoReferences.this.extensionDescriptorType), dexItemFactory.constructorMethodName);
            this.constructorWithClass = dexItemFactory.createMethod(ProtoReferences.this.generatedExtensionType, dexItemFactory.createProto(dexItemFactory.voidType, ProtoReferences.this.messageLiteType, dexItemFactory.objectType, ProtoReferences.this.messageLiteType, ProtoReferences.this.extensionDescriptorType, dexItemFactory.classType), dexItemFactory.constructorMethodName);
        }

        public void forEachMethodReference(Consumer<DexMethod> consumer) {
            consumer.accept(this.constructor);
            consumer.accept(this.constructorWithClass);
        }

        public boolean isConstructor(DexMethod method) {
            return method == this.constructor || method == this.constructorWithClass;
        }
    }
}

