/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto.schema;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.analysis.EnqueuerAnalysis;
import com.android.tools.r8.ir.analysis.proto.GeneratedMessageLiteShrinker;
import com.android.tools.r8.ir.analysis.proto.ProtoEnqueuerUseRegistry;
import com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import com.android.tools.r8.ir.analysis.proto.ProtoShrinker;
import com.android.tools.r8.ir.analysis.proto.RawMessageInfoDecoder;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldInfo;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldObject;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldType;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldTypeFactory;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoMessageInfo;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoObject;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoOneOfObjectPair;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.IRCodeUtils;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.FieldOptimizationInfo;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerWorklist;
import com.android.tools.r8.shaking.InstantiationReason;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.shaking.KeepReason;
import com.android.tools.r8.utils.BitUtils;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ProtoEnqueuerExtension
extends EnqueuerAnalysis {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final RawMessageInfoDecoder decoder;
    private final ProtoFieldTypeFactory factory;
    private final ProtoReferences references;
    private final Map<DexType, ProtoMessageInfo> liveProtos = new IdentityHashMap<DexType, ProtoMessageInfo>();
    private final Map<DexType, ProtoMessageInfo> seenButNotLiveProtos = new IdentityHashMap<DexType, ProtoMessageInfo>();
    private final Map<ProtoMessageInfo, OptionalBool> reachesMapOrRequiredFieldFromMessageCache = new IdentityHashMap<ProtoMessageInfo, OptionalBool>();
    private final Set<DexEncodedMethod> dynamicMethodsWithTracedProtoObjects = Sets.newIdentityHashSet();
    private final ProgramMethodSet findLiteExtensionByNumberMethods = ProgramMethodSet.create();
    private final Map<DexType, Set<DexType>> extensionGraph = new IdentityHashMap<DexType, Set<DexType>>();

    public ProtoEnqueuerExtension(AppView<? extends AppInfoWithClassHierarchy> appView) {
        ProtoShrinker protoShrinker = appView.protoShrinker();
        this.appView = appView;
        this.decoder = protoShrinker.decoder;
        this.factory = protoShrinker.factory;
        this.references = protoShrinker.references;
    }

    private void markGeneratedMessageLiteSubtypeAsInstantiated(DexProgramClass clazz, EnqueuerWorklist worklist) {
        if (clazz.isAbstract()) {
            assert (clazz.type == this.references.extendableMessageType);
            return;
        }
        ProgramMethod dynamicMethod = clazz.lookupProgramMethod(this.references.dynamicMethod);
        if (dynamicMethod != null) {
            worklist.enqueueMarkInstantiatedAction(clazz, dynamicMethod, InstantiationReason.REFLECTION, KeepReason.reflectiveUseIn(dynamicMethod));
        } else assert (false) : "Expected class `" + clazz.type.toSourceString() + "` to declare a dynamicMethod()";
    }

    private void createProtoMessageInfoFromDynamicMethod(ProgramMethod dynamicMethod, Map<DexType, ProtoMessageInfo> protos) {
        DexType holder = dynamicMethod.getHolderType();
        assert (!protos.containsKey(holder));
        IRCode code = dynamicMethod.buildIR(this.appView);
        InvokeMethod newMessageInfoInvoke = GeneratedMessageLiteShrinker.getNewMessageInfoInvoke(code, this.references);
        ProtoMessageInfo protoMessageInfo = newMessageInfoInvoke != null ? this.decoder.run(dynamicMethod, newMessageInfoInvoke) : null;
        protos.put(holder, protoMessageInfo);
    }

    private void populateExtensionGraph(Enqueuer enqueuer) {
        this.collectExtensionFields().forEach((clazz, extensionFields) -> {
            ProgramMethod clinit = clazz.getProgramClassInitializer();
            if (clinit == null) {
                assert (false);
                return;
            }
            IRCode code = clinit.buildIR(this.appView);
            Map<DexEncodedField, StaticPut> uniqueStaticPuts = IRCodeUtils.findUniqueStaticPuts(this.appView, code, extensionFields);
            for (DexEncodedField extensionField : extensionFields) {
                StaticPut staticPut = uniqueStaticPuts.get(extensionField);
                if (staticPut == null) {
                    assert (enqueuer.getMode().isFinalTreeShaking());
                    continue;
                }
                this.populateExtensionGraphWithExtensionFieldDefinition(staticPut);
            }
        });
        this.findLiteExtensionByNumberMethods.clear();
    }

    private Map<DexProgramClass, Set<DexEncodedField>> collectExtensionFields() {
        IdentityHashMap<DexProgramClass, Set<DexEncodedField>> extensionFieldsByClass = new IdentityHashMap<DexProgramClass, Set<DexEncodedField>>();
        for (ProgramMethod findLiteExtensionByNumberMethod : this.findLiteExtensionByNumberMethods) {
            IRCode code = findLiteExtensionByNumberMethod.buildIR(this.appView);
            Set<Phi> seenPhis = Sets.newIdentityHashSet();
            for (BasicBlock block : code.blocks(BasicBlock::isReturnBlock)) {
                Value returnValue = block.exit().asReturn().returnValue();
                this.collectExtensionFieldsFromValue(returnValue, seenPhis, field -> extensionFieldsByClass.computeIfAbsent(field.getHolder(), ignore -> Sets.newIdentityHashSet()).add((DexEncodedField)field.getDefinition()));
            }
        }
        return extensionFieldsByClass;
    }

    private void collectExtensionFieldsFromValue(Value returnValue, Set<Phi> seenPhis, Consumer<ProgramField> consumer) {
        Value root = returnValue.getAliasedValue();
        if (root.isPhi()) {
            Phi phi = root.asPhi();
            if (seenPhis.add(phi)) {
                for (Value operand : phi.getOperands()) {
                    this.collectExtensionFieldsFromValue(operand, seenPhis, consumer);
                }
            }
            return;
        }
        if (root.isZero()) {
            return;
        }
        Instruction definition = root.definition;
        if (definition.isStaticGet()) {
            StaticGet staticGet = definition.asStaticGet();
            DexClassAndField field = this.appView.appInfo().resolveField(staticGet.getField()).getResolutionPair();
            if (field == null || !field.isProgramField()) {
                assert (false);
                return;
            }
            consumer.accept(field.asProgramField());
            return;
        }
        assert (definition.isInvokeMethod() && this.references.isFindLiteExtensionByNumberMethod(definition.asInvokeMethod().getInvokedMethod()));
    }

    private void populateExtensionGraphWithExtensionFieldDefinition(StaticPut staticPut) {
        Value value = staticPut.value().getAliasedValue();
        if (value.isPhi()) {
            return;
        }
        Instruction extensionFactory = value.definition;
        if (extensionFactory.isNewInstance() && (extensionFactory = extensionFactory.asNewInstance().getUniqueConstructorInvoke(this.appView.dexItemFactory())) == null) {
            assert (false);
            return;
        }
        if (extensionFactory.isInvokeDirect() || extensionFactory.isInvokeStatic()) {
            TypeElement extensionType;
            TypeElement containerType;
            InvokeMethod invoke = extensionFactory.asInvokeMethod();
            DexMethod invokedMethod = invoke.getInvokedMethod();
            if (invokedMethod == this.references.generatedMessageLiteMethods.newRepeatedGeneratedExtension) {
                containerType = invoke.arguments().get(0).getType();
                extensionType = invoke.arguments().get(1).getType();
            } else if (invokedMethod == this.references.generatedMessageLiteMethods.newSingularGeneratedExtension) {
                containerType = invoke.arguments().get(0).getType();
                extensionType = invoke.arguments().get(2).getType();
            } else if (this.references.generatedExtensionMethods.isConstructor(invokedMethod)) {
                containerType = invoke.arguments().get(1).getType();
                extensionType = invoke.arguments().get(3).getType();
            } else {
                return;
            }
            if (extensionType.isNullType()) {
                return;
            }
            if (!containerType.isClassType() || !extensionType.isClassType()) {
                assert (false);
                return;
            }
            this.extensionGraph.computeIfAbsent(containerType.asClassType().getClassType(), ignore -> Sets.newIdentityHashSet()).add(extensionType.asClassType().getClassType());
        }
    }

    private void markMapOrRequiredFieldsAsReachable(Enqueuer enqueuer, EnqueuerWorklist worklist) {
        for (ProtoMessageInfo protoMessageInfo : this.liveProtos.values()) {
            if (protoMessageInfo == null || !protoMessageInfo.hasFields()) continue;
            ProgramMethod dynamicMethod = protoMessageInfo.getDynamicMethod();
            for (ProtoFieldInfo protoFieldInfo : protoMessageInfo.getFields()) {
                boolean valueStorageIsLive;
                ProgramField valueStorage = protoFieldInfo.getValueStorage(this.appView, protoMessageInfo);
                if (valueStorage == null) continue;
                if (enqueuer.isFieldLive(valueStorage)) {
                    if (enqueuer.isFieldRead(valueStorage) || enqueuer.isFieldWrittenOutsideDefaultConstructor(valueStorage) || this.reachesMapOrRequiredField(protoFieldInfo)) {
                        enqueuer.registerReflectiveFieldAccess((DexField)valueStorage.getReference(), dynamicMethod);
                    }
                    valueStorageIsLive = true;
                } else if (this.reachesMapOrRequiredField(protoFieldInfo)) {
                    enqueuer.registerReflectiveFieldAccess((DexField)valueStorage.getReference(), dynamicMethod);
                    worklist.enqueueMarkFieldAsReachableAction(valueStorage, dynamicMethod, KeepReason.reflectiveUseIn(dynamicMethod));
                    valueStorageIsLive = true;
                } else {
                    valueStorageIsLive = false;
                }
                ProgramField newlyLiveField = null;
                if (valueStorageIsLive) {
                    if (protoFieldInfo.getType().isOneOf()) {
                        newlyLiveField = protoFieldInfo.getOneOfCaseField(this.appView, protoMessageInfo);
                    } else if (protoFieldInfo.hasHazzerBitField(protoMessageInfo)) {
                        newlyLiveField = protoFieldInfo.getHazzerBitField(this.appView, protoMessageInfo);
                        enqueuer.registerReflectiveFieldAccess((DexField)valueStorage.getReference(), dynamicMethod);
                    }
                } else if (protoFieldInfo.getType().isOneOf()) {
                    ProgramField oneOfCaseField = protoFieldInfo.getOneOfCaseField(this.appView, protoMessageInfo);
                    if (oneOfCaseField != null && enqueuer.isFieldLive(oneOfCaseField)) {
                        newlyLiveField = valueStorage;
                    }
                } else if (protoFieldInfo.hasHazzerBitField(protoMessageInfo)) {
                    ProgramField hazzerBitField = protoFieldInfo.getHazzerBitField(this.appView, protoMessageInfo);
                    if (hazzerBitField == null || !enqueuer.isFieldLive(hazzerBitField)) continue;
                    if (this.appView.options().enableFieldBitAccessAnalysis && this.appView.isAllCodeProcessed()) {
                        FieldOptimizationInfo optimizationInfo = ((DexEncodedField)hazzerBitField.getDefinition()).getOptimizationInfo();
                        int hazzerBitIndex = protoFieldInfo.getHazzerBitFieldIndex(protoMessageInfo);
                        if (!BitUtils.isBitSet(optimizationInfo.getReadBits(), hazzerBitIndex)) continue;
                    }
                    newlyLiveField = valueStorage;
                }
                if (newlyLiveField == null) continue;
                ProgramMethod defaultInitializer = dynamicMethod.getHolder().getProgramDefaultInitializer();
                assert (defaultInitializer != null);
                Predicate<ProgramMethod> neitherDefaultConstructorNorDynamicMethod = writer -> !writer.isStructurallyEqualTo(defaultInitializer) && !writer.isStructurallyEqualTo(dynamicMethod);
                if (enqueuer.isFieldWrittenInMethodSatisfying(newlyLiveField, neitherDefaultConstructorNorDynamicMethod)) {
                    enqueuer.registerReflectiveFieldRead((DexField)newlyLiveField.getReference(), dynamicMethod);
                }
                if (!enqueuer.registerReflectiveFieldWrite((DexField)newlyLiveField.getReference(), dynamicMethod)) continue;
                worklist.enqueueMarkFieldAsReachableAction(newlyLiveField, dynamicMethod, KeepReason.reflectiveUseIn(dynamicMethod));
            }
            this.registerWriteToOneOfObjectsWithLiveOneOfCaseObject(protoMessageInfo, enqueuer, worklist);
        }
    }

    private void tracePendingInstructionsInDynamicMethods(Enqueuer enqueuer, EnqueuerWorklist worklist) {
        for (ProtoMessageInfo protoMessageInfo : this.liveProtos.values()) {
            ProgramMethod dynamicMethod;
            if (protoMessageInfo == null || !protoMessageInfo.hasFields() || !this.dynamicMethodsWithTracedProtoObjects.add((DexEncodedMethod)(dynamicMethod = protoMessageInfo.getDynamicMethod()).getDefinition())) continue;
            for (ProtoFieldInfo protoFieldInfo : protoMessageInfo.getFields()) {
                ProgramField valueStorage;
                List<ProtoObject> objects = protoFieldInfo.getObjects();
                if (objects == null || objects.isEmpty() || (valueStorage = protoFieldInfo.getValueStorage(this.appView, protoMessageInfo)) == null || !enqueuer.isFieldLive(valueStorage)) continue;
                for (ProtoObject object : objects) {
                    if (object.isProtoObjectFromStaticGet()) {
                        worklist.enqueueTraceStaticFieldRead(object.asProtoObjectFromStaticGet().getField(), dynamicMethod);
                        continue;
                    }
                    if (!object.isProtoTypeObject()) continue;
                    worklist.enqueueTraceConstClassAction(object.asProtoTypeObject().getType(), dynamicMethod, false);
                }
            }
        }
    }

    private void registerWriteToOneOfObjectsWithLiveOneOfCaseObject(ProtoMessageInfo protoMessageInfo, Enqueuer enqueuer, EnqueuerWorklist worklist) {
        if (protoMessageInfo.numberOfOneOfObjects() == 0) {
            return;
        }
        for (ProtoOneOfObjectPair oneOfObjectPair : protoMessageInfo.getOneOfObjects()) {
            this.registerWriteToOneOfObjectIfOneOfCaseObjectIsLive(oneOfObjectPair, enqueuer, worklist);
        }
    }

    private void registerWriteToOneOfObjectIfOneOfCaseObjectIsLive(ProtoOneOfObjectPair oneOfObjectPair, Enqueuer enqueuer, EnqueuerWorklist worklist) {
        ProtoFieldObject oneOfCaseObject = oneOfObjectPair.getOneOfCaseObject();
        if (!oneOfCaseObject.isLiveProtoFieldObject()) {
            assert (false);
            return;
        }
        DexField oneOfCaseFieldReference = oneOfCaseObject.asLiveProtoFieldObject().getField();
        FieldResolutionResult oneOfCaseFieldResolutionResult = this.appView.appInfo().resolveField(oneOfCaseFieldReference);
        if (!oneOfCaseFieldResolutionResult.isSingleProgramFieldResolutionResult()) {
            assert (false);
            return;
        }
        ProgramField oneOfCaseField = oneOfCaseFieldResolutionResult.getProgramField();
        if (oneOfCaseField == null) {
            assert (false);
            return;
        }
        ProgramMethod dynamicMethod = oneOfCaseField.getHolder().lookupProgramMethod(this.references.dynamicMethod);
        if (dynamicMethod == null) {
            assert (false);
            return;
        }
        if (!enqueuer.isFieldLive(oneOfCaseField)) {
            return;
        }
        ProtoFieldObject oneOfObject = oneOfObjectPair.getOneOfObject();
        if (!oneOfObject.isLiveProtoFieldObject()) {
            assert (false);
            return;
        }
        DexField oneOfFieldReference = oneOfObject.asLiveProtoFieldObject().getField();
        FieldResolutionResult oneOfFieldResolutionResult = this.appView.appInfo().resolveField(oneOfFieldReference);
        if (!oneOfFieldResolutionResult.isSingleProgramFieldResolutionResult()) {
            assert (false);
            return;
        }
        ProgramField oneOfField = oneOfFieldResolutionResult.getProgramField();
        if (oneOfField == null || oneOfField.getHolder() != oneOfCaseField.getHolder()) {
            assert (false);
            return;
        }
        if (enqueuer.registerReflectiveFieldWrite((DexField)oneOfField.getReference(), dynamicMethod)) {
            worklist.enqueueMarkFieldAsReachableAction(oneOfField, dynamicMethod, KeepReason.reflectiveUseIn(dynamicMethod));
        }
    }

    private boolean reachesMapOrRequiredField(ProtoFieldInfo protoFieldInfo) {
        ProtoFieldType protoFieldType = protoFieldInfo.getType();
        if (protoFieldType.isMap() || protoFieldType.isRequired()) {
            return true;
        }
        if (!this.appView.options().protoShrinking().traverseOneOfAndRepeatedProtoFields && (protoFieldType.isOneOf() || protoFieldType.isRepeated())) {
            return false;
        }
        DexType baseMessageType = protoFieldInfo.getBaseMessageType(this.factory);
        if (baseMessageType != null) {
            ProtoMessageInfo protoMessageInfo = this.getOrCreateProtoMessageInfo(baseMessageType);
            if (protoMessageInfo != null) {
                return this.reachesMapOrRequiredField(protoMessageInfo);
            }
            assert (false) : "Unable to find proto message info for `" + baseMessageType + "`";
        }
        return false;
    }

    private boolean reachesMapOrRequiredField(ProtoMessageInfo protoMessageInfo) {
        if (!protoMessageInfo.hasFields() && !this.extensionGraph.containsKey(protoMessageInfo.getType())) {
            return false;
        }
        OptionalBool cache = this.reachesMapOrRequiredFieldFromMessageCache.getOrDefault(protoMessageInfo, OptionalBool.unknown());
        if (!cache.isUnknown()) {
            return cache.isTrue();
        }
        this.reachesMapOrRequiredFieldFromMessageCache.put(protoMessageInfo, OptionalBool.of(false));
        if (protoMessageInfo.hasFields()) {
            for (ProtoFieldInfo protoFieldInfo : protoMessageInfo.getFields()) {
                if (!this.reachesMapOrRequiredField(protoFieldInfo)) continue;
                this.reachesMapOrRequiredFieldFromMessageCache.put(protoMessageInfo, OptionalBool.of(true));
                return true;
            }
        }
        Iterable extensionTypes = this.extensionGraph.getOrDefault(protoMessageInfo.getType(), ImmutableSet.of());
        for (DexType extensionType : extensionTypes) {
            ProtoMessageInfo protoExtensionMessageInfo = this.getOrCreateProtoMessageInfo(extensionType);
            assert (protoExtensionMessageInfo != null);
            if (!this.reachesMapOrRequiredField(protoExtensionMessageInfo)) continue;
            this.reachesMapOrRequiredFieldFromMessageCache.put(protoMessageInfo, OptionalBool.of(true));
            return true;
        }
        return false;
    }

    private ProtoMessageInfo getOrCreateProtoMessageInfo(DexType type) {
        if (this.liveProtos.containsKey(type)) {
            return this.liveProtos.get(type);
        }
        if (this.seenButNotLiveProtos.containsKey(type)) {
            return this.seenButNotLiveProtos.get(type);
        }
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(type));
        if (clazz == null) {
            this.seenButNotLiveProtos.put(type, null);
            return null;
        }
        ProgramMethod dynamicMethod = clazz.lookupProgramMethod(this.references.dynamicMethod);
        if (dynamicMethod == null) {
            this.seenButNotLiveProtos.put(type, null);
            return null;
        }
        this.createProtoMessageInfoFromDynamicMethod(dynamicMethod, this.seenButNotLiveProtos);
        return this.seenButNotLiveProtos.get(type);
    }

    @Override
    public void processNewlyLiveClass(DexProgramClass clazz, EnqueuerWorklist worklist) {
        assert (this.appView.appInfo().hasClassHierarchy());
        AppInfoWithClassHierarchy appInfo = this.appView.appInfo().withClassHierarchy();
        if (appInfo.isStrictSubtypeOf(clazz.type, this.references.generatedMessageLiteType)) {
            this.markGeneratedMessageLiteSubtypeAsInstantiated(clazz, worklist);
        }
    }

    @Override
    public void processNewlyLiveMethod(ProgramMethod method, ProgramDefinition context, Enqueuer enqueuer, EnqueuerWorklist worklist) {
        if (this.references.isFindLiteExtensionByNumberMethod((DexMethod)method.getReference())) {
            enqueuer.applyMinimumKeepInfoWhenLiveOrTargeted(method, KeepMethodInfo.newEmptyJoiner().disallowParameterReordering());
            this.findLiteExtensionByNumberMethods.add(method);
            return;
        }
        if (!this.references.isDynamicMethod(method)) {
            return;
        }
        DexType holderType = method.getHolderType();
        if (this.seenButNotLiveProtos.containsKey(holderType)) {
            this.liveProtos.put(holderType, this.seenButNotLiveProtos.remove(holderType));
            return;
        }
        assert (!this.liveProtos.containsKey(holderType));
        this.createProtoMessageInfoFromDynamicMethod(method, this.liveProtos);
    }

    @Override
    public void notifyFixpoint(Enqueuer enqueuer, EnqueuerWorklist worklist, Timing timing) {
        timing.begin("[Proto] Extend fixpoint");
        this.populateExtensionGraph(enqueuer);
        this.markMapOrRequiredFieldsAsReachable(enqueuer, worklist);
        if (enqueuer.getUseRegistryFactory() == ProtoEnqueuerUseRegistry.getFactory()) {
            assert (enqueuer.getMode().isFinalTreeShaking());
            if (worklist.isEmpty()) {
                this.tracePendingInstructionsInDynamicMethods(enqueuer, worklist);
            }
        }
        timing.end();
    }
}

