/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithLowerBound;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.ExactDynamicType;
import com.android.tools.r8.ir.analysis.type.NotNullDynamicType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;

public abstract class DynamicType {
    public static DynamicTypeWithUpperBound create(AppView<AppInfoWithLiveness> appView, TypeElement dynamicUpperBoundType) {
        ClassTypeElement dynamicUpperBoundClassType;
        DexClass dynamicUpperBoundClass;
        ClassTypeElement dynamicLowerBoundType = null;
        if (dynamicUpperBoundType.isClassType() && (dynamicUpperBoundClass = appView.definitionFor((dynamicUpperBoundClassType = dynamicUpperBoundType.asClassType()).getClassType())) != null && dynamicUpperBoundClass.isEffectivelyFinal(appView)) {
            dynamicLowerBoundType = dynamicUpperBoundClassType;
        }
        return DynamicType.create(appView, dynamicUpperBoundType, dynamicLowerBoundType);
    }

    public static DynamicTypeWithUpperBound create(AppView<AppInfoWithLiveness> appView, TypeElement dynamicUpperBoundType, ClassTypeElement dynamicLowerBoundType) {
        if (dynamicUpperBoundType.isBottom()) {
            return DynamicType.bottom();
        }
        if (dynamicUpperBoundType.isNullType()) {
            return DynamicType.definitelyNull();
        }
        if (dynamicUpperBoundType.isTop()) {
            return DynamicType.unknown();
        }
        if (dynamicLowerBoundType != null) {
            assert (dynamicUpperBoundType.isClassType());
            assert (dynamicUpperBoundType.nullability() == dynamicLowerBoundType.nullability());
            if (dynamicUpperBoundType.equals(dynamicLowerBoundType)) {
                return DynamicType.createExact(dynamicLowerBoundType);
            }
            return DynamicTypeWithLowerBound.create(appView, dynamicUpperBoundType.asClassType(), dynamicLowerBoundType);
        }
        assert (DynamicType.verifyNotEffectivelyFinalClassType(appView, dynamicUpperBoundType));
        return new DynamicTypeWithUpperBound(dynamicUpperBoundType);
    }

    public static ExactDynamicType createExact(ClassTypeElement exactDynamicType) {
        return new ExactDynamicType(exactDynamicType);
    }

    public static DynamicTypeWithUpperBound create(AppView<AppInfoWithLiveness> appView, Value value) {
        assert (value.getType().isReferenceType());
        TypeElement dynamicUpperBoundType = value.getDynamicUpperBoundType(appView);
        ClassTypeElement dynamicLowerBoundType = value.getDynamicLowerBoundType(appView, dynamicUpperBoundType, dynamicUpperBoundType.nullability());
        return DynamicType.create(appView, dynamicUpperBoundType, dynamicLowerBoundType);
    }

    public static DynamicTypeWithUpperBound bottom() {
        return DynamicTypeWithUpperBound.BOTTOM;
    }

    public static DynamicTypeWithUpperBound definitelyNull() {
        return DynamicTypeWithUpperBound.NULL_TYPE;
    }

    public static NotNullDynamicType definitelyNotNull() {
        return NotNullDynamicType.get();
    }

    public static DynamicTypeWithUpperBound unknown() {
        return DynamicTypeWithUpperBound.UNKNOWN;
    }

    public static DynamicType join(AppView<AppInfoWithLiveness> appView, Iterable<DynamicType> dynamicTypes) {
        DynamicType result = DynamicType.bottom();
        for (DynamicType dynamicType : dynamicTypes) {
            result = result.join(appView, dynamicType);
        }
        return result;
    }

    private static boolean verifyNotEffectivelyFinalClassType(AppView<AppInfoWithLiveness> appView, TypeElement type) {
        if (type.isClassType()) {
            ClassTypeElement classType = type.asClassType();
            DexClass clazz = appView.definitionFor(classType.getClassType());
            assert (clazz == null || !clazz.isEffectivelyFinal(appView));
        }
        return true;
    }

    public boolean hasDynamicUpperBoundType() {
        return false;
    }

    public abstract TypeElement getDynamicUpperBoundType(TypeElement var1);

    public boolean hasDynamicLowerBoundType() {
        return false;
    }

    public ClassTypeElement getDynamicLowerBoundType() {
        return null;
    }

    public abstract ClassTypeElement getExactClassType();

    public abstract Nullability getNullability();

    public boolean isBottom() {
        return false;
    }

    public boolean isDynamicTypeWithUpperBound() {
        return false;
    }

    public DynamicTypeWithUpperBound asDynamicTypeWithUpperBound() {
        return null;
    }

    public boolean isExactClassType() {
        return this.getExactClassType() != null;
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isNotNullType() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public DynamicType join(AppView<AppInfoWithLiveness> appView, DynamicType dynamicType) {
        if (this.isBottom()) {
            return dynamicType;
        }
        if (dynamicType.isBottom() || this.equals(dynamicType)) {
            return this;
        }
        if (this.isUnknown() || dynamicType.isUnknown()) {
            return DynamicType.unknown();
        }
        if (this.isNotNullType() || dynamicType.isNotNullType()) {
            if (this.getNullability().isNullable() || dynamicType.getNullability().isNullable()) {
                return DynamicType.unknown();
            }
            return DynamicType.definitelyNotNull();
        }
        assert (this.isDynamicTypeWithUpperBound());
        assert (dynamicType.isDynamicTypeWithUpperBound());
        return this.asDynamicTypeWithUpperBound().join(appView, dynamicType.asDynamicTypeWithUpperBound());
    }

    public abstract DynamicType rewrittenWithLens(AppView<AppInfoWithLiveness> var1, GraphLens var2, Set<DexType> var3);

    public abstract DynamicType withNullability(Nullability var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

